/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerSettingSyncConfigClient;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.roots.PhpSourceRootTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPsrComposerConfig
implements ComposerSettingSyncConfigClient<PhpPsrStructure> {
    private static final List<String> TAGS = List.of("autoload", "autoload-dev");
    private static final String PSR0 = "psr-0";
    private static final String PSR4 = "psr-4";
    private final Map<VirtualFile, PhpPsrStructure> myPsrStructures = new ConcurrentHashMap<VirtualFile, PhpPsrStructure>();

    @Override
    public boolean isAccept(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    public PhpPsrStructure parse(@NotNull Project project, @NotNull Map<String, JsonElement> elements, @NotNull VirtualFile config) {
        if (project == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(3);
        }
        if (config == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(4);
        }
        if (elements.isEmpty()) {
            return null;
        }
        PhpPsrStructure structure = new PhpPsrStructure(config);
        for (Map.Entry<String, JsonElement> entry : elements.entrySet()) {
            JsonElement element = entry.getValue();
            if (element == null || !element.isJsonObject()) continue;
            JsonObject object = element.getAsJsonObject();
            String name = entry.getKey();
            boolean isTest = StringUtil.isNotEmpty((String)name) && StringUtil.endsWith((CharSequence)name, (CharSequence)"-dev");
            PhpPsrComposerConfig.parsePsrRoot(structure, isTest, object.get(PSR4), true);
            PhpPsrComposerConfig.parsePsrRoot(structure, isTest, object.get(PSR0), false);
        }
        this.myPsrStructures.put(config, structure);
        return structure;
    }

    private static void parsePsrRoot(@NotNull PhpPsrStructure structure, boolean isTest, JsonElement psr, boolean withPrefix) {
        if (structure == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(5);
        }
        if (psr == null || !psr.isJsonObject()) {
            return;
        }
        for (Map.Entry entry : psr.getAsJsonObject().entrySet()) {
            String packagePrefix;
            JsonElement value = (JsonElement)entry.getValue();
            if (value == null) continue;
            String string = packagePrefix = withPrefix ? (String)entry.getKey() : "";
            if (value.isJsonPrimitive()) {
                structure.addPsrRoot(value.getAsJsonPrimitive().getAsString(), packagePrefix, isTest);
                continue;
            }
            if (!value.isJsonArray()) continue;
            for (JsonElement element : value.getAsJsonArray()) {
                if (!element.isJsonPrimitive()) continue;
                structure.addPsrRoot(element.getAsJsonPrimitive().getAsString(), packagePrefix, isTest);
            }
        }
    }

    @Override
    public void updateSetting(@NotNull Project project, @Nullable PhpPsrStructure psrStructure, @NotNull Runnable onSuccess) {
        if (project == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(6);
        }
        if (onSuccess == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(7);
        }
        if (psrStructure == null) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            String configPath = psrStructure.getConfig().getPath();
            Module module = PhpPsrComposerConfig.getModule(project, psrStructure.getConfig().getPath());
            if (module == null) {
                return null;
            }
            HashMap<String, PhpSourceRootTemplate> roots = new HashMap<String, PhpSourceRootTemplate>(psrStructure.getPsrRoots(configPath));
            for (Map.Entry<VirtualFile, PhpPsrStructure> entry : this.myPsrStructures.entrySet()) {
                if (psrStructure.getConfig().equals(entry.getKey())) continue;
                roots.putAll(entry.getValue().getPsrRoots(entry.getValue().getConfig().getPath()));
            }
            if (roots.isEmpty() || this.equals(module, roots)) {
                return null;
            }
            return new Pair((Object)module, roots);
        }).inSmartMode(project).finishOnUiThread(ModalityState.nonModal(), moduleAndRoots -> {
            if (moduleAndRoots != null) {
                PhpPsrNamespaceRootDetector.addSourceRoots((Module)moduleAndRoots.first, ((Map)moduleAndRoots.second).values());
                onSuccess.run();
            }
        }).submit((Executor)NonUrgentExecutor.getInstance());
    }

    @Override
    @NotNull
    public String getSettingTitle() {
        String string = PhpBundle.message(PlatformUtils.isPhpStorm() ? "actions.detect.namespace.roots.from.composer.title" : "actions.detect.namespace.roots.from.composer.idea.title", new Object[0]);
        if (string == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public ComposerLogMessageBuilder.Settings showSettings() {
        ComposerLogMessageBuilder.Settings settings = ComposerLogMessageBuilder.Settings.DIRECTORIES;
        if (settings == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(9);
        }
        return settings;
    }

    @Override
    public boolean isDefaultSettings(@NotNull Project project, @Nullable String composerJsonPath) {
        Module composerModule;
        if (project == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(10);
        }
        if ((composerModule = PhpPsrComposerConfig.getModule(project, composerJsonPath)) != null) {
            if (ModuleRootManager.getInstance((Module)composerModule).getSourceRoots(true).length != 0) {
                return false;
            }
        } else {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (ModuleRootManager.getInstance((Module)module).getSourceRoots(true).length == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static Module getModule(@NotNull Project project, @Nullable String composerJsonPath) {
        VirtualFile configFile;
        if (project == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(11);
        }
        if (StringUtil.isNotEmpty((String)composerJsonPath) && (configFile = LocalFileSystem.getInstance().findFileByPath(composerJsonPath)) != null) {
            return ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(configFile);
        }
        return null;
    }

    public boolean equals(@NotNull Module module, @NotNull Map<String, PhpSourceRootTemplate> detectedRoots) {
        ContentEntry[] contentEntries;
        if (module == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(12);
        }
        if (detectedRoots == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(13);
        }
        int count = 0;
        for (ContentEntry entry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            SourceFolder[] folders;
            for (SourceFolder folder : folders = entry.getSourceFolders()) {
                if (!detectedRoots.containsKey(folder.getUrl())) {
                    return false;
                }
                ++count;
                PhpSourceRootTemplate root = detectedRoots.get(folder.getUrl());
                if (PhpLangUtil.equalsNamespaceNames(folder.getPackagePrefix(), root.getPrefix())) continue;
                return false;
            }
        }
        return count >= detectedRoots.size();
    }

    @Override
    @NotNull
    public List<String> getPath() {
        List<String> list = TAGS;
        if (list == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/PhpPsrComposerConfig";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/PhpPsrComposerConfig";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingTitle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "showSettings";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAccept";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parsePsrRoot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateSetting";
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 14 -> new IllegalStateException(string);
        };
    }

    public static class PhpPsrStructure {
        private final List<PhpSourceRootTemplate> myPsrRoots;
        private final VirtualFile myConfig;

        public PhpPsrStructure(@NotNull VirtualFile config) {
            if (config == null) {
                PhpPsrStructure.$$$reportNull$$$0(0);
            }
            this.myPsrRoots = new SmartList();
            this.myConfig = config;
        }

        @NotNull
        public Map<String, PhpSourceRootTemplate> getPsrRoots(@NotNull String configPath) {
            if (configPath == null) {
                PhpPsrStructure.$$$reportNull$$$0(1);
            }
            if (this.myPsrRoots.isEmpty()) {
                Map<String, PhpSourceRootTemplate> map = Collections.emptyMap();
                if (map == null) {
                    PhpPsrStructure.$$$reportNull$$$0(2);
                }
                return map;
            }
            HashMap<String, PhpSourceRootTemplate> roots = new HashMap<String, PhpSourceRootTemplate>();
            String rootDir = PathUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)configPath));
            for (PhpSourceRootTemplate psrRoot : this.myPsrRoots) {
                String sourcePath = psrRoot.getSourcePath();
                Object absolute = FileUtil.isAbsolutePlatformIndependent((String)sourcePath) ? sourcePath : rootDir + "/" + sourcePath;
                String url = VfsUtilCore.pathToUrl((String)absolute);
                if (roots.containsKey(url) && (psrRoot.isTest() || !((PhpSourceRootTemplate)roots.get(url)).isTest())) continue;
                roots.put(url, PhpSourceRootTemplate.psr4((String)absolute, psrRoot.getPrefix(), psrRoot.isTest()));
            }
            HashMap<String, PhpSourceRootTemplate> hashMap = roots;
            if (hashMap == null) {
                PhpPsrStructure.$$$reportNull$$$0(3);
            }
            return hashMap;
        }

        public void addPsrRoot(@NotNull String root, @NotNull String prefix, boolean isTest) {
            if (root == null) {
                PhpPsrStructure.$$$reportNull$$$0(4);
            }
            if (prefix == null) {
                PhpPsrStructure.$$$reportNull$$$0(5);
            }
            String path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root), (String)"/");
            this.myPsrRoots.add(PhpSourceRootTemplate.psr4(path, prefix, isTest));
        }

        @NotNull
        public VirtualFile getConfig() {
            VirtualFile virtualFile = this.myConfig;
            if (virtualFile == null) {
                PhpPsrStructure.$$$reportNull$$$0(6);
            }
            return virtualFile;
        }

        public String toString() {
            return "PhpPsrStructure{myPsrRoots=" + StringUtil.join(this.myPsrRoots, root -> root.getSourcePath() + " " + (root.isTest() ? "(test)" : "(not test)"), (String)", ") + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configPath";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/roots/PhpPsrComposerConfig$PhpPsrStructure";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/roots/PhpPsrComposerConfig$PhpPsrStructure";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsrRoots";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfig";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getPsrRoots";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addPsrRoot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 6 -> new IllegalStateException(string);
            };
        }
    }
}

