/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.roots.PhpDirectoryProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPsrDirectoryComboBox
extends ComboboxWithBrowseButton {
    private final Project myProject;
    protected PhpDirectoryProvider myDirectoryProvider;
    private final String myProjectBasePath;
    protected VirtualFile myBaseDir;
    protected String myBaseNamespace;
    private ItemWrapper myInitialItem;
    private Condition<VirtualFile> myDirectoriesFilter;
    private boolean isDisposed;

    public PhpPsrDirectoryComboBox(@NotNull Project project) {
        if (project == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(0);
        }
        this(project, PhpDirectoryByPsrProvider.getDefaultProvider());
    }

    public PhpPsrDirectoryComboBox(@NotNull Project project, @NotNull PhpDirectoryProvider provider) {
        VirtualFile projectParent;
        if (project == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(2);
        }
        super((JComboBox)new ComboBoxWithWidePopup());
        this.myDirectoriesFilter = Conditions.alwaysTrue();
        this.isDisposed = false;
        this.myProject = project;
        this.myDirectoryProvider = provider;
        VirtualFile projectDir = project.getBaseDir();
        this.myProjectBasePath = projectDir != null ? ((projectParent = projectDir.getParent()) == null ? "" : projectParent.getPresentableUrl()) : "";
    }

    public void init(@NotNull VirtualFile baseDir, @NotNull String namespace) {
        if (baseDir == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(3);
        }
        if (namespace == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(4);
        }
        this.myBaseNamespace = namespace;
        this.myBaseDir = baseDir;
        String path = this.myBaseDir.getPresentableUrl();
        this.myInitialItem = this.addDirectory(this.getComboBox(), path, this.myBaseDir);
        this.setTextFieldPreferredWidth(path.length());
        final JComboBox comboBox = this.getComboBox();
        final FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        BasicComboBoxEditor editor = new BasicComboBoxEditor(){
            private ItemWrapper mySelectedItem;

            @Override
            public void setItem(Object anObject) {
                if (anObject instanceof ItemWrapper) {
                    this.mySelectedItem = (ItemWrapper)anObject;
                    this.editor.setText(((ItemWrapper)anObject).getFullPresentablePath());
                }
            }

            @Override
            public Object getItem() {
                String newPath = StringUtil.trimEnd((String)this.editor.getText(), (String)File.separator);
                if (PhpPsrDirectoryComboBox.this.myInitialItem != null && StringUtil.equals((CharSequence)newPath, (CharSequence)PhpPsrDirectoryComboBox.this.myInitialItem.getFullPresentablePath())) {
                    this.mySelectedItem = PhpPsrDirectoryComboBox.this.myInitialItem;
                } else if (this.mySelectedItem == PhpPsrDirectoryComboBox.this.myInitialItem) {
                    this.mySelectedItem = PhpPsrDirectoryComboBox.this.addDirectory(PhpPsrDirectoryComboBox.this.getComboBox(), newPath, PhpPsrDirectoryComboBox.findExistingParent(newPath));
                } else {
                    this.mySelectedItem.updatePath(newPath, PhpPsrDirectoryComboBox.findExistingParent(newPath));
                }
                comboBox.setSelectedItem(this.mySelectedItem);
                return this.mySelectedItem;
            }

            @Override
            protected JTextField createEditorComponent() {
                JTextField field = super.createEditorComponent();
                FileChooserFactory.getInstance().installFileCompletion(field, descriptor, false, (Disposable)PhpPsrDirectoryComboBox.this);
                return field;
            }
        };
        editor.getEditorComponent().addFocusListener(new FocusAdapter(this){

            @Override
            public void focusLost(FocusEvent e) {
                comboBox.setEditable(false);
            }
        });
        comboBox.setEditor(editor);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        comboBox.setRenderer(SimpleListCellRenderer.create((label, itemWrapper, index) -> {
            label.setText(itemWrapper.getPresentablePath());
            Icon icon = itemWrapper.getIcon((FileIndex)fileIndex);
            if (icon != null) {
                label.setIcon(icon);
            }
        }));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)PhpPsrDirectoryComboBox.this.myProject, (VirtualFile)PhpPsrDirectoryComboBox.this.getBaseDirectory());
                if (file != null) {
                    PhpPsrDirectoryComboBox.this.chooseFile(file);
                }
            }
        });
        comboBox.addKeyListener(new KeyAdapter(this){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    comboBox.setEditable(true);
                }
            }
        });
    }

    @NotNull
    public VirtualFile getBaseDirectory() {
        VirtualFile virtualFile = this.myBaseDir;
        if (virtualFile == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    public void setDirectoriesFilter(@NotNull Condition<VirtualFile> filter) {
        if (filter == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(6);
        }
        this.myDirectoriesFilter = filter;
    }

    public void setDirectoryProvider(@NotNull PhpDirectoryProvider directoryProvider) {
        if (directoryProvider == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(7);
        }
        this.myDirectoryProvider = directoryProvider;
    }

    public String getSelectedPath() {
        Object item = this.getComboBox().getSelectedItem();
        return ((ItemWrapper)item).getFullIndependentPath();
    }

    @Nullable
    public VirtualFile getExistingParent() {
        Object item = this.getComboBox().getSelectedItem();
        return ((ItemWrapper)item).getExistingParent();
    }

    public String getRelativePath() {
        Object item = this.getComboBox().getSelectedItem();
        return ((ItemWrapper)item).getRelativePath();
    }

    @NotNull
    public List<String> suggestDirectories(@NotNull String namespace, @NotNull VirtualFile directory) {
        if (namespace == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(8);
        }
        if (directory == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(9);
        }
        List<String> list = this.myDirectoryProvider.suggestDirectories(this.myProject, namespace, directory, this.myBaseNamespace);
        if (list == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(10);
        }
        return list;
    }

    @ApiStatus.Internal
    public void updateDirectories(@NotNull String namespace) {
        if (namespace == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(11);
        }
        this.updateDirectoriesInternal(namespace, this.getBaseDirectory());
    }

    public void updateDirectories(@NotNull String namespace, @NotNull VirtualFile virtualFile) {
        if (namespace == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(12);
        }
        if (virtualFile == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(13);
        }
        List<String> directories = this.suggestDirectories(namespace, virtualFile);
        this.updateDirectoriesIfNotEmpty(directories);
    }

    private void updateDirectoriesInternal(@NotNull String namespace, @NotNull VirtualFile directory) {
        if (namespace == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(14);
        }
        if (directory == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(15);
        }
        ReadAction.nonBlocking(() -> this.suggestDirectories(namespace, directory)).finishOnUiThread(ModalityState.current(), this::updateDirectoriesIfNotEmpty).coalesceBy(new Object[]{this}).expireWhen(() -> this.isDisposed || this.myProject.isDisposed()).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void updateDirectoriesIfNotEmpty(@NotNull List<String> directories) {
        if (directories == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(16);
        }
        if (!directories.isEmpty()) {
            this.updateDirectories(directories);
        }
    }

    protected void chooseFile(@NotNull VirtualFile file) {
        if (file == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(17);
        }
        String path = file.getPresentableUrl();
        JComboBox comboBox = this.getComboBox();
        ItemWrapper item = this.addDirectory(comboBox, path, file);
        comboBox.setSelectedItem(item);
    }

    private void updateDirectories(@NotNull Collection<String> directories) {
        if (directories == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(18);
        }
        JComboBox box = this.getComboBox();
        box.removeAllItems();
        Iterator<String> iterator = directories.iterator();
        String mainDirectory = iterator.next();
        VirtualFile mainParent = PhpPsrDirectoryComboBox.findExistingParent(mainDirectory);
        while (iterator.hasNext() && !this.myDirectoriesFilter.value((Object)mainParent)) {
            mainDirectory = iterator.next();
            mainParent = PhpPsrDirectoryComboBox.findExistingParent(mainDirectory);
        }
        if (!iterator.hasNext() && !this.myDirectoriesFilter.value((Object)mainParent)) {
            box.addItem(this.myInitialItem);
        } else {
            if (!StringUtil.equals((CharSequence)mainDirectory, (CharSequence)this.myInitialItem.getFullPresentablePath())) {
                box.addItem(this.myInitialItem);
            }
            box.setSelectedItem(this.addDirectory(box, mainDirectory, mainParent));
            while (iterator.hasNext()) {
                VirtualFile existingParent;
                String directory = iterator.next();
                if (StringUtil.equals((CharSequence)directory, (CharSequence)this.myInitialItem.getFullPresentablePath()) || !this.myDirectoriesFilter.value((Object)(existingParent = PhpPsrDirectoryComboBox.findExistingParent(directory)))) continue;
                this.addDirectory(box, directory, existingParent);
            }
        }
    }

    @Nullable
    private static VirtualFile findExistingParent(@NotNull String path) {
        if (path == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(19);
        }
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(path);
        return directory == null ? PhpPsrDirectoryComboBox.findExistingParent(PathUtil.getParentPath((String)path)) : directory;
    }

    private ItemWrapper addDirectory(@NotNull JComboBox comboBox, @NotNull String directory, @Nullable VirtualFile baseDirectory) {
        if (comboBox == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(20);
        }
        if (directory == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(21);
        }
        ItemWrapper item = new ItemWrapper(directory, this.myProjectBasePath, baseDirectory);
        comboBox.addItem(item);
        return item;
    }

    public void selectDirectory(@NotNull String path) {
        ItemWrapper directory;
        if (path == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(22);
        }
        if ((directory = this.getDirectory(path)) != null) {
            this.getComboBox().setSelectedItem(directory);
        }
    }

    @Nullable
    private ItemWrapper getDirectory(@NotNull String path) {
        if (path == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(23);
        }
        JComboBox comboBox = this.getComboBox();
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ItemWrapper directory = (ItemWrapper)ObjectUtils.tryCast(comboBox.getItemAt(i), ItemWrapper.class);
            if (directory == null || !VfsUtilCore.isEqualOrAncestor((String)path, (String)directory.getFullIndependentPath())) continue;
            return directory;
        }
        return null;
    }

    public void dispose() {
        this.isDisposed = true;
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/ui/PhpPsrDirectoryComboBox";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryProvider";
                break;
            }
            case 9: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/ui/PhpPsrDirectoryComboBox";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoriesFilter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "suggestDirectories";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectories";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectoriesInternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectoriesIfNotEmpty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "chooseFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findExistingParent";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addDirectory";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "selectDirectory";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10 -> new IllegalStateException(string);
        };
    }

    public static class ItemWrapper {
        private static final String PATH_PREFIX = "...";
        private final String myProjectBasePath;
        private String myFullPath;
        private VirtualFile myExistingParent;
        private Icon myIcon;
        private String myCachedPathPresentation;

        public ItemWrapper(@NotNull String path, @NotNull String projectPath, @Nullable VirtualFile existingParent) {
            if (path == null) {
                ItemWrapper.$$$reportNull$$$0(0);
            }
            if (projectPath == null) {
                ItemWrapper.$$$reportNull$$$0(1);
            }
            this.myFullPath = path;
            this.myProjectBasePath = projectPath;
            this.myExistingParent = existingParent;
            this.myCachedPathPresentation = null;
        }

        public void updatePath(@NotNull String path, @Nullable VirtualFile baseDirectory) {
            if (path == null) {
                ItemWrapper.$$$reportNull$$$0(2);
            }
            this.myFullPath = path;
            this.myExistingParent = baseDirectory;
            this.myCachedPathPresentation = null;
        }

        public VirtualFile getExistingParent() {
            return this.myExistingParent;
        }

        @NlsSafe
        public String getRelativePath() {
            if (this.myExistingParent == null) {
                return this.myFullPath;
            }
            String relativeDirPath = FileUtil.getRelativePath((String)this.myExistingParent.getPath(), (String)this.getFullIndependentPath(), (char)'/');
            return StringUtil.equals((CharSequence)relativeDirPath, (CharSequence)".") ? "" : relativeDirPath;
        }

        @NlsSafe
        public String getPresentablePath() {
            if (this.myCachedPathPresentation == null) {
                this.myCachedPathPresentation = this.myFullPath != null && this.myFullPath.startsWith(this.myProjectBasePath) && !StringUtil.equals((CharSequence)this.myFullPath, (CharSequence)this.myProjectBasePath) ? PATH_PREFIX + this.myFullPath.substring(this.myProjectBasePath.length()) : StringUtil.notNullize((String)this.myFullPath);
            }
            return this.myCachedPathPresentation;
        }

        @NlsSafe
        public String getFullPresentablePath() {
            return this.myFullPath;
        }

        @NlsSafe
        public String getFullIndependentPath() {
            return FileUtil.toSystemIndependentName((String)this.myFullPath);
        }

        public Icon getIcon(FileIndex fileIndex) {
            if (this.myIcon == null) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    this.myIcon = (Icon)ReadAction.nonBlocking(() -> {
                        if (this.myExistingParent != null) {
                            if (fileIndex.isInTestSourceContent(this.myExistingParent)) {
                                return PlatformIcons.MODULES_TEST_SOURCE_FOLDER;
                            }
                            if (fileIndex.isInSourceContent(this.myExistingParent)) {
                                return PlatformIcons.MODULES_SOURCE_FOLDERS_ICON;
                            }
                        }
                        return PlatformIcons.FOLDER_ICON;
                    }).executeSynchronously();
                });
            }
            return this.myIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectPath";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/roots/ui/PhpPsrDirectoryComboBox$ItemWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

