/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run;

import com.intellij.execution.EnvFilesOptions;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.PhpRefactoringListenerRunConfiguration;
import com.jetbrains.php.run.PhpRunConfigurationExtensionsManager;
import com.jetbrains.php.run.PhpRunConfigurationSettings;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.RunConfigurationInterpreterProvider;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class PhpCommandLineRunConfiguration<S extends PhpRunConfigurationSettings>
extends PhpRefactoringListenerRunConfiguration<S>
implements RunConfigurationInterpreterProvider,
EnvFilesOptions {
    protected PhpCommandLineRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public List<String> getEnvFilePaths() {
        List<String> list = ((PhpRunConfigurationSettings)this.getSettings()).getEnvFilePaths();
        if (list == null) {
            PhpCommandLineRunConfiguration.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setEnvFilePaths(@NotNull List<String> strings) {
        if (strings == null) {
            PhpCommandLineRunConfiguration.$$$reportNull$$$0(1);
        }
        ((PhpRunConfigurationSettings)this.getSettings()).setEnvFilePaths(strings);
    }

    public final RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        VirtualFile file;
        if (executor == null) {
            PhpCommandLineRunConfiguration.$$$reportNull$$$0(2);
        }
        if (env == null) {
            PhpCommandLineRunConfiguration.$$$reportNull$$$0(3);
        }
        final Project project = this.getProject();
        PhpInterpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return null;
            }
            throw new ExecutionException(PhpCommandSettingsBuilder.getInterpreterNotFoundError());
        }
        final PhpCommandSettings command = new PhpCommandSettingsBuilder(project, interpreter).build();
        VirtualFile virtualFile = file = !interpreter.isRemote() ? ProjectUtil.guessProjectDir((Project)project) : null;
        if (file != null) {
            command.setWorkingDir(PathUtil.toSystemDependentName((String)file.getPath()));
        }
        CommandLineState commandLineState = new CommandLineState(env){

            @NotNull
            protected ConsoleView createConsole(@NotNull Executor executor) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(0);
                }
                ConsoleViewImpl consoleViewImpl = PhpDebugProcess.getConsoleView(project);
                if (consoleViewImpl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return consoleViewImpl;
            }

            @NotNull
            protected ProcessHandler startProcess() throws ExecutionException {
                PhpCommandLineRunConfiguration.this.fillCommandSettings(Collections.emptyMap(), command);
                GeneralCommandLine commandLine = command.createGeneralCommandLine(true);
                PhpRunConfigurationExtensionsManager.getInstance().patchCommandLine((RunConfigurationBase)PhpCommandLineRunConfiguration.this.getRunConfiguration(), this.getRunnerSettings(), commandLine, this.getEnvironment().getRunner().getRunnerId(), this.getEnvironment().getExecutor());
                ProcessHandler processHandler = PhpCommandLineRunConfiguration.this.createProcessHandler(project, command, PtyCommandLine.isEnabled(), commandLine);
                PhpRunUtil.attachProcessOutputDebugDumper(processHandler);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)project);
                ProcessHandler processHandler2 = processHandler;
                if (processHandler2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return processHandler2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/run/PhpCommandLineRunConfiguration$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/run/PhpCommandLineRunConfiguration$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createConsole";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createConsole";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
        commandLineState.addConsoleFilters(this.getConsoleMessageFilters(project, command.getPathProcessor().createPathMapper(project)));
        return commandLineState;
    }

    @Override
    public PhpInterpreter getInterpreter() {
        return PhpProjectConfigurationFacade.getInstance(this.myProject).getInterpreter();
    }

    protected Filter[] getConsoleMessageFilters(@NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (project == null) {
            PhpCommandLineRunConfiguration.$$$reportNull$$$0(4);
        }
        if (pathMapper == null) {
            PhpCommandLineRunConfiguration.$$$reportNull$$$0(5);
        }
        return PhpExecutionUtil.getConsoleMessageFilters(project, pathMapper);
    }

    protected abstract void fillCommandSettings(@NotNull Map<String, String> var1, @NotNull PhpCommandSettings var2) throws ExecutionException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/PhpCommandLineRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvFilePaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/PhpCommandLineRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvFilePaths";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleMessageFilters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

