/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.httpRequest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugProcessFactory;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.run.PhpDebugConnectionInitCallback;
import com.jetbrains.php.run.PhpDebugRunner;
import com.jetbrains.php.run.httpRequest.PhpHttpRequestRunConfiguration;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import org.jetbrains.annotations.NotNull;

public final class PhpHttpRequestDebugRunner
extends PhpDebugRunner<PhpHttpRequestRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(PhpHttpRequestDebugRunner.class);

    public PhpHttpRequestDebugRunner() {
        super(PhpHttpRequestRunConfiguration.class);
    }

    @NotNull
    public String getRunnerId() {
        return "PhpHttpRequestDebugRunner";
    }

    @Override
    protected RunContentDescriptor doExecute(@NotNull PhpHttpRequestRunConfiguration runConfiguration, @NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (runConfiguration == null) {
            PhpHttpRequestDebugRunner.$$$reportNull$$$0(0);
        }
        if (state == null) {
            PhpHttpRequestDebugRunner.$$$reportNull$$$0(1);
        }
        if (env == null) {
            PhpHttpRequestDebugRunner.$$$reportNull$$$0(2);
        }
        Project project = runConfiguration.getProject();
        PhpHttpRequestRunConfiguration.Settings settings = (PhpHttpRequestRunConfiguration.Settings)runConfiguration.getSettings();
        PhpServer server = PhpProjectConfigurationFacade.getInstance(project).findServer(settings.getServerName());
        assert (server != null);
        String serverName = server.getName();
        assert (serverName != null);
        String debuggerId = server.getDebuggerId();
        if (!PhpDebugUtil.isXDebug(debuggerId) && !PhpDebugUtil.isZendDebugger(debuggerId)) {
            throw new ExecutionException(PhpBundle.message("unknown.debugger.type", new Object[0]));
        }
        PhpDebugExtension debugExtension = PhpDebugUtil.getDebugExtensionByDebuggerId(debuggerId);
        PhpDebugConnectionManager connectionsManager = debugExtension.createDebugConnectionManager();
        PhpDebugConnectionInitCallback initCallback = new PhpDebugConnectionInitCallback();
        final PhpIncomingDebugConnectionServer debugServer = debugExtension.startDebugServer(project, initCallback);
        final String sessionId = debugServer.registerSessionHandler(false, connectionsManager).getSessionId();
        boolean breakAtFirstLine = PhpProjectDebugConfiguration.getInstance(project).getState().isBreakAtFirstLine();
        DefaultDebugProcessHandler processHandler = new DefaultDebugProcessHandler();
        ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)project);
        ConsoleViewImpl console = new ConsoleViewImpl(project, true);
        try {
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)project).startSession(env, new XDebugProcessStarter(this, (ProcessHandler)processHandler, connectionsManager, serverName, console, debugExtension){
                final /* synthetic */ ProcessHandler val$processHandler;
                final /* synthetic */ PhpDebugConnectionManager val$connectionsManager;
                final /* synthetic */ String val$serverName;
                final /* synthetic */ ConsoleViewImpl val$console;
                final /* synthetic */ PhpDebugExtension val$debugExtension;
                {
                    this.val$processHandler = processHandler;
                    this.val$connectionsManager = phpDebugConnectionManager;
                    this.val$serverName = string2;
                    this.val$console = consoleViewImpl;
                    this.val$debugExtension = phpDebugExtension;
                }

                @NotNull
                public XDebugProcess start(final @NotNull XDebugSession session) {
                    if (session == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    session.addSessionListener(new XDebugSessionListener(){

                        public void sessionStopped() {
                            debugServer.unregisterSessionHandler(sessionId);
                        }
                    });
                    this.val$processHandler.addProcessListener(new ProcessListener(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            session.stop();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/run/httpRequest/PhpHttpRequestDebugRunner$1$2", "processTerminated"));
                        }
                    });
                    PhpDebugProcess phpDebugProcess = PhpDebugProcessFactory.forPhpHttpRequest(session, sessionId, this.val$connectionsManager, this.val$serverName, (ConsoleView)this.val$console, this.val$debugExtension.getDebugDriver());
                    if (phpDebugProcess == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return phpDebugProcess;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/run/httpRequest/PhpHttpRequestDebugRunner$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/run/httpRequest/PhpHttpRequestDebugRunner$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            ApplicationManager.getApplication().executeOnPooledThread(() -> PhpHttpRequestDebugRunner.lambda$doExecute$0(initCallback, project, env, debugSession, runConfiguration, (ProcessHandler)processHandler, console, debugExtension, breakAtFirstLine, sessionId));
            processHandler.startNotify();
            return debugSession.getRunContentDescriptor();
        }
        catch (ExecutionException e) {
            debugServer.unregisterSessionHandler(sessionId);
            throw e;
        }
    }

    private static /* synthetic */ void lambda$doExecute$0(PhpDebugConnectionInitCallback initCallback, Project project, ExecutionEnvironment env, XDebugSession debugSession, PhpHttpRequestRunConfiguration runConfiguration, ProcessHandler processHandler, ConsoleViewImpl console, PhpDebugExtension debugExtension, boolean breakAtFirstLine, String sessionId) {
        initCallback.waitForInitialization(project, env);
        if (!debugSession.isStopped()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Debug connection initialized. Sending HTTP Request.");
            }
            runConfiguration.doExecute(processHandler, console, debugExtension.getDebugQuery(project, breakAtFirstLine, sessionId));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/run/httpRequest/PhpHttpRequestDebugRunner";
        objectArray[2] = "doExecute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

