/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.PredefinedCodeStyleUtil;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageFeatureUsagesTracker;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugSkippedPathsConfiguration;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.xdebug.XdebugExtension;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import com.jetbrains.php.lang.PhpLanguage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhpSettingsUsageCollector
extends ProjectUsagesCollector {
    private static final int BASE_VERSION = 2;
    private static final EventLogGroup GROUP = new EventLogGroup("php.config", PhpLanguageLevel.values().length + PhpLanguageFeature.values().length + 2);
    private static final StringEventField INTERPRETER_VALUE = EventFields.String((String)"value", List.of("not.installed", "installed"));
    private static final StringEventField LANGUAGE_LEVEL_DATA = new StringEventField("php_level"){

        @NotNull
        public List<String> getValidationRule() {
            List<String> list = List.of("{regexp#version}", "{enum:unknown|invalid.format}");
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/statistics/PhpSettingsUsageCollector$1", "getValidationRule"));
        }
    };
    private static final BooleanEventField IS_PROJECT_LEVEL_DATA = EventFields.Boolean((String)"equals_to_project_level");
    private static final BooleanEventField IS_AUTO_GENERATED = EventFields.Boolean((String)"auto_generated");
    private static final StringEventField DEBUGGER_DATA = EventFields.String((String)"debugger", List.of("xdebug", "ZendDebugger", "unknown"));
    private static final BooleanEventField WITH_MAPPINGS_DATA = EventFields.Boolean((String)"with_mappings");
    public static final EnumEventField<PhpLanguageFeature> NAME_DATA = EventFields.Enum((String)"name", PhpLanguageFeature.class, value -> value.name());
    private static final VarargEventId INTERPRETER_METRIC = GROUP.registerVarargEvent("interpreter", new EventField[]{EventFields.Count, LANGUAGE_LEVEL_DATA, IS_PROJECT_LEVEL_DATA, IS_AUTO_GENERATED, DEBUGGER_DATA});
    private static final VarargEventId INTERPRETERS_TOTAL_METRIC = GROUP.registerVarargEvent("interpreters.total", new EventField[]{EventFields.Count});
    private static final VarargEventId DEBUG_SKIP_PATH_TOTAL_METRIC = GROUP.registerVarargEvent("debug.skip.path.total", new EventField[]{EventFields.Count});
    private static final EventId1<Integer> DEBUG_SERVER_TOTAL_METRIC = GROUP.registerEvent("debug.server.total", (EventField)EventFields.Count);
    private static final VarargEventId DEFAULT_INTERPRETER_METRIC = GROUP.registerVarargEvent("default.interpreter", new EventField[]{INTERPRETER_VALUE, LANGUAGE_LEVEL_DATA, IS_PROJECT_LEVEL_DATA, IS_AUTO_GENERATED, DEBUGGER_DATA});
    private static final BooleanEventField LANGUAGE_LEVEL_COMPOSER_SYNC = EventFields.Boolean((String)"php_language_level_composer_sync");
    private static final EventId2<String, Boolean> PROJECT_PHP_LEVEL_METRIC = GROUP.registerEvent("project.language.level", (EventField)LANGUAGE_LEVEL_DATA, (EventField)LANGUAGE_LEVEL_COMPOSER_SYNC);
    private static final VarargEventId DEBUG_SERVER_METRIC = GROUP.registerVarargEvent("debug.server", new EventField[]{EventFields.Count, WITH_MAPPINGS_DATA, DEBUGGER_DATA});
    public static final EventId1<String> CODE_STYLE_METRIC = GROUP.registerEvent("php.code.style", (EventField)EventFields.String((String)"value", List.of("default", "edited", "third.party", "Zend", "PEAR", "WordPress", "Joomla!", "CodeIgniter", "PSR1/PSR2", "PSR12", "Laravel", "Symfony2", "Drupal", "PER")));
    public static final VarargEventId FEATURE_USAGE_METRIC = GROUP.registerVarargEvent("php.feature.usage", new EventField[]{NAME_DATA});

    PhpSettingsUsageCollector() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        PhpProjectConfigurationFacade configuration;
        if (project == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(0);
        }
        if (project.isDefault() || project.isDisposed()) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                PhpSettingsUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        HashSet<MetricEvent> metrics = new HashSet<MetricEvent>();
        PhpDebugSkippedPathsConfiguration skippedPathsSettings = PhpDebugSkippedPathsConfiguration.getInstance(project);
        if (skippedPathsSettings != null) {
            PhpDebugSkippedPathsConfiguration.State state = skippedPathsSettings.getState();
            MetricEventUtilKt.addCounterIfNotZero(metrics, (VarargEventId)DEBUG_SKIP_PATH_TOTAL_METRIC, (int)(state != null ? state.getSkippedFiles().size() : 0));
        }
        if ((configuration = PhpProjectConfigurationFacade.getInstance(project)) != null) {
            List<PhpServer> servers = configuration.getServers();
            metrics.add(DEBUG_SERVER_TOTAL_METRIC.metric((Object)servers.size()));
            if (!servers.isEmpty()) {
                Object2IntOpenHashMap infos = new Object2IntOpenHashMap();
                for (PhpServer server : servers) {
                    PhpDebugExtension extension = PhpDebugUtil.getDebugExtensionByDebuggerId(server.getDebuggerId());
                    PhpDebugServerInfo info = new PhpDebugServerInfo(extension, server.isUsePathMappings());
                    infos.mergeInt((Object)info, 1, Math::addExact);
                }
                for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable((Object2IntMap)infos)) {
                    ArrayList<Object> usageData = new ArrayList<Object>();
                    usageData.add(EventFields.Count.with((Object)entry.getIntValue()));
                    usageData.addAll(((PhpDebugServerInfo)entry.getKey()).createData());
                    metrics.add(DEBUG_SERVER_METRIC.metric(usageData));
                }
            }
            PhpLanguageLevel projectLevel = configuration.getLanguageLevel();
            metrics.add(PROJECT_PHP_LEVEL_METRIC.metric((Object)projectLevel.getPresentableName(), (Object)ComposerDataService.getInstance(project).syncLanguageLevel()));
            metrics.add(PhpSettingsUsageCollector.createDefaultInterpreterMetric(project, configuration.getInterpreter(), projectLevel));
            PhpInterpretersManagerImpl interpretersManager = PhpInterpretersManagerImpl.getInstance(project);
            if (interpretersManager != null) {
                List<PhpInterpreter> interpreters = interpretersManager.getInterpreters();
                MetricEventUtilKt.addCounterIfNotZero(metrics, (VarargEventId)INTERPRETERS_TOTAL_METRIC, (int)interpreters.size());
                if (!interpreters.isEmpty()) {
                    List<EventPair<?>> data;
                    @NotNull Object2IntOpenHashMap interpreterData = new Object2IntOpenHashMap();
                    for (PhpInterpreter interpreter : interpreters) {
                        data = PhpSettingsUsageCollector.createInterpreterData(project, interpreter, projectLevel);
                        interpreterData.mergeInt(data, 1, Math::addExact);
                    }
                    for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable((Object2IntMap)interpreterData)) {
                        data = new ArrayList((Collection)entry.getKey());
                        data.add(EventFields.Count.with((Object)entry.getIntValue()));
                        metrics.add(INTERPRETER_METRIC.metric(data));
                    }
                }
            }
        }
        metrics.add(CODE_STYLE_METRIC.metric((Object)PhpSettingsUsageCollector.getPhpCodeStyle(project)));
        EnumSet<PhpLanguageFeature> features = PhpLanguageFeatureUsagesTracker.getInstance().getUsedFeatures(project);
        for (PhpLanguageFeature feature : features) {
            metrics.add(FEATURE_USAGE_METRIC.metric(new EventPair[]{NAME_DATA.with((Object)feature)}));
        }
        HashSet<MetricEvent> hashSet = metrics;
        if (hashSet == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    private static String getPhpCodeStyle(@NotNull Project project) {
        Optional<PredefinedCodeStyle> first;
        if (project == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(3);
        }
        if ((first = Arrays.stream((PredefinedCodeStyle[])PredefinedCodeStyle.EP_NAME.getExtensions()).filter(e -> e.getLanguage() == PhpLanguage.INSTANCE).filter(e -> PredefinedCodeStyleUtil.isCodeStyleSet((Project)project, (PredefinedCodeStyle)e)).findFirst()).isPresent()) {
            return PluginInfoDetectorKt.getPluginInfo(first.get().getClass()).isDevelopedByJetBrains() ? first.get().getName() : "third.party";
        }
        if (CodeStyleSettings.getDefaults().equals((Object)CodeStyle.getSettings((Project)project))) {
            return "default";
        }
        return "edited";
    }

    @NotNull
    private static MetricEvent createDefaultInterpreterMetric(@Nullable Project project, @Nullable PhpInterpreter interpreter, @NotNull PhpLanguageLevel projectLevel) {
        if (projectLevel == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(4);
        }
        if (interpreter == null) {
            MetricEvent metricEvent = DEFAULT_INTERPRETER_METRIC.metric(new EventPair[]{INTERPRETER_VALUE.with((Object)"not.installed")});
            if (metricEvent == null) {
                PhpSettingsUsageCollector.$$$reportNull$$$0(5);
            }
            return metricEvent;
        }
        @NotNull ArrayList<EventPair<?>> data = new ArrayList(PhpSettingsUsageCollector.createInterpreterData(project, interpreter, projectLevel));
        data.add(INTERPRETER_VALUE.with((Object)"installed"));
        MetricEvent metricEvent = DEFAULT_INTERPRETER_METRIC.metric(data);
        if (metricEvent == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(6);
        }
        return metricEvent;
    }

    @NotNull
    private static List<EventPair<?>> createInterpreterData(@Nullable Project project, @NotNull PhpInterpreter interpreter, @NotNull PhpLanguageLevel projectLevel) {
        PhpInfo info;
        if (interpreter == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(7);
        }
        if (projectLevel == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(8);
        }
        if ((info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter.getName())) == null) {
            List<EventPair<?>> list = Collections.singletonList(LANGUAGE_LEVEL_DATA.with((Object)"unknown"));
            if (list == null) {
                PhpSettingsUsageCollector.$$$reportNull$$$0(9);
            }
            return list;
        }
        PhpDebugExtension extension = PhpSettingsUsageCollector.getDebuggerExtensionId(info);
        String debuggerId = extension != null ? extension.getId() : "unknown";
        PhpLanguageLevel level = PhpLanguageLevel.parse((String)info.getShortVersion());
        if (level == null) {
            List<EventPair<?>> list = List.of(LANGUAGE_LEVEL_DATA.with((Object)"invalid.format"), DEBUGGER_DATA.with((Object)debuggerId));
            if (list == null) {
                PhpSettingsUsageCollector.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<EventPair<?>> list = List.of(LANGUAGE_LEVEL_DATA.with((Object)level.getPresentableName()), IS_PROJECT_LEVEL_DATA.with((Object)(projectLevel == level ? 1 : 0)), IS_AUTO_GENERATED.with((Object)interpreter.isAuto()), DEBUGGER_DATA.with((Object)debuggerId));
        if (list == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    private static PhpDebugExtension getDebuggerExtensionId(@NotNull PhpInfo info) {
        List<PhpDebuggerInfo> debuggers;
        if (info == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(12);
        }
        if (!(debuggers = info.getDebuggers()).isEmpty()) {
            PhpDebuggerInfo debuggerInfo = debuggers.get(0);
            if (StringUtil.equals((CharSequence)debuggerInfo.getDebugger(), (CharSequence)XdebugExtension.INSTANCE.getName())) {
                return XdebugExtension.INSTANCE;
            }
            if (StringUtil.equals((CharSequence)debuggerInfo.getDebugger(), (CharSequence)ZendDebuggerExtension.INSTANCE.getName())) {
                return ZendDebuggerExtension.INSTANCE;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpSettingsUsageCollector";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLevel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpSettingsUsageCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultInterpreterMetric";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterpreterData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPhpCodeStyle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultInterpreterMetric";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInterpreterData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDebuggerExtensionId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    private static final class PhpDebugServerInfo {
        private final PhpDebugExtension myExtension;
        private final boolean myWithMappings;

        private PhpDebugServerInfo(@NotNull PhpDebugExtension extension, boolean withMappings) {
            if (extension == null) {
                PhpDebugServerInfo.$$$reportNull$$$0(0);
            }
            this.myExtension = extension;
            this.myWithMappings = withMappings;
        }

        @NotNull
        public List<EventPair<?>> createData() {
            List<EventPair<?>> list = List.of(DEBUGGER_DATA.with((Object)this.myExtension.getId()), WITH_MAPPINGS_DATA.with((Object)this.myWithMappings));
            if (list == null) {
                PhpDebugServerInfo.$$$reportNull$$$0(1);
            }
            return list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpDebugServerInfo info = (PhpDebugServerInfo)o;
            return this.myWithMappings == info.myWithMappings && Objects.equals(this.myExtension, info.myExtension);
        }

        public int hashCode() {
            return Objects.hash(this.myExtension, this.myWithMappings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/statistics/PhpSettingsUsageCollector$PhpDebugServerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/statistics/PhpSettingsUsageCollector$PhpDebugServerInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

