/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkBySdkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationIml;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="settings")
public class PhpTestFrameworkSettings {
    private final Map<PhpTestFrameworkKey, PhpTestFrameworkConfiguration> myConfigurations = new ConcurrentHashMap<PhpTestFrameworkKey, PhpTestFrameworkConfiguration>();

    public PhpTestFrameworkConfiguration addIfAbsent(@Nullable Project project, @NotNull PhpTestFrameworkConfiguration configuration, @Nullable String interpreterId, @Nullable VirtualFile locationContext) {
        PhpTestFrameworkKey key;
        PhpTestFrameworkConfiguration oldValue;
        if (configuration == null) {
            PhpTestFrameworkSettings.$$$reportNull$$$0(0);
        }
        return (oldValue = this.myConfigurations.putIfAbsent(key = PhpTestFrameworkSettings.computeKey(project, configuration, interpreterId, locationContext), configuration)) == null ? configuration : oldValue;
    }

    @NotNull
    public static PhpTestFrameworkKey computeKey(@Nullable Project project, @NotNull PhpTestFrameworkConfiguration configuration, @Nullable String interpreterId, @Nullable VirtualFile locationContext) {
        String string;
        String basePath;
        if (configuration == null) {
            PhpTestFrameworkSettings.$$$reportNull$$$0(1);
        }
        String string2 = basePath = StringUtil.isEmpty((String)configuration.getExecutablePath()) && locationContext != null ? locationContext.getPresentableUrl() : configuration.getExecutablePath();
        if (interpreterId != null) {
            string = interpreterId;
        } else if (configuration instanceof PhpSdkDependentConfiguration) {
            PhpSdkDependentConfiguration sdkDependent = (PhpSdkDependentConfiguration)((Object)configuration);
            string = sdkDependent.getInterpreterId();
        } else {
            string = null;
        }
        interpreterId = string;
        String localBasePath = PhpTestFrameworkBySdkConfiguration.getLocalExecutablePath(basePath, interpreterId, project);
        String baseDir = PhpTestFrameworkConfigurationIml.getBaseDirRelativePath(project, localBasePath);
        return new PhpTestFrameworkKey(interpreterId, baseDir);
    }

    @XCollection(propertyElementName="configurations", elementTypes={PhpTestFrameworkConfigurationIml.class, PhpTestFrameworkBySdkConfiguration.class})
    @NotNull
    public List<PhpTestFrameworkConfiguration> getConfigurations() {
        List<PhpTestFrameworkConfiguration> list = this.myConfigurations.values().stream().toList();
        if (list == null) {
            PhpTestFrameworkSettings.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setConfigurations(@NotNull List<PhpTestFrameworkConfiguration> configurations) {
        if (configurations == null) {
            PhpTestFrameworkSettings.$$$reportNull$$$0(3);
        }
        this.setConfigurations(configurations, null);
    }

    public void setConfigurations(@NotNull List<PhpTestFrameworkConfiguration> configurations, @Nullable Project project) {
        if (configurations == null) {
            PhpTestFrameworkSettings.$$$reportNull$$$0(4);
        }
        this.myConfigurations.clear();
        for (PhpTestFrameworkConfiguration configuration : configurations) {
            this.addIfAbsent(project, configuration, null, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addIfAbsent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeKey";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public record PhpTestFrameworkKey(@Nullable String interpreterId, @NotNull String baseDir) {
        @NotNull
        private final String baseDir;

        public PhpTestFrameworkKey(@Nullable String interpreterId, @NotNull String baseDir) {
            if (baseDir == null) {
                PhpTestFrameworkKey.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String baseDir() {
            String string = this.baseDir;
            if (string == null) {
                PhpTestFrameworkKey.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseDir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettings$PhpTestFrameworkKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettings$PhpTestFrameworkKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "baseDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

