/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.tools.quality.QualityToolConfigurableForm;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationProvider;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.ui.PhpNamedCloneableItemsListEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfigurableList<C extends QualityToolConfiguration>
extends PhpNamedCloneableItemsListEditor<C> {
    private static final Comparator<MasterDetailsComponent.MyNode> COMPARATOR = (n1, n2) -> {
        Object o1 = n1.getConfigurable().getEditableObject();
        Object o2 = n2.getConfigurable().getEditableObject();
        if (o1 instanceof QualityToolConfiguration) {
            QualityToolConfiguration c1 = (QualityToolConfiguration)o1;
            if (o2 instanceof QualityToolConfiguration) {
                QualityToolConfiguration c2 = (QualityToolConfiguration)o2;
                return c1.compareTo(c2);
            }
        }
        return StringUtil.naturalCompare((String)n1.getDisplayName(), (String)n2.getDisplayName());
    };
    private final Project myProject;

    public QualityToolConfigurableList(@NotNull Project project, @NotNull QualityToolType<C> qualityToolType, @Nullable String initialElement) {
        if (project == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(0);
        }
        if (qualityToolType == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(1);
        }
        super(new QualityToolConfigurationNamer(project), () -> qualityToolType.createConfiguration(), settings -> settings.clone(), () -> qualityToolType.getConfigurationManager(project).getConfigurations(), settings -> qualityToolType.getConfigurationManager(project).markAndSetNewSettings(settings), settings -> {
            QualityToolConfigurableForm form;
            QualityToolConfigurationProvider<QualityToolConfiguration> provider = qualityToolType.getConfigurationProvider();
            if (provider != null && (form = provider.createConfigurationForm(project, (QualityToolConfiguration)settings)) != null) {
                return form;
            }
            return qualityToolType.createConfigurableForm(project, settings);
        }, new PhpNamedCloneableItemsListEditor.DefaultItemModelHandler(), initialElement);
        this.myProject = project;
        this.setSubjectDisplayName(qualityToolType.getDisplayName());
    }

    public String getHelpTopic() {
        return this.getQualityToolType().getHelpTopic();
    }

    @Nullable
    public String getLastSelectedItemId() {
        return this.myLastSelectedItem != null ? ((QualityToolConfiguration)this.myLastSelectedItem).getId() : null;
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        List list = this.getQualityToolType().getConfigurationProvider() == null ? new ArrayList() : super.createActions(fromPopup);
        if (list == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    protected AnAction createDeleteAction() {
        if (this.getQualityToolType().getConfigurationProvider() == null) {
            return super.createDeleteAction();
        }
        return new MyDeleteQualityToolConfigurationAction(QualityToolConfigurableList.forAll(o -> this.canDelete((C)((QualityToolConfiguration)((MasterDetailsComponent.MyNode)o).getConfigurable().getEditableObject()))));
    }

    @Override
    protected boolean canDelete(C item) {
        return item != null;
    }

    @Override
    protected boolean isCopyAvailable() {
        return false;
    }

    @Override
    @NotNull
    protected String suggestName(C item) {
        String string = ((QualityToolConfiguration)item).getPresentableName(this.myProject);
        if (string == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected AnAction createAddAction() {
        return new PhpNamedCloneableItemsListEditor.AddAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent event) {
                QualityToolConfigurationProvider provider;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((provider = QualityToolConfigurableList.this.getQualityToolType().getConfigurationProvider()) != null) {
                    ArrayList allSettings = new ArrayList();
                    QualityToolConfigurableList.this.getItemConfigurables().forEach(configurable -> ContainerUtil.addIfNotNull((Collection)allSettings, QualityToolConfigurableList.this.getConfiguration((QualityToolConfigurableForm)configurable)));
                    Object settings = provider.createNewInstance(QualityToolConfigurableList.this.myProject, allSettings);
                    if (settings != null) {
                        ((QualityToolConfiguration)settings).setDeletedFromTheList(false);
                        QualityToolConfigurableList.this.onItemCreated(settings);
                    }
                } else {
                    super.actionPerformed(event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/tools/quality/QualityToolConfigurableList$1", "actionPerformed"));
            }
        };
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return this.getQualityToolType().getDisplayName();
    }

    protected abstract QualityToolType<C> getQualityToolType();

    @Nullable
    protected C getConfiguration(@Nullable QualityToolConfigurableForm<C> configurable) {
        return configurable != null ? (C)configurable.getConfiguration() : null;
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return COMPARATOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualityToolType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurableList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurableList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class QualityToolConfigurationNamer<C extends QualityToolConfiguration>
    implements Namer<C> {
        private final Project myProject;

        QualityToolConfigurationNamer(Project project) {
            this.myProject = project;
        }

        public String getName(C settings) {
            return ((QualityToolConfiguration)settings).getPresentableName(this.myProject);
        }

        public boolean canRename(C item) {
            return false;
        }

        public void setName(C settings, String newName) {
        }
    }

    private class MyDeleteQualityToolConfigurationAction
    extends MasterDetailsComponent.MyDeleteAction {
        MyDeleteQualityToolConfigurationAction(Predicate<Object[]> condition) {
            if (condition == null) {
                MyDeleteQualityToolConfigurationAction.$$$reportNull$$$0(0);
            }
            super((MasterDetailsComponent)QualityToolConfigurableList.this, condition);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDeleteQualityToolConfigurationAction.$$$reportNull$$$0(1);
            }
            super.actionPerformed(e);
            QualityToolConfiguration configuration = (QualityToolConfiguration)QualityToolConfigurableList.this.getSelectedItem();
            if (configuration != null && (configuration.isLocal() || configuration.isCreatedAsDefaultInterpreterConfiguration())) {
                configuration.setDeletedFromTheList(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurableList$MyDeleteQualityToolConfigurationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

