/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolProjectConfiguration<C extends QualityToolConfiguration> {
    public static final String DEFAULT_INTERPRETER_CONFIGURATION_ID = "DEFAULT_INTERPRETER";
    private static final String CONFIGURATION_IS_NOT_FOUND = "quality.tool.configuration.for.interpreter.is.not.found";
    private String mySelectedConfigurationId = "DEFAULT_INTERPRETER";
    public boolean transferred = false;

    public String getSelectedConfigurationId() {
        return this.mySelectedConfigurationId;
    }

    public void setSelectedConfigurationId(String selectedConfigurationId) {
        this.mySelectedConfigurationId = selectedConfigurationId;
    }

    public static boolean isByDefaultInterpreter(@Nullable String configurationId) {
        return DEFAULT_INTERPRETER_CONFIGURATION_ID.equals(configurationId);
    }

    @Nullable
    public C findSelectedConfiguration(@NotNull Project project) throws QualityToolValidationException {
        if (project == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(0);
        }
        return this.findConfiguration(project, this.getSelectedConfigurationId(), true);
    }

    @Nullable
    public C findSelectedConfiguration(@NotNull Project project, boolean validateInspection) throws QualityToolValidationException {
        if (project == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(1);
        }
        return this.findConfiguration(project, this.getSelectedConfigurationId(), validateInspection);
    }

    @Nullable
    public C findConfiguration(@NotNull Project project, @Nullable String configurationId) throws QualityToolValidationException {
        if (project == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(2);
        }
        return this.findConfiguration(project, configurationId, true);
    }

    @Nullable
    public C findConfiguration(@NotNull Project project, @Nullable String configurationId, boolean validateInspection) throws QualityToolValidationException {
        C configuration;
        if (project == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(3);
        }
        C c = configuration = QualityToolProjectConfiguration.isByDefaultInterpreter(configurationId) ? this.getQualityToolType().getConfigurationManager(project).getOrCreateByDefaultInterpreterConfiguration() : this.findConfigurationById(configurationId, project);
        if (configuration == null) {
            throw new QualityToolValidationException(PhpBundle.message("quality.tool.configuration.can.not.find.configuration.by.id", this.getQualityToolType().getDisplayName(), configurationId));
        }
        String error = this.validate(project, configuration, validateInspection);
        if (StringUtil.isNotEmpty((String)error)) {
            throw new QualityToolValidationException(error);
        }
        return configuration;
    }

    @NotNull
    private C findConfigurationByInterpreter(@NotNull Project project, PhpInterpreter interpreter) throws QualityToolValidationException {
        C configuration;
        if (project == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(4);
        }
        if ((configuration = this.getQualityToolType().getConfigurationManager(project).getConfigurationByInterpreter(interpreter)) == null && interpreter != null) {
            configuration = this.getQualityToolType().getConfigurationManager(project).getOrCreateConfigurationByInterpreter(interpreter, true);
        }
        if (configuration == null) {
            throw new QualityToolValidationException(PhpBundle.message(CONFIGURATION_IS_NOT_FOUND, this.getQualityToolType().getDisplayName(), interpreter.getName()));
        }
        C c = configuration;
        if (c == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(5);
        }
        return c;
    }

    @Nullable
    public C findConfigurationById(@Nullable String configurationId, @NotNull Project project) throws QualityToolValidationException {
        QualityToolConfiguration c;
        if (project == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(6);
        }
        if ((c = (QualityToolConfiguration)ContainerUtil.find(this.getQualityToolType().getConfigurationManager(project).getAllSettings(), config -> StringUtil.equals((CharSequence)configurationId, (CharSequence)config.getId()))) == null) {
            return this.findConfigurationByInterpreter(project, PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(configurationId));
        }
        return (C)c;
    }

    @Nullable
    private String validate(@Nullable Project project, @NotNull C configuration, boolean validateInpection) {
        PhpInterpreter interpreter;
        if (configuration == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (StringUtil.isEmpty((String)((QualityToolConfiguration)configuration).getToolPath())) {
            return PhpBundle.message("quality.tool.configuration.tool.path.is.empty", this.getQualityToolType().getDisplayName());
        }
        String interpreterId = ((QualityToolConfiguration)configuration).getInterpreterId();
        if (StringUtil.isNotEmpty((String)interpreterId) && (interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId)) == null) {
            return PhpBundle.message("quality.tool.configuration.interpreter.is.undefined", this.getQualityToolType().getDisplayName());
        }
        return null;
    }

    protected abstract QualityToolType<C> getQualityToolType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolProjectConfiguration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolProjectConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurationByInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSelectedConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationByInterpreter";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationById";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

