/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.laravelPint;

import com.google.gson.JsonElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolsComposerConfig;
import com.jetbrains.php.tools.quality.laravelPint.LaravelPintConfiguration;
import com.jetbrains.php.tools.quality.laravelPint.LaravelPintConfigurationManager;
import com.jetbrains.php.tools.quality.laravelPint.LaravelPintOptionsConfiguration;
import com.jetbrains.php.tools.quality.laravelPint.LaravelPintQualityToolType;
import com.jetbrains.php.tools.quality.laravelPint.LaravelPintValidationInspection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class LaravelPintComposerConfig
extends QualityToolsComposerConfig<LaravelPintConfiguration, LaravelPintValidationInspection> {
    private static final String PACKAGE = "laravel/pint";
    @NonNls
    private static final String PRESET = "--preset";
    @NonNls
    private static final String CONFIG = "--config";
    @NonNls
    private static final String DIRTY = "--dirty";
    private static final Set<String> PRESETS = Set.of("laravel", "symfony", "psr12");
    private static final String RELATIVE_PATH = "bin/pint" + (SystemInfo.isWindows ? ".bat" : "");

    public LaravelPintComposerConfig() {
        super(PACKAGE, RELATIVE_PATH);
    }

    @Override
    @NotNull
    public ComposerLogMessageBuilder.Settings getSettings() {
        ComposerLogMessageBuilder.Settings settings = ComposerLogMessageBuilder.Settings.LARAVEL_PINT;
        if (settings == null) {
            LaravelPintComposerConfig.$$$reportNull$$$0(0);
        }
        return settings;
    }

    @Override
    public String getQualityInspectionShortName() {
        return LaravelPintQualityToolType.INSTANCE.getInspectionId();
    }

    @Override
    @NotNull
    public QualityToolConfigurationManager<LaravelPintConfiguration> getConfigurationManager(@NotNull Project project) {
        if (project == null) {
            LaravelPintComposerConfig.$$$reportNull$$$0(1);
        }
        LaravelPintConfigurationManager laravelPintConfigurationManager = LaravelPintConfigurationManager.getInstance(project);
        if (laravelPintConfigurationManager == null) {
            LaravelPintComposerConfig.$$$reportNull$$$0(2);
        }
        return laravelPintConfigurationManager;
    }

    @Override
    protected boolean applyRulesetFromRoot(@NotNull Project project) {
        if (project == null) {
            LaravelPintComposerConfig.$$$reportNull$$$0(3);
        }
        VirtualFile configFile = this.detectCustomRulesetFile(project.getBaseDir(), "pint.json");
        LaravelPintOptionsConfiguration configuration = LaravelPintOptionsConfiguration.getInstance(project);
        if (configFile == null) {
            return false;
        }
        return this.modifyRulesetInspectionSetting(project, tool -> configuration.setPintJsonPath(configFile.getPath()));
    }

    @Override
    protected boolean applyRulesetFromComposer(@NotNull Project project, LaravelPintConfiguration configuration) {
        if (project == null) {
            LaravelPintComposerConfig.$$$reportNull$$$0(4);
        }
        String configPath = ComposerDataService.getInstance(project).getConfigPath();
        VirtualFile config = LocalFileSystem.getInstance().refreshAndFindFileByPath(configPath);
        if (config == null) {
            return false;
        }
        String ruleset = this.getRuleset(config);
        if (ruleset == null) {
            return false;
        }
        return ContainerUtil.and((Iterable)StringUtil.split((String)ruleset, (String)" "), r -> this.applyRuleFromComposer(project, (String)r, config));
    }

    private boolean applyRuleFromComposer(Project project, String rule, VirtualFile config) {
        LaravelPintOptionsConfiguration configuration = LaravelPintOptionsConfiguration.getInstance(project);
        List ruleParts = StringUtil.split((String)rule, (String)"=");
        if (ruleParts.isEmpty()) {
            return false;
        }
        String option = (String)ruleParts.get(0);
        if (option.startsWith(DIRTY)) {
            return this.modifyRulesetInspectionSetting(project, tool -> configuration.setReformatOnlyUncommittedFiles(true));
        }
        if (ruleParts.size() < 2) {
            return false;
        }
        String value = (String)ruleParts.get(1);
        if (StringUtil.equals((CharSequence)PRESET, (CharSequence)option) && PRESETS.contains(value)) {
            return this.modifyRulesetInspectionSetting(project, tool -> configuration.setRuleset(value));
        }
        if (StringUtil.equals((CharSequence)CONFIG, (CharSequence)option)) {
            VirtualFile customRulesetFile = this.detectCustomRulesetFile(config.getParent(), value);
            if (customRulesetFile == null) {
                return true;
            }
            return this.modifyRulesetInspectionSetting(project, tool -> configuration.setPintJsonPath(customRulesetFile.getPath()));
        }
        return false;
    }

    @Override
    protected void checkComposerScriptsLeaves(JsonElement element, Ref<String> result) {
        String string = element.getAsString();
        if (string == null || !string.contains("pint")) {
            return;
        }
        int index = string.indexOf("--");
        if (index < 0) {
            return;
        }
        result.set((Object)string.substring(index));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/laravelPint/LaravelPintComposerConfig";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/laravelPint/LaravelPintComposerConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromComposer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

