/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpCSFixer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.tools.quality.QualityToolAnnotator;
import com.jetbrains.php.tools.quality.QualityToolReformatFile;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerOptionsConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerProjectConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerQualityToolType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpCSFixerReformatFile
extends QualityToolReformatFile {
    private final boolean myDryRun;

    public PhpCSFixerReformatFile() {
        this(false);
    }

    public PhpCSFixerReformatFile(boolean dryRun) {
        this.myDryRun = dryRun;
    }

    @Override
    public QualityToolType getQualityToolType() {
        return PhpCSFixerQualityToolType.INSTANCE;
    }

    @Override
    protected void fillArguments(List<String> options, PhpCommandSettings command, String workDirectory) {
        for (int i = 0; i < options.size(); ++i) {
            if (i != 1) {
                command.addArgument(options.get(i));
                continue;
            }
            command.addPathArgument(options.get(i));
        }
        if (StringUtil.isNotEmpty((String)workDirectory)) {
            command.setWorkingDir(workDirectory);
        }
    }

    @Override
    public PhpCSFixerConfiguration getCurrentConfiguration(@NotNull Project project) {
        if (project == null) {
            PhpCSFixerReformatFile.$$$reportNull$$$0(0);
        }
        try {
            return (PhpCSFixerConfiguration)PhpCSFixerProjectConfiguration.getInstance(project).findSelectedConfiguration(project);
        }
        catch (QualityToolValidationException e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    @Override
    protected String getName() {
        return PhpBundle.message("external.formatter.phpcsfixer", new Object[0]);
    }

    @Override
    public String getWorkingDir(@NotNull Project project) {
        PhpCSFixerOptionsConfiguration configuration;
        if (project == null) {
            PhpCSFixerReformatFile.$$$reportNull$$$0(1);
        }
        return "Custom".equals((configuration = PhpCSFixerOptionsConfiguration.getInstance(project)).getCodingStandard()) && StringUtil.isNotEmpty((String)configuration.getRulesetPath()) ? PathUtil.getParentPath((String)configuration.getRulesetPath()) : project.getBasePath();
    }

    @Override
    @NotNull
    public List<String> getOptions(@NotNull Project project, VirtualFile ... virtualFiles) {
        if (project == null) {
            PhpCSFixerReformatFile.$$$reportNull$$$0(2);
        }
        if (virtualFiles == null) {
            PhpCSFixerReformatFile.$$$reportNull$$$0(3);
        }
        ArrayList<String> options = new ArrayList<String>();
        PhpCSFixerOptionsConfiguration configuration = PhpCSFixerOptionsConfiguration.getInstance(project);
        options.add("fix");
        Arrays.stream(virtualFiles).map(f -> f.getPath()).forEach(p -> options.add((String)p));
        if ("Custom".equals(configuration.getCodingStandard())) {
            options.add("--config=" + QualityToolAnnotator.updateIfRemoteMappingExists(configuration.getRulesetPath(), project, PhpCSFixerQualityToolType.INSTANCE));
        } else if (!StringUtil.isEmpty((String)configuration.getCodingStandard())) {
            options.add("--rules=@" + configuration.getCodingStandard());
        }
        if (this.myDryRun) {
            options.add("--dry-run");
        }
        options.add("--diff");
        options.add("--format=udiff");
        options.add("--format=xml");
        options.add("-vv");
        if (!"Custom".equals(configuration.getCodingStandard())) {
            options.add("--allow-risky=" + (configuration.isAllowRiskyRules() ? "yes" : "no"));
        }
        ArrayList<String> arrayList = options;
        if (arrayList == null) {
            PhpCSFixerReformatFile.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerReformatFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerReformatFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

