/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpTrimRendererVisitor
extends PhpElementVisitor {
    private final StringBuilder builder = new StringBuilder();
    private final int myMaxLength;
    private final int mySuffixLength;

    private PhpTrimRendererVisitor(int maxLength, int suffixLength) {
        this.myMaxLength = maxLength;
        this.mySuffixLength = suffixLength;
    }

    public String toString() {
        return StringUtil.shortenTextWithEllipsis((String)this.builder.toString(), (int)this.myMaxLength, (int)this.mySuffixLength);
    }

    private static boolean isWhiteSpaceBeforeRequired(IElementType type) {
        return PhpTokenTypes.kwINSTANCEOF.equals(type) || PhpTokenTypes.tsLIT_OPS.contains(type);
    }

    private static boolean isWhiteSpaceAfterRequired(IElementType type) {
        return PhpTokenTypes.kwINSTANCEOF.equals(type) || PhpTokenTypes.tsLIT_OPS.contains(type) || PhpTokenTypes.kwNEW.equals(type);
    }

    public void visitElement(@NotNull PsiElement element) {
        IElementType elementType;
        if (element == null) {
            PhpTrimRendererVisitor.$$$reportNull$$$0(0);
        }
        if (PhpTrimRendererVisitor.isWhiteSpaceBeforeRequired(elementType = element.getNode().getElementType())) {
            this.builder.append(' ');
        }
        this.builder.append(element.getText());
        if (PhpTrimRendererVisitor.isWhiteSpaceAfterRequired(elementType)) {
            this.builder.append(' ');
        }
    }

    public void visitPhpElement(PhpPsiElement element) {
        element.acceptChildren((PsiElementVisitor)this);
    }

    public void visitPhpVariable(Variable variable) {
        this.builder.append("$");
        this.builder.append(variable.getName());
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        boolean shortSyntax = expression.isShortSyntax();
        this.builder.append(shortSyntax ? "[" : "array(");
        if (PhpPsiUtil.getChildOfType((PsiElement)expression, PhpElementTypes.HASH_ARRAY_ELEMENT) != null || PhpPsiUtil.getChildOfType((PsiElement)expression, PhpElementTypes.ARRAY_VALUE) != null) {
            this.builder.append("...");
        }
        this.builder.append(shortSyntax ? "]" : ")");
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        PhpPsiElement value = expression.getValue();
        if (value != null) {
            value.accept((PsiElementVisitor)this);
        }
        this.builder.append("[");
        ArrayIndex index = expression.getIndex();
        if (index != null) {
            index.accept((PsiElementVisitor)this);
        }
        this.builder.append("]");
    }

    public void visitPhpParameterList(ParameterList list) {
        if (list.getParameters().length > 0) {
            this.builder.append("...");
        }
    }

    public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
        String trimmedText = StringUtil.trim((String)StringUtil.collapseWhiteSpace((CharSequence)expression.getContents()));
        this.builder.append(expression.isSingleQuote() ? "'" : "\"");
        this.builder.append(StringUtil.shortenTextWithEllipsis((String)trimmedText, (int)23, (int)3));
        this.builder.append(expression.isSingleQuote() ? "'" : "\"");
    }

    public void visitPhpFunction(Function function) {
        if (function.isClosure() && FunctionImpl.isShortArrowFunction(function)) {
            this.builder.append("fn(");
            if (function.getParameters().length > 0) {
                this.builder.append("...");
            }
            this.builder.append(")=>...");
        } else {
            this.builder.append("function(");
            if (function.getParameters().length > 0) {
                this.builder.append("...");
            }
            this.builder.append("){...}");
        }
    }

    public void visitPhpIf(If ifStatement) {
        this.builder.append("if (");
        PhpPsiElement condition = ifStatement.getCondition();
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
        }
        this.builder.append(") {...}");
    }

    public void visitPhpFor(For forStatement) {
        this.builder.append("for (");
        PhpPsiElement element = (PhpPsiElement)ArrayUtil.getFirstElement((Object[])forStatement.getInitialExpressions());
        if (element != null) {
            element.accept((PsiElementVisitor)this);
        }
        this.builder.append("...) {...}");
    }

    public void visitPhpWhile(While whileStatement) {
        this.builder.append("while (");
        PhpPsiElement condition = whileStatement.getCondition();
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
        }
        this.builder.append(") {...}");
    }

    public void visitPhpDoWhile(DoWhile doWhileStatement) {
        PhpPsiElement condition = doWhileStatement.getCondition();
        this.builder.append("do {...} while (");
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
        }
        this.builder.append(")");
    }

    public void visitPhpSwitch(PhpSwitch switchStatement) {
        this.builder.append("switch (");
        PsiElement argument = switchStatement.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
        }
        this.builder.append(") {...}");
    }

    public void visitPhpForeach(ForeachStatement foreachStatement) {
        this.builder.append("foreach (");
        PsiElement array = foreachStatement.getArray();
        if (array != null) {
            array.accept((PsiElementVisitor)this);
        }
        this.builder.append("...) {...}");
    }

    public void visitPhpTry(Try tryStatement) {
        this.builder.append("try {...}");
    }

    public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
        PhpExpression argument = matchExpression.getArgument();
        this.builder.append("match (");
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
        }
        this.builder.append(") {...}");
    }

    public void visitPhpThrowExpression(PhpThrowExpression throwExpression) {
        PhpExpression argument = throwExpression.getArgument();
        this.builder.append("throw ");
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
        }
    }

    public void visitPhpReturn(PhpReturn returnStatement) {
        PsiElement argument = returnStatement.getArgument();
        this.builder.append("return");
        if (argument != null) {
            this.builder.append(" ");
            argument.accept((PsiElementVisitor)this);
        }
        this.builder.append(";");
    }

    public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
        if (space == null) {
            PhpTrimRendererVisitor.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public static String getTrimmedText(@NotNull PsiElement element, int length, int suffixLength) {
        if (element == null) {
            PhpTrimRendererVisitor.$$$reportNull$$$0(2);
        }
        PhpTrimRendererVisitor trimRendererVisitor = new PhpTrimRendererVisitor(length, suffixLength);
        element.accept((PsiElementVisitor)trimRendererVisitor);
        String string = trimRendererVisitor.toString();
        if (string == null) {
            PhpTrimRendererVisitor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "space";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/util/PhpTrimRendererVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/util/PhpTrimRendererVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitWhiteSpace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTrimmedText";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

