/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.config;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.smarty.SmartyBundle;
import com.jetbrains.smarty.config.SmartyConfiguration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class SmartyConfigurable
implements SearchableConfigurable {
    private static final String HELP_TOPIC = "reference.webide.settings.project.settings.smarty";
    private final Project myProject;
    private JPanel myMainPanel;
    private JTextField myLeftDelimiterTextField;
    private JTextField myRightDelimiterTextField;
    private JCheckBox mySmarty3WhitespacesCheckBox;
    private JLabel myMessageLabel;

    public SmartyConfigurable(@NotNull Project project) {
        if (project == null) {
            SmartyConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myMessageLabel.setVisible(false);
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            SmartyConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return PhpBundle.message("smarty.configurable.title", new Object[0]);
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        SmartyConfiguration config = SmartyConfiguration.getInstance(this.myProject);
        if (!config.getSmartyDelimiters().equals(this.getDelimiters())) {
            this.myMessageLabel.setVisible(true);
            return true;
        }
        if (config.getState().isSmarty3Whitespaces() != this.mySmarty3WhitespacesCheckBox.isSelected()) {
            this.myMessageLabel.setVisible(true);
            return true;
        }
        this.myMessageLabel.setVisible(false);
        return false;
    }

    public void apply() throws ConfigurationException {
        SmartyConfiguration config = SmartyConfiguration.getInstance(this.myProject);
        Pair<String, String> delimiters = this.getDelimiters();
        if (((String)delimiters.first).isEmpty() || ((String)delimiters.second).isEmpty()) {
            throw new ConfigurationException(SmartyBundle.message("config.error.no.delimiters", new Object[0]));
        }
        config.setSmartyDelimiters(delimiters);
        config.getState().setSmarty3Whitespaces(this.mySmarty3WhitespacesCheckBox.isSelected());
    }

    public void reset() {
        SmartyConfiguration config = SmartyConfiguration.getInstance(this.myProject);
        this.setDelimiters(config.getSmartyDelimiters());
        this.mySmarty3WhitespacesCheckBox.setSelected(config.getState().isSmarty3Whitespaces());
    }

    public Pair<String, String> getDelimiters() {
        return Pair.create((Object)this.myLeftDelimiterTextField.getText(), (Object)this.myRightDelimiterTextField.getText());
    }

    public void setDelimiters(Pair<String, String> delimiter) {
        this.myLeftDelimiterTextField.setText((String)delimiter.first);
        this.myRightDelimiterTextField.setText((String)delimiter.second);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/smarty/config/SmartyConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/smarty/config/SmartyConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/SmartyBundle", SmartyConfigurable.class).getString("label.smarty.left.delimiter"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLeftDelimiterTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/SmartyBundle", SmartyConfigurable.class).getString("label.smarty.right.delimiter"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRightDelimiterTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(150, -1), null));
        this.myMessageLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/SmartyBundle", SmartyConfigurable.class).getString("label.reopen.editor.for.changes.to.take.effect"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySmarty3WhitespacesCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/SmartyBundle", SmartyConfigurable.class).getString("checkbox.use.smarty3.whitespaces.policy"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

