/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.edit;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.smarty.SmartyCompletionContributor;
import com.jetbrains.smarty.SmartyFileType;
import com.jetbrains.smarty.SmartyFileViewProvider;
import com.jetbrains.smarty.SmartyLanguage;
import com.jetbrains.smarty.config.SmartyConfiguration;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import com.jetbrains.smarty.lang.lexer.SmartyLexer;
import com.jetbrains.smarty.lang.psi.SmartyCompositeElementTypes;
import com.jetbrains.smarty.lang.psi.SmartyTag;
import org.jetbrains.annotations.NotNull;

public final class SmartyTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            SmartyTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SmartyTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            SmartyTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            SmartyTypedHandler.$$$reportNull$$$0(3);
        }
        PsiFile smartyFile = file.getViewProvider().getPsi((Language)SmartyLanguage.INSTANCE);
        SmartyConfiguration config = SmartyConfiguration.getInstance(project);
        if (!(file.getFileType() == SmartyFileType.INSTANCE || file.getViewProvider() instanceof SmartyFileViewProvider && c == '{' && file.getFileType() == HtmlFileType.INSTANCE && "{".equals(config.getSmartyDelimiters().first))) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                SmartyTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        if ("{".equals(config.getSmartyDelimiters().first) && c == '{') {
            SmartyTypedHandler.typeInStringAndMoveCaret(editor, String.valueOf(c), 0);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(editor.getDocument());
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                SmartyTypedHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        String rightDelimiter = SmartyLexer.getRightDelimiter(project);
        char rightDelimiterLastSymbol = rightDelimiter.charAt(rightDelimiter.length() - 1);
        if (c == rightDelimiterLastSymbol) {
            if (editor.getHighlighter().createIterator(editor.getCaretModel().getOffset()).getTokenType() == SmartyTokenTypes.COMMENT || editor.getHighlighter().createIterator(editor.getCaretModel().getOffset()).getTokenType().getLanguage() != SmartyLanguage.INSTANCE) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    SmartyTypedHandler.$$$reportNull$$$0(6);
                }
                return result;
            }
            SmartyTypedHandler.insertCloseTagIfNeeded(editor, smartyFile, project, rightDelimiterLastSymbol);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                SmartyTypedHandler.$$$reportNull$$$0(7);
            }
            return result;
        }
        if (smartyFile != null && c == '#') {
            int off = editor.getCaretModel().getOffset();
            PsiElement elementAt = smartyFile.findElementAt(off - 1);
            if (PhpPsiUtil.isOfType(elementAt, SmartyTokenTypes.START_TAG_START)) {
                char charAtOffset;
                if (offset < editor.getDocument().getTextLength() && offset >= 0 && (charAtOffset = editor.getDocument().getCharsSequence().charAt(offset)) == '#') {
                    EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        SmartyTypedHandler.$$$reportNull$$$0(8);
                    }
                    return result;
                }
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"#", (boolean)true, (int)0);
            } else if (PhpPsiUtil.isOfType(elementAt, SmartyTokenTypes.IDENTIFIER)) {
                char charAtOffset;
                if (offset < editor.getDocument().getTextLength() && offset >= 0 && (charAtOffset = editor.getDocument().getCharsSequence().charAt(offset)) == '#') {
                    EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        SmartyTypedHandler.$$$reportNull$$$0(9);
                    }
                    return result;
                }
            } else if (PhpPsiUtil.isOfType(elementAt, SmartyTokenTypes.SHARP)) {
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    SmartyTypedHandler.$$$reportNull$$$0(10);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            SmartyTypedHandler.$$$reportNull$$$0(11);
        }
        return result;
    }

    private static char getCharAt(Document document, int offset) {
        if (offset >= document.getTextLength() || offset < 0) {
            return '\u0000';
        }
        return document.getCharsSequence().charAt(offset);
    }

    private static void typeInStringAndMoveCaret(Editor editor, String str, int caretShift) {
        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)str, (boolean)true, (int)caretShift);
    }

    public static boolean insertCloseTagIfNeeded(Editor editor, PsiFile file, Project project, char c) {
        String tagName;
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        int offset = editor.getCaretModel().getOffset();
        documentManager.commitDocument(document);
        char charAtOffset = SmartyTypedHandler.getCharAt(document, offset);
        if (charAtOffset != c) {
            SmartyTypedHandler.typeInStringAndMoveCaret(editor, String.valueOf(c), 0);
            documentManager.commitDocument(document);
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        HighlighterIterator iterator = editor.getHighlighter().createIterator(++offset - 2);
        while (!iterator.atEnd() && !iterator.getTokenType().equals(SmartyTokenTypes.PREDEFINED_FUNCTION)) {
            if (iterator.getTokenType() == SmartyTokenTypes.START_TAG_START || iterator.getTokenType() == SmartyTokenTypes.END_TAG_START) {
                return false;
            }
            iterator.retreat();
        }
        if (iterator.atEnd()) {
            return false;
        }
        if (!iterator.atEnd()) {
            iterator.retreat();
            if (!iterator.atEnd() && iterator.getTokenType().equals(SmartyTokenTypes.END_TAG_START)) {
                return false;
            }
            iterator.advance();
        }
        if (SmartyCompletionContributor.isUnique(tagName = document.getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd()).toString())) {
            return false;
        }
        PsiElement tagElement = file.findElementAt(iterator.getStart());
        while (PhpPsiUtil.isOfType(tagElement, SmartyCompositeElementTypes.TAG)) {
            tagElement = tagElement.getParent();
        }
        if (tagElement == null) {
            return false;
        }
        boolean doInsertion = false;
        if (tagElement.getLastChild() instanceof PsiErrorElement) {
            doInsertion = true;
        } else {
            iterator = editor.getHighlighter().createIterator(0);
            while (iterator.getStart() < offset) {
                String currentTagName;
                if (iterator.getTokenType() == SmartyTokenTypes.PREDEFINED_FUNCTION && tagName.equals(currentTagName = document.getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd()).toString())) {
                    Object currentTagElement = file.findElementAt(iterator.getStart());
                    if ((currentTagElement = PhpPsiUtil.getParentOfClass(currentTagElement, SmartyTag.class)) != null && currentTagElement.getLastChild() instanceof PsiErrorElement) {
                        doInsertion = true;
                        break;
                    }
                }
                iterator.advance();
            }
        }
        if (doInsertion) {
            SmartyTypedHandler.typeInStringAndMoveCaret(editor, SmartyLexer.getLeftDelimiter(project) + "/" + tagName + SmartyLexer.getRightDelimiter(project), 0);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/smarty/edit/SmartyTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/smarty/edit/SmartyTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

