/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.lang.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.smarty.SmartyBundle;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import com.jetbrains.smarty.lang.parser.SmartyTagsParser;
import com.jetbrains.smarty.lang.psi.SmartyCompositeElementTypes;

public final class SmartyExpressionParser {
    public static boolean parseArrayDefinition(PsiBuilder builder2) {
        if (builder2.getTokenType() != SmartyTokenTypes.L_BRACKET) {
            return false;
        }
        builder2.advanceLexer();
        while (true) {
            int offset = builder2.getCurrentOffset();
            if (builder2.getTokenType() == SmartyTokenTypes.R_BRACKET) break;
            if (!SmartyExpressionParser.parseArrayDefinition(builder2)) {
                SmartyExpressionParser.parseExpression(builder2);
            }
            if (builder2.getTokenType() == SmartyTokenTypes.ARRAY_ASSIGNMENT) {
                builder2.advanceLexer();
                if (!SmartyExpressionParser.parseArrayDefinition(builder2)) {
                    SmartyExpressionParser.parseExpression(builder2);
                }
            }
            if (offset == builder2.getCurrentOffset()) {
                builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
                break;
            }
            if (builder2.getTokenType() != SmartyTokenTypes.COMMA) break;
            builder2.advanceLexer();
        }
        if (builder2.getTokenType() != SmartyTokenTypes.R_BRACKET) {
            builder2.error(SmartyBundle.message("parsing.error.right.square.brace.expected", new Object[0]));
        } else {
            builder2.advanceLexer();
        }
        return true;
    }

    public static boolean parseDefinitionAndAssignment(PsiBuilder builder2) {
        PsiBuilder.Marker mark = builder2.mark();
        if (!SmartyExpressionParser.parseVariableDefinition(builder2)) {
            mark.rollbackTo();
            return false;
        }
        if (builder2.getTokenType() == SmartyTokenTypes.EQ) {
            builder2.advanceLexer();
            SmartyExpressionParser.parseRValue(builder2);
        }
        mark.drop();
        return true;
    }

    public static void parseRValue(PsiBuilder builder2) {
        if (builder2.getTokenType() == SmartyTokenTypes.L_BRACKET) {
            SmartyExpressionParser.parseArrayDefinition(builder2);
        } else if (!SmartyExpressionParser.parseExpression(builder2)) {
            builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
        }
    }

    public static boolean parseExpressionOrAssignment(PsiBuilder builder2) {
        PsiBuilder.Marker expr = builder2.mark();
        if (!SmartyExpressionParser.parseExpression(builder2)) {
            expr.drop();
            return false;
        }
        if (builder2.getTokenType() == SmartyTokenTypes.EQ) {
            builder2.advanceLexer();
            SmartyExpressionParser.parseRValue(builder2);
            expr.done(SmartyCompositeElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    public static boolean parseExpression(PsiBuilder builder2) {
        PsiBuilder.Marker expr = builder2.mark();
        if (!SmartyExpressionParser.parseRelationalExpression(builder2)) {
            expr.drop();
            return false;
        }
        while (SmartyTokenTypes.LOGICAL_OPERATIONS.contains(builder2.getTokenType())) {
            builder2.advanceLexer();
            if (!SmartyExpressionParser.parseRelationalExpression(builder2)) {
                builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(SmartyCompositeElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        if (builder2.getTokenType() == SmartyTokenTypes.QUESTION) {
            builder2.advanceLexer();
            if (!SmartyExpressionParser.parseExpression(builder2)) {
                builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            if (builder2.getTokenType() == SmartyTokenTypes.DOT_DOT) {
                builder2.advanceLexer();
            } else {
                builder2.error(SmartyBundle.message("parsing.error.colon.expected", new Object[0]));
            }
            if (!SmartyExpressionParser.parseExpression(builder2)) {
                builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
        }
        expr.drop();
        return true;
    }

    private static boolean parseRelationalExpression(PsiBuilder builder2) {
        PsiBuilder.Marker expr = builder2.mark();
        if (!SmartyExpressionParser.parseAdditiveExpression(builder2)) {
            expr.drop();
            return false;
        }
        while (SmartyTokenTypes.RELATIONAL_OPERATIONS.contains(builder2.getTokenType())) {
            builder2.advanceLexer();
            if (!SmartyExpressionParser.parseAdditiveExpression(builder2)) {
                builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(SmartyCompositeElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private static boolean parseAdditiveExpression(PsiBuilder builder2) {
        PsiBuilder.Marker expr = builder2.mark();
        if (!SmartyExpressionParser.parseMultiplicativeExpression(builder2)) {
            expr.drop();
            return false;
        }
        while (SmartyTokenTypes.ADDITIVE_OPERATIONS.contains(builder2.getTokenType())) {
            builder2.advanceLexer();
            if (!SmartyExpressionParser.parseMultiplicativeExpression(builder2)) {
                builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(SmartyCompositeElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private static boolean parseMultiplicativeExpression(PsiBuilder builder2) {
        PsiBuilder.Marker expr = builder2.mark();
        if (!SmartyExpressionParser.parseUnaryExpression(builder2)) {
            expr.drop();
            return false;
        }
        while (SmartyTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(builder2.getTokenType())) {
            builder2.advanceLexer();
            if (!SmartyExpressionParser.parseUnaryExpression(builder2)) {
                builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(SmartyCompositeElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private static boolean parseUnaryExpression(PsiBuilder builder2) {
        IElementType tokenType = builder2.getTokenType();
        if (SmartyTokenTypes.UNARY_OPERATIONS.contains(tokenType)) {
            PsiBuilder.Marker expr = builder2.mark();
            builder2.advanceLexer();
            if (!SmartyExpressionParser.parseUnaryExpression(builder2)) {
                builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(SmartyCompositeElementTypes.UNARY_EXPRESSION);
        } else {
            SmartyExpressionParser.parseOperand(builder2);
        }
        return true;
    }

    public static boolean parseVariable(PsiBuilder builder2) {
        if (builder2.getTokenType() == SmartyTokenTypes.DOLLAR || builder2.getTokenType() == SmartyTokenTypes.START_TAG_START) {
            if (builder2.getTokenType() == SmartyTokenTypes.DOLLAR) {
                builder2.advanceLexer();
            }
            SmartyExpressionParser.parseVariableInner(builder2);
            SmartyTagsParser.parseModifiers(builder2);
        } else if (builder2.getTokenType() == SmartyTokenTypes.SHARP) {
            builder2.advanceLexer();
            PsiBuilder.Marker configVariable = builder2.mark();
            if (builder2.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
                builder2.advanceLexer();
                configVariable.done(SmartyCompositeElementTypes.CONFIG_VARIABLE_REFERENCE);
            } else {
                builder2.error(SmartyBundle.message("parsing.error.identifier.expected", new Object[0]));
                configVariable.drop();
            }
            if (builder2.getTokenType() != SmartyTokenTypes.SHARP) {
                builder2.error(SmartyBundle.message("parsing.error.number.sign.expected", new Object[0]));
            } else {
                builder2.advanceLexer();
            }
        } else if (SmartyTokenTypes.STATIC_VALUES.contains(builder2.getTokenType())) {
            builder2.advanceLexer();
        } else if (builder2.getTokenType() == SmartyTokenTypes.SINGLE_QUOTE) {
            SmartyExpressionParser.parseSingleQuotedString(builder2);
            SmartyTagsParser.parseModifiers(builder2);
        } else if (builder2.getTokenType() == SmartyTokenTypes.DOUBLE_QUOTE) {
            SmartyExpressionParser.parseDoubleQuotedString(builder2);
            SmartyTagsParser.parseModifiers(builder2);
        } else if (builder2.getTokenType() == SmartyTokenTypes.L_BRACKET) {
            SmartyExpressionParser.parseArrayDefinition(builder2);
            SmartyTagsParser.parseModifiers(builder2);
        } else {
            if (builder2.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
                PsiBuilder.Marker functionCallMarker = builder2.mark();
                if (builder2.lookAhead(1) == SmartyTokenTypes.BACK_SLASH && !SmartyExpressionParser.parseNamespacedReference(builder2)) {
                    return false;
                }
                builder2.advanceLexer();
                if (builder2.getTokenType() == SmartyTokenTypes.L_PAR) {
                    SmartyExpressionParser.parseArgumentsList(builder2);
                    functionCallMarker.done(SmartyCompositeElementTypes.FUNCTION_CALL);
                } else if (builder2.getTokenType() == SmartyTokenTypes.COLON_COLON) {
                    functionCallMarker.rollbackTo();
                    SmartyExpressionParser.parseVariableInner(builder2);
                    SmartyTagsParser.parseModifiers(builder2);
                } else {
                    functionCallMarker.drop();
                }
                if (builder2.getTokenType() == SmartyTokenTypes.L_BRACKET) {
                    SmartyExpressionParser.parseArrayAccess(builder2);
                }
                SmartyTagsParser.parseModifiers(builder2);
                return true;
            }
            if (builder2.getTokenType() == SmartyTokenTypes.BACK_QUOTE) {
                builder2.advanceLexer();
                SmartyExpressionParser.parseExpression(builder2);
                if (builder2.getTokenType() != SmartyTokenTypes.BACK_QUOTE) {
                    builder2.error(SmartyBundle.message("parsing.error.back.quote.expected", new Object[0]));
                } else {
                    builder2.advanceLexer();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean parseNamespacedReference(PsiBuilder builder2) {
        IElementType lastTokenType = null;
        IElementType currentTokenType = builder2.getTokenType();
        IElementType lookAheadTokenType = builder2.lookAhead(1);
        while (!(currentTokenType != SmartyTokenTypes.BACK_SLASH && currentTokenType != SmartyTokenTypes.IDENTIFIER || lastTokenType == currentTokenType || lookAheadTokenType != SmartyTokenTypes.BACK_SLASH && lookAheadTokenType != SmartyTokenTypes.IDENTIFIER)) {
            lastTokenType = currentTokenType;
            builder2.advanceLexer();
            currentTokenType = builder2.getTokenType();
            lookAheadTokenType = builder2.lookAhead(1);
        }
        return lastTokenType != currentTokenType;
    }

    private static void parseSingleQuotedString(PsiBuilder builder2) {
        assert (builder2.getTokenType() == SmartyTokenTypes.SINGLE_QUOTE);
        builder2.advanceLexer();
        if (builder2.getTokenType() == SmartyTokenTypes.STRING_LITERAL) {
            builder2.advanceLexer();
        }
        if (builder2.getTokenType() == SmartyTokenTypes.SINGLE_QUOTE) {
            builder2.advanceLexer();
        }
    }

    public static void parseDoubleQuotedString(PsiBuilder builder2) {
        assert (builder2.getTokenType() == SmartyTokenTypes.DOUBLE_QUOTE);
        SmartyTagsParser tagsParser = null;
        builder2.advanceLexer();
        while (true) {
            if (builder2.getTokenType() == SmartyTokenTypes.DOLLAR) {
                builder2.advanceLexer();
                SmartyExpressionParser.parseVariableInner(builder2);
                continue;
            }
            if (builder2.getTokenType() == SmartyTokenTypes.STRING_LITERAL) {
                builder2.advanceLexer();
                continue;
            }
            if (builder2.getTokenType() == SmartyTokenTypes.BACK_QUOTE) {
                builder2.advanceLexer();
                SmartyExpressionParser.parseExpression(builder2);
                if (builder2.getTokenType() != SmartyTokenTypes.BACK_QUOTE) {
                    builder2.error(SmartyBundle.message("parsing.error.single.quote.expected", new Object[0]));
                    continue;
                }
                builder2.advanceLexer();
                continue;
            }
            if (builder2.getTokenType() != SmartyTokenTypes.START_TAG_START && builder2.getTokenType() != SmartyTokenTypes.END_TAG_START) break;
            if (tagsParser == null) {
                tagsParser = new SmartyTagsParser(builder2.getProject());
            }
            tagsParser.parseOneSmartyTagInInnerConstruction(builder2, false);
        }
        if (tagsParser != null) {
            tagsParser.clearStack();
        }
        if (builder2.getTokenType() != SmartyTokenTypes.DOUBLE_QUOTE) {
            builder2.error(SmartyBundle.message("parsing.error.double.quote.expected", new Object[0]));
        } else {
            builder2.advanceLexer();
        }
    }

    public static boolean parseVariableDefinition(PsiBuilder builder2) {
        if (builder2.getTokenType() == SmartyTokenTypes.DOLLAR) {
            builder2.advanceLexer();
        } else {
            builder2.error(SmartyBundle.message("parsing.error.dollar.expected", new Object[0]));
        }
        PsiBuilder.Marker mark = builder2.mark();
        if (builder2.getTokenType() != SmartyTokenTypes.IDENTIFIER) {
            builder2.error(SmartyBundle.message("parsing.error.identifier.expected", new Object[0]));
            mark.drop();
            return false;
        }
        builder2.advanceLexer();
        mark.done(SmartyCompositeElementTypes.DEFINITION);
        return true;
    }

    private static void parseVariableInner(PsiBuilder builder2) {
        boolean isNamespace;
        PsiBuilder.Marker referenceExpression = builder2.mark();
        boolean start = true;
        boolean bl = isNamespace = builder2.lookAhead(1) == SmartyTokenTypes.BACK_SLASH;
        if (isNamespace) {
            SmartyExpressionParser.parseNamespacedReference(builder2);
        }
        while (builder2.getTokenType() == SmartyTokenTypes.DOT || builder2.getTokenType() == SmartyTokenTypes.COLON_COLON || builder2.getTokenType() == SmartyTokenTypes.ARROW || start) {
            if (!(start || builder2.getTokenType() != SmartyTokenTypes.DOT && builder2.getTokenType() != SmartyTokenTypes.ARROW && builder2.getTokenType() != SmartyTokenTypes.DOLLAR && builder2.getTokenType() != SmartyTokenTypes.COLON_COLON)) {
                builder2.advanceLexer();
                if (builder2.getTokenType() == SmartyTokenTypes.DOLLAR) {
                    builder2.advanceLexer();
                }
            }
            if (builder2.getTokenType() != SmartyTokenTypes.IDENTIFIER && builder2.getTokenType() != SmartyTokenTypes.NUMERIC_LITERAL && builder2.getTokenType() != SmartyTokenTypes.START_TAG_START) break;
            boolean isID = false;
            do {
                if (builder2.getTokenType() == SmartyTokenTypes.START_TAG_START) {
                    new SmartyTagsParser(builder2.getProject()).parseOneSmartyTagInInnerConstruction(builder2, true);
                    isID = false;
                    continue;
                }
                if (isID) break;
                builder2.advanceLexer();
                isID = true;
            } while (builder2.getTokenType() == SmartyTokenTypes.IDENTIFIER || builder2.getTokenType() == SmartyTokenTypes.NUMERIC_LITERAL || builder2.getTokenType() == SmartyTokenTypes.START_TAG_START);
            referenceExpression.done(SmartyCompositeElementTypes.REFERENCE);
            if (start && builder2.getTokenType() == SmartyTokenTypes.SILENCE) {
                PsiBuilder.Marker mark = builder2.mark();
                builder2.advanceLexer();
                if (builder2.getTokenType() != SmartyTokenTypes.IDENTIFIER) {
                    mark.rollbackTo();
                } else {
                    String tokenText = builder2.getTokenText();
                    if (tokenText != null) {
                        builder2.advanceLexer();
                        start = false;
                        mark.drop();
                        referenceExpression = referenceExpression.precede();
                        referenceExpression.done(SmartyCompositeElementTypes.REFERENCE);
                        referenceExpression = referenceExpression.precede();
                        break;
                    }
                    mark.rollbackTo();
                }
            }
            if (builder2.getTokenType() == SmartyTokenTypes.L_PAR) {
                referenceExpression = referenceExpression.precede();
                SmartyExpressionParser.parseArgumentsList(builder2);
                referenceExpression.done(SmartyCompositeElementTypes.FUNCTION_CALL);
            }
            while (builder2.getTokenType() == SmartyTokenTypes.L_BRACKET) {
                SmartyExpressionParser.parseArrayAccess(builder2);
            }
            referenceExpression = referenceExpression.precede();
            if (!start && builder2.getTokenType() == SmartyTokenTypes.COLON_COLON) {
                builder2.error(SmartyBundle.message("parsing.error.static.access.not.allowed", new Object[0]));
            }
            start = false;
        }
        if (start) {
            builder2.error(SmartyBundle.message("parsing.error.reference.expected", new Object[0]));
        }
        referenceExpression.drop();
    }

    private static void parseArgumentsList(PsiBuilder builder2) {
        PsiBuilder.Marker argumentList = builder2.mark();
        if (builder2.getTokenType() != SmartyTokenTypes.L_PAR) {
            builder2.error(SmartyBundle.message("parsing.error.left.brace.expected", new Object[0]));
        } else {
            builder2.advanceLexer();
        }
        if (builder2.getTokenType() != SmartyTokenTypes.R_PAR) {
            SmartyExpressionParser.parseExprList(builder2);
        }
        if (builder2.getTokenType() != SmartyTokenTypes.R_PAR) {
            builder2.error(SmartyBundle.message("parsing.error.right.brace.expected", new Object[0]));
        }
        builder2.advanceLexer();
        argumentList.done(SmartyCompositeElementTypes.ARGUMENT_LIST);
    }

    private static void parseExprList(PsiBuilder builder2) {
        if (!SmartyExpressionParser.parseArrayDefinition(builder2)) {
            SmartyExpressionParser.parseExpression(builder2);
        }
        if (builder2.getTokenType() == SmartyTokenTypes.COMMA) {
            builder2.advanceLexer();
            SmartyExpressionParser.parseExprList(builder2);
        }
    }

    private static void parseArrayAccess(PsiBuilder builder2) {
        assert (builder2.getTokenType() == SmartyTokenTypes.L_BRACKET);
        builder2.advanceLexer();
        if (builder2.getTokenType() == SmartyTokenTypes.R_BRACKET) {
            builder2.advanceLexer();
            if (builder2.getTokenType() != SmartyTokenTypes.EQ) {
                builder2.error(SmartyBundle.message("parsing.error.assign.expected", new Object[0]));
            }
            return;
        }
        if (!SmartyExpressionParser.parseExpression(builder2)) {
            builder2.error(SmartyBundle.message("parsing.error.reference.expected", new Object[0]));
        }
        if (builder2.getTokenType() != SmartyTokenTypes.R_BRACKET) {
            builder2.error(SmartyBundle.message("parsing.error.right.square.brace.expected", new Object[0]));
        } else {
            builder2.advanceLexer();
        }
    }

    public static void parseOperand(PsiBuilder builder2) {
        IElementType tokenType = builder2.getTokenType();
        if (tokenType == SmartyTokenTypes.L_PAR) {
            builder2.advanceLexer();
            SmartyExpressionParser.parseExpression(builder2);
            if (builder2.getTokenType() != SmartyTokenTypes.R_PAR) {
                builder2.error(SmartyBundle.message("parsing.error.right.brace.expected", new Object[0]));
                return;
            }
            builder2.advanceLexer();
        } else if (SmartyTokenTypes.PREFIX_OPERATIONS.contains(tokenType)) {
            builder2.advanceLexer();
            SmartyExpressionParser.parseOperand(builder2);
        } else {
            if (!SmartyExpressionParser.parseVariable(builder2)) {
                builder2.error(SmartyBundle.message("parsing.error.reference.expected", new Object[0]));
            }
            if (SmartyTokenTypes.POSTFIX_OPERATIONS.contains(tokenType = builder2.getTokenType())) {
                builder2.advanceLexer();
            }
        }
    }
}

