/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.psalm;

import com.intellij.openapi.project.Project;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import com.jetbrains.php.tools.quality.QualityToolXmlMessageProcessor;
import com.jetbrains.php.tools.quality.psalm.PsalmGlobalInspection;
import com.jetbrains.php.tools.quality.psalm.PsalmQualityToolType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PsalmMessageProcessor
extends QualityToolXmlMessageProcessor {
    @NonNls
    private static final String WARNING_MESSAGE_START = "<file name=";
    @NonNls
    private static final String WARNING_MESSAGE_END = "</file>";
    @NonNls
    private static final String LINE_NUMBER_ATTR = "line";
    @NonNls
    private static final String COLUMN_NUMBER_ATTR = "column";
    private static final String MESSAGE_ATTR = "message";
    @NonNls
    private static final String SEVERITY_ATTR = "severity";
    final Project myProject;

    protected PsalmMessageProcessor(QualityToolAnnotatorInfo<?> info) {
        super(info);
        this.myProject = info.getProject();
    }

    protected QualityToolXmlMessageProcessor.XMLMessageHandler getXmlMessageHandler() {
        return new PsalmXmlMessageHandler();
    }

    public int getMessageStart(@NotNull String line) {
        if (line == null) {
            PsalmMessageProcessor.$$$reportNull$$$0(0);
        }
        return line.indexOf(WARNING_MESSAGE_START);
    }

    public int getMessageEnd(@NotNull String line) {
        if (line == null) {
            PsalmMessageProcessor.$$$reportNull$$$0(1);
        }
        return line.indexOf(WARNING_MESSAGE_END);
    }

    protected void processMessage(InputSource source) throws SAXException, IOException {
        if (this.myFile != null) {
            super.processMessage(source);
        } else {
            PsalmXmlMessageHandler messageHandler = (PsalmXmlMessageHandler)this.getXmlMessageHandler();
            this.mySAXParser.parse(source, (DefaultHandler)((Object)messageHandler));
            List data = (List)this.myProject.getUserData(PsalmGlobalInspection.PSALM_ANNOTATOR_INFO);
            QualityToolXmlMessageProcessor.ProblemDescription problemDescription = new QualityToolXmlMessageProcessor.ProblemDescription(messageHandler.getSeverity(), messageHandler.getLineNumber(), messageHandler.getColumn(), messageHandler.getMessageText(), messageHandler.getFile());
            if (data != null) {
                data.add(problemDescription);
                this.myProject.putUserData(PsalmGlobalInspection.PSALM_ANNOTATOR_INFO, (Object)data);
            } else {
                this.myProject.putUserData(PsalmGlobalInspection.PSALM_ANNOTATOR_INFO, new ArrayList<QualityToolXmlMessageProcessor.ProblemDescription>(Collections.singletonList(problemDescription)));
            }
        }
    }

    @NonNls
    @Nullable
    protected String getMessagePrefix() {
        return "psalm";
    }

    protected PsalmQualityToolType getQualityToolType() {
        return PsalmQualityToolType.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = LINE_NUMBER_ATTR;
        objectArray2[1] = "com/jetbrains/php/tools/quality/psalm/PsalmMessageProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMessageStart";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMessageEnd";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PsalmXmlMessageHandler
    extends QualityToolXmlMessageProcessor.XMLMessageHandler {
        String myFile;
        int myColumn = 0;

        private PsalmXmlMessageHandler() {
        }

        protected void parseTag(@NotNull String tagName, @NotNull Attributes attributes) {
            if (tagName == null) {
                PsalmXmlMessageHandler.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                PsalmXmlMessageHandler.$$$reportNull$$$0(1);
            }
            if (tagName.equals("file")) {
                this.myFile = attributes.getValue("name");
            } else {
                this.myLineNumber = PsalmXmlMessageHandler.parseLineNumber((String)attributes.getValue(PsalmMessageProcessor.LINE_NUMBER_ATTR));
                this.mySeverity = attributes.getValue(PsalmMessageProcessor.SEVERITY_ATTR).equals("error") ? QualityToolMessage.Severity.ERROR : QualityToolMessage.Severity.WARNING;
                this.myMessageBuf.append(attributes.getValue(PsalmMessageProcessor.MESSAGE_ATTR));
                this.myColumn = PsalmXmlMessageHandler.parseLineNumber((String)attributes.getValue(PsalmMessageProcessor.COLUMN_NUMBER_ATTR));
            }
        }

        public int getColumn() {
            return this.myColumn - 1;
        }

        public String getFile() {
            return this.myFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tagName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributes";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/tools/quality/psalm/PsalmMessageProcessor$PsalmXmlMessageHandler";
            objectArray[2] = "parseTag";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

