/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.hierarchy.call;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspCallHierarchyCustomizer;
import com.intellij.platform.lsp.api.customization.LspCallHierarchySupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.hierarchy.LspHierarchyUtilKt;
import com.intellij.platform.lsp.impl.hierarchy.call.LspCallHierarchyBrowser;
import com.intellij.platform.lsp.impl.hierarchy.call.LspCallHierarchyProviderKt;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/lsp/impl/hierarchy/call/LspCallHierarchyProvider;", "Lcom/intellij/ide/hierarchy/HierarchyProvider;", "LspCallHierarchyProvider", "()V", "getTarget", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "createHierarchyBrowser", "Lcom/intellij/ide/hierarchy/HierarchyBrowser;", "target", "browserActivated", "", "hierarchyBrowser", "G", "", "server", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lsp.impl"})
public final class LspCallHierarchyProvider
implements HierarchyProvider {
    @Nullable
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return LspHierarchyUtilKt.getTargetFromEditor(dataContext, (Key<LspServerImpl>)LspCallHierarchyProviderKt.access$getLSP_CALL_HIERARCHY_SERVER_KEY$p(), (Function2<? super LspServerImpl, ? super VirtualFile, Boolean>)((Function2)new Function2<LspServerImpl, VirtualFile, Boolean>((Object)this){

            public final Boolean invoke(LspServerImpl p0, VirtualFile p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return LspCallHierarchyProvider.access$shouldProceedWithServer((LspCallHierarchyProvider)this.receiver, p0, p1);
            }
        }));
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(@NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        LspServerImpl lspServerImpl = (LspServerImpl)target.getUserData(LspCallHierarchyProviderKt.access$getLSP_CALL_HIERARCHY_SERVER_KEY$p());
        if (lspServerImpl == null) {
            Project project = target.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = target.getContainingFile().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            lspServerImpl = LspHierarchyUtilKt.findSupportingServer(project, virtualFile, (Function2<? super LspServerImpl, ? super VirtualFile, Boolean>)((Function2)new Function2<LspServerImpl, VirtualFile, Boolean>((Object)this){

                public final Boolean invoke(LspServerImpl p0, VirtualFile p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return LspCallHierarchyProvider.access$shouldProceedWithServer((LspCallHierarchyProvider)this.receiver, p0, p1);
                }
            }));
            if (lspServerImpl == null) {
                throw new IllegalStateException("Missing cached LSP server on call-hierarchy target".toString());
            }
        }
        LspServerImpl lspServerImpl2 = lspServerImpl;
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (HierarchyBrowser)new LspCallHierarchyBrowser(project, target, lspServerImpl2);
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        Intrinsics.checkNotNullParameter((Object)hierarchyBrowser, (String)"hierarchyBrowser");
        LspCallHierarchyBrowser lspCallHierarchyBrowser = hierarchyBrowser instanceof LspCallHierarchyBrowser ? (LspCallHierarchyBrowser)hierarchyBrowser : null;
        if (lspCallHierarchyBrowser == null) {
            return;
        }
        LspCallHierarchyBrowser lspCallHierarchyBrowser2 = lspCallHierarchyBrowser;
        lspCallHierarchyBrowser2.changeView(CallHierarchyBrowserBase.getCallerType());
    }

    private final boolean G(LspServerImpl lspServerImpl, VirtualFile virtualFile) {
        LspCallHierarchyCustomizer lspCallHierarchyCustomizer = lspServerImpl.getDescriptor().getLspCustomization().getCallHierarchyCustomizer();
        return lspCallHierarchyCustomizer instanceof LspCallHierarchySupport && lspServerImpl.supportsCallHierarchy$intellij_platform_lsp_impl(virtualFile) && ((LspCallHierarchySupport)lspCallHierarchyCustomizer).shouldAskServerForCallHierarchy(virtualFile);
    }

    public static final /* synthetic */ boolean access$shouldProceedWithServer(LspCallHierarchyProvider $this, LspServerImpl server2, VirtualFile file) {
        return $this.G(server2, file);
    }
}

