/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.google.common.base.Joiner;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssTableValueBase<V extends CssTableValue, T>
implements CssTableValue<V, T> {
    private final List<V> myChildren;
    private final T myValue;
    private int myMinCount;
    private int myMaxCount;
    private String myPrefix;
    private String myValuesDelimiter;
    private CssTableValue.Type myType;
    private boolean hasImmutablePrefix;

    protected CssTableValueBase(@NotNull CssTableValue.Type type) {
        if (type == null) {
            CssTableValueBase.$$$reportNull$$$0(0);
        }
        this(null, type);
    }

    protected CssTableValueBase(@Nullable T value, @NotNull CssTableValue.Type type) {
        if (type == null) {
            CssTableValueBase.$$$reportNull$$$0(1);
        }
        this.myChildren = new SmartList();
        this.myMinCount = -1;
        this.myMaxCount = -1;
        this.myValuesDelimiter = " ";
        this.hasImmutablePrefix = false;
        this.myValue = value;
        this.myType = type;
    }

    protected CssTableValueBase(@Nullable T value) {
        this(value, CssTableValue.Type.DEFAULT);
    }

    public V addChild(@NotNull V child) {
        if (child == null) {
            CssTableValueBase.$$$reportNull$$$0(2);
        }
        this.myChildren.add(child);
        return child;
    }

    protected void removeChild(@NotNull V child) {
        if (child == null) {
            CssTableValueBase.$$$reportNull$$$0(3);
        }
        this.myChildren.remove(child);
    }

    protected void removeAllChildren() {
        this.myChildren.clear();
    }

    public T getValue() {
        return this.myValue;
    }

    @NotNull
    public CssTableValue.Type getType() {
        CssTableValue.Type type = this.myType;
        if (type == null) {
            CssTableValueBase.$$$reportNull$$$0(4);
        }
        return type;
    }

    public void setType(@NotNull CssTableValue.Type type) {
        if (type == null) {
            CssTableValueBase.$$$reportNull$$$0(5);
        }
        this.myType = type;
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    public void setPrefix(String prefix) {
        this.myPrefix = prefix;
    }

    public boolean hasImmutablePrefix() {
        return this.hasImmutablePrefix;
    }

    public void setHasImmutablePrefix(boolean hasImmutablePrefix) {
        this.hasImmutablePrefix = hasImmutablePrefix;
    }

    public String getValuesDelimiter() {
        return this.myValuesDelimiter;
    }

    public void setValuesDelimiter(String valuesDelimiter) {
        this.myValuesDelimiter = valuesDelimiter;
    }

    public boolean isGroup() {
        return !this.getChildren().isEmpty();
    }

    public int getMinCount() {
        return this.myMinCount;
    }

    public void setMinCount(int minCount) {
        this.myMinCount = minCount;
    }

    public int getMaxCount() {
        return this.myMaxCount;
    }

    public void setMaxCount(int maxCount) {
        this.myMaxCount = maxCount;
    }

    public List<V> getChildren() {
        return this.myChildren;
    }

    public void accept(@NotNull CssTableValueVisitor visitor) {
        if (visitor == null) {
            CssTableValueBase.$$$reportNull$$$0(6);
        }
        visitor.visit((CssTableValue)this);
    }

    public String toString() {
        if (!this.isGroup()) {
            return this.getValue().toString();
        }
        String separator = switch (this.myType) {
            default -> throw new MatchException(null, null);
            case CssTableValue.Type.OR -> " | ";
            case CssTableValue.Type.ANY -> " || ";
            case CssTableValue.Type.FULL_ANY -> " && ";
            case CssTableValue.Type.DEFAULT -> " ";
        };
        return "[" + Joiner.on((String)separator).join(this.myChildren) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssTableValueBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssTableValueBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

