/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDescription;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface FrameworkDescriptionProvider<UserData> {
    public static final ExtensionPointName<FrameworkDescriptionProvider> EP = new ExtensionPointName("com.jetbrains.php.framework.descriptionProvider");

    public FrameworkConfigurationDescription getFrameworkData(@Nullable UserData var1, @Nullable Project var2, @NotNull ProgressIndicator var3) throws RunCanceledByUserException, FrameworkParseException, FrameworkExecutionException;

    public FrameworkDescription getFrameworkDescription(UserData var1);

    @NotNull
    public String getFrameworkName();

    @Nullable
    public UserData getFrameworkUserData(@Nullable Project var1) throws RunCanceledByUserException;

    @Nullable
    public String getFrameworkId();

    public UserData parseUserData(FrameworkConfigurationDescription var1);

    public static class FrameworkExecutionException
    extends Exception {
        public FrameworkExecutionException(ExecutionException exception) {
            super(exception);
        }

        public ExecutionException getExecutionException() {
            return (ExecutionException)this.getCause();
        }
    }

    public static class FrameworkParseException
    extends Exception {
        private final String myCommand;
        private final String myOutput;
        private final String myParsingProblem;

        public FrameworkParseException(String[] command, String output, String parsingProblem) {
            StringBuilder sb = new StringBuilder();
            for (String s : command) {
                sb.append(" ").append(s);
            }
            this.myCommand = sb.substring(1);
            this.myOutput = output;
            this.myParsingProblem = parsingProblem;
        }

        public String getCommand() {
            return this.myCommand;
        }

        public String getOutput() {
            return this.myOutput;
        }

        public String getParsingProblem() {
            return this.myParsingProblem;
        }
    }
}

