/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.symfony;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.AbstractFrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.symfony.SymfonyPathDialog;
import com.jetbrains.php.framework.generators.symfony.SymfonyUtils;
import com.jetbrains.php.framework.generators.symfony.SymfonyVersion;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentUtils;
import com.jetbrains.php.framework.ui.FrameworkPathDialog;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SymfonyDescriptionProvider
extends AbstractFrameworkDescriptionProvider<VersionedData> {
    @NonNls
    public static final String SYMFONY_FRAMEWORK_ID = "com.symfony";

    @Override
    public FrameworkDescription getFrameworkDescription(VersionedData data) {
        return SymfonyUtils.getSymfonyFrameworkDescription(data);
    }

    @Override
    public List<FrameworkCommand> getFrameworkCommands(VersionedData data, @Nullable Project project, @NotNull ProgressIndicator pi) throws FrameworkDescriptionProvider.FrameworkExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        if (pi == null) {
            SymfonyDescriptionProvider.$$$reportNull$$$0(0);
        }
        try {
            return SymfonyUtils.getFrameworkCommands(data, project, pi);
        }
        catch (ExecutionException e) {
            throw new FrameworkDescriptionProvider.FrameworkExecutionException(e);
        }
    }

    @Override
    @NotNull
    public String getFrameworkName() {
        String string = SymfonyDescriptionProvider.getFrameworkNameText();
        if (string == null) {
            SymfonyDescriptionProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public VersionedData getFrameworkUserData(@Nullable Project project) throws RunCanceledByUserException {
        SymfonyPathDialog dialog = SymfonyPathDialog.getInstance(project);
        if (!dialog.showAndGet()) {
            throw new RunCanceledByUserException();
        }
        return new VersionedData(dialog.getData(), dialog.getVersion());
    }

    @Override
    public String getFrameworkId() {
        return SYMFONY_FRAMEWORK_ID;
    }

    @Override
    public VersionedData parseUserData(FrameworkConfigurationDescription framework) {
        String invokeText = framework.getInvokeText();
        FrameworkPathDialog.Data data = FrameworkPathDialog.Data.parseInvokeText(invokeText);
        SymfonyVersion version = SymfonyComponentUtils.deserializeFromExtraData(framework.getFramework().getExtraData());
        return new VersionedData(data, version);
    }

    public static String getFrameworkNameText() {
        return FrameworkBundle.message("framework.symfony.name.symfony", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/generators/symfony/SymfonyDescriptionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/generators/symfony/SymfonyDescriptionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkCommands";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static final class VersionedData {
        private final SymfonyVersion myVersion;
        private final FrameworkPathDialog.Data myData;

        VersionedData(FrameworkPathDialog.Data data, SymfonyVersion version) {
            this.myData = data;
            this.myVersion = version;
        }

        public SymfonyVersion getVersion() {
            return this.myVersion;
        }

        public FrameworkPathDialog.Data getData() {
            return this.myData;
        }
    }
}

