/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.zendtool.first;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.zendtool.first.Zend1Command;
import com.jetbrains.php.framework.generators.zendtool.first.Zend1DescriptionProvider;
import com.jetbrains.php.framework.generators.zendtool.first.Zend1HelpParser;
import com.jetbrains.php.framework.generators.zendtool.first.Zend1Manifest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Zend1Utils {
    private static final String DEFAULT_ALIAS = "zf1";
    private static final Map<Trinity<String, String, String>, String> myFirstDefaultNullValues = new HashMap<Trinity<String, String, String>, String>();

    private Zend1Utils() {
    }

    @NotNull
    private static List<Zend1Command> getCommands(String path, @Nullable Project project, FrameworkDescription framework, ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        Zend1Manifest manifest = new Zend1Manifest();
        FrameworkUtils.checkProgress(pi);
        ScriptRunnerUtil.ScriptOutput manifestDescription = Zend1Utils.getManifestDescription(path, project);
        for (String command : manifestDescription.getOutputToParseArray()) {
            manifest.parseString(command);
        }
        FrameworkUtils.checkProgress(pi);
        List<Zend1Command> commands = manifest.getConsoleCommandData();
        if (commands.isEmpty()) {
            throw new FrameworkDescriptionProvider.FrameworkParseException(Zend1Utils.getManifestCommand(path), manifestDescription.getDescriptiveOutput(), FrameworkBundle.message("framework.zend1.no.commands.found", new Object[0]));
        }
        Zend1HelpParser.fillWithDefaultValueAndHelp(commands, path, project, framework, pi);
        Zend1Utils.patchDefaultValues(commands);
        List<Zend1Command> list = commands;
        if (list == null) {
            Zend1Utils.$$$reportNull$$$0(0);
        }
        return list;
    }

    static List<FrameworkCommand> getFrameworkCommands(String path, @Nullable Project project, ProgressIndicator pi) throws FrameworkDescriptionProvider.FrameworkParseException, FrameworkDescriptionProvider.FrameworkExecutionException, RunCanceledByUserException {
        List<Zend1Command> zend1Commands;
        FrameworkDescription zendDescription = Zend1Utils.getFrameworkDescription(path);
        FrameworkUtils.checkProgress(pi);
        try {
            zend1Commands = Zend1Utils.getCommands(path, project, zendDescription, pi);
        }
        catch (ExecutionException e) {
            throw new FrameworkDescriptionProvider.FrameworkExecutionException(e);
        }
        ArrayList<FrameworkCommand> commands = new ArrayList<FrameworkCommand>(zend1Commands.size());
        for (Zend1Command zend1Command : zend1Commands) {
            commands.add(Zend1Command.getFrameworkCommand(zend1Command, zendDescription));
        }
        return commands;
    }

    private static void patchDefaultValues(List<Zend1Command> commands) {
        for (Zend1Command command : commands) {
            if (Zend1Utils.isCreateProjectCommand(command)) {
                for (FrameworkCommand.Parameter parameter : command.getParameters()) {
                    if (!"path".equals(parameter.getName())) continue;
                    parameter.setDefaultValue("\"" + FrameworkUtils.PROJECT_DIR_VARIABLE_SYMBOL + "\"");
                }
            }
            boolean foundDefaultValue = false;
            String firstNullDefaultParameter = myFirstDefaultNullValues.get(new Trinity((Object)command.getProvider(), (Object)command.getAction(), (Object)command.getSpecialty()));
            for (FrameworkCommand.Parameter parameter : command.getParameters()) {
                if (parameter.hasDefaultValue()) {
                    foundDefaultValue = true;
                    continue;
                }
                if (parameter.getName().equals(firstNullDefaultParameter)) {
                    foundDefaultValue = true;
                    parameter.setDefaultValue("null");
                    continue;
                }
                if (!foundDefaultValue || parameter.getDefaultValue() != null) continue;
                parameter.setDefaultValue("null");
            }
        }
    }

    private static boolean isCreateProjectCommand(Zend1Command command) {
        return "project".equals(command.getProvider()) && "create".equals(command.getAction());
    }

    @NotNull
    static FrameworkDescription getFrameworkDescription(String path) {
        if (((String)path).contains(" ")) {
            path = "\"" + (String)path + "\"";
        }
        return new FrameworkDescription(Zend1DescriptionProvider.getFrameworkNameText() + "_" + FrameworkUtils.getCurrentFormattedDate(), (String)path, DEFAULT_ALIAS, true, "com.zend.framework", null);
    }

    private static ScriptRunnerUtil.ScriptOutput getManifestDescription(String path, @Nullable Project project) throws ExecutionException {
        return FrameworkUtils.executeCommandWithFullOutput(Zend1Utils.getManifestCommand(path), null, project, true, !SystemInfo.isWindows);
    }

    private static String[] getManifestCommand(String path) {
        return new String[]{path, "show", "manifest"};
    }

    static {
        myFirstDefaultNullValues.put((Trinity<String, String, String>)new Trinity((Object)"project", (Object)"create", null), "name-of-profile");
        myFirstDefaultNullValues.put((Trinity<String, String, String>)new Trinity((Object)"model", (Object)"create", null), "module");
        myFirstDefaultNullValues.put((Trinity<String, String, String>)new Trinity((Object)"form", (Object)"create", null), "module");
        myFirstDefaultNullValues.put((Trinity<String, String, String>)new Trinity((Object)"db-adapter", (Object)"configure", null), "dsn");
        myFirstDefaultNullValues.put((Trinity<String, String, String>)new Trinity((Object)"db-table", (Object)"create", null), "module");
        myFirstDefaultNullValues.put((Trinity<String, String, String>)new Trinity((Object)"db-table", (Object)"create", (Object)"from-database"), "module");
        myFirstDefaultNullValues.put((Trinity<String, String, String>)new Trinity((Object)"project-provider", (Object)"create", null), "actions");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/framework/generators/zendtool/first/Zend1Utils", "getCommands"));
    }
}

