/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.elements;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.jetbrains.twig.elements.TwigBlockTag;
import com.jetbrains.twig.util.TwigLookupUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigBlockReference
extends PsiReferenceBase<PsiElement> {
    private final TwigBlockResolver BLOCK_RESOLVER;
    private final Project myProject;
    private final String myIdentifier;

    public TwigBlockReference(@NotNull Project project, @NotNull TwigBlockTag source, TextRange range) {
        if (project == null) {
            TwigBlockReference.$$$reportNull$$$0(0);
        }
        if (source == null) {
            TwigBlockReference.$$$reportNull$$$0(1);
        }
        super((PsiElement)source, range, true);
        this.BLOCK_RESOLVER = new TwigBlockResolver();
        this.myProject = project;
        PsiElement identifierElement = source.findIdentifier();
        this.myIdentifier = identifierElement != null ? identifierElement.getText() : null;
    }

    @Nullable
    public PsiElement resolve() {
        TwigBlockResolveResult resolved = (TwigBlockResolveResult)ResolveCache.getInstance((Project)this.myProject).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)this.BLOCK_RESOLVER, false, false);
        return resolved != null ? resolved.getIdentifier() : null;
    }

    @NotNull
    public String getIdentifier() {
        return this.myIdentifier != null ? this.myIdentifier : "";
    }

    @Nullable
    TwigBlockResolveResult resolveDefinition() {
        PsiElement source = this.getElement();
        assert (source instanceof TwigBlockTag);
        if (this.myIdentifier == null) {
            return null;
        }
        TwigBlockTag target = TwigLookupUtil.findBaseTag(this.getElement().getContainingFile(), this.myIdentifier);
        return new TwigBlockResolveResult(target);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        PsiElement parent;
        PsiElement resolved;
        if (element == null) {
            TwigBlockReference.$$$reportNull$$$0(2);
        }
        if ((resolved = this.resolve()) != null && (parent = resolved.getParent()) instanceof TwigBlockTag) {
            return parent == element;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/twig/elements/TwigBlockReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenceTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TwigBlockResolver
    implements ResolveCache.AbstractResolver<TwigBlockReference, TwigBlockResolveResult> {
        private TwigBlockResolver() {
        }

        public TwigBlockResolveResult resolve(@NotNull TwigBlockReference reference, boolean incompleteCode) {
            if (reference == null) {
                TwigBlockResolver.$$$reportNull$$$0(0);
            }
            return reference.resolveDefinition();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/twig/elements/TwigBlockReference$TwigBlockResolver", "resolve"));
        }
    }

    private static final class TwigBlockResolveResult
    implements ResolveResult {
        private final TwigBlockTag myTag;

        private TwigBlockResolveResult(@Nullable TwigBlockTag tag) {
            this.myTag = tag;
        }

        @Nullable
        public PsiElement getElement() {
            return this.myTag;
        }

        @Nullable
        private PsiElement getIdentifier() {
            return this.myTag != null ? this.myTag.findIdentifier() : null;
        }

        public boolean isValidResult() {
            PsiElement identifier = this.getIdentifier();
            return identifier == null || identifier.isValid();
        }
    }
}

