/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

@NotNullByDefault
public abstract class AbstractStepDefinitionCreator
implements StepDefinitionCreator {
    @Override
    public String getStepDefinitionFilePath(PsiFile psiFile) {
        String name;
        VirtualFile file = psiFile.getVirtualFile();
        assert (file != null);
        VirtualFile parent = file.getParent();
        if (parent != null && "step_definitions".equals(parent.getName())) {
            return file.getName();
        }
        ArrayList<String> dirsReversed = new ArrayList<String>();
        while (parent != null && !"step_definitions".equals(name = parent.getName())) {
            dirsReversed.add(name);
            parent = parent.getParent();
        }
        StringBuilder buf = new StringBuilder();
        for (int i = dirsReversed.size() - 1; i >= 0; --i) {
            buf.append((String)dirsReversed.get(i)).append(File.separatorChar);
        }
        buf.append(file.getName());
        return buf.toString();
    }

    @Override
    public String getDefaultStepDefinitionFolderPath(GherkinStep step) {
        PsiFile featureFile = step.getContainingFile();
        PsiDirectory dir = AbstractStepDefinitionCreator.findStepDefinitionDirectory(featureFile);
        if (dir != null) {
            return dir.getVirtualFile().getPath();
        }
        return FileUtil.join((String[])new String[]{featureFile.getContainingDirectory().getVirtualFile().getPath(), "step_definitions"});
    }

    @Nullable
    private static PsiDirectory findStepDefinitionDirectory(PsiFile featureFile) {
        VirtualFile stepsDir;
        VirtualFile featureDir;
        PsiDirectory psiFeatureDir = featureFile.getContainingDirectory();
        assert (psiFeatureDir != null);
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)featureFile.getProject()).getFileIndex().getContentRootForFile(featureDir);
        for (featureDir = psiFeatureDir.getVirtualFile(); featureDir != null && !Comparing.equal((Object)featureDir, (Object)contentRoot) && featureDir.findChild("step_definitions") == null; featureDir = featureDir.getParent()) {
        }
        if (featureDir != null && (stepsDir = featureDir.findChild("step_definitions")) != null) {
            return featureFile.getManager().findDirectory(stepsDir);
        }
        return null;
    }

    protected void closeActiveTemplateBuilders(PsiFile file) {
        Project project = file.getProject();
        VirtualFile vFile = Objects.requireNonNull(file.getVirtualFile());
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vFile);
        FileEditorManager.getInstance((Project)project).getAllEditors(vFile);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        TemplateManager templateManager = TemplateManager.getInstance((Project)file.getProject());
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        Template template = templateManager.getActiveTemplate(editor);
        if (templateState != null && template != null) {
            templateState.gotoEnd(false);
        }
    }
}

