/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.OutlineStepSubstitution;
import org.jetbrains.plugins.cucumber.ParameterTypeManager;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;
import org.jetbrains.plugins.cucumber.steps.search.CucumberStepSearchUtil;

public final class CucumberUtil {
    @NonNls
    public static final String STEP_DEFINITIONS_DIR_NAME = "step_definitions";
    public static final String[][] ARR = new String[][]{{"\\\\", "\\\\\\\\"}, {"\\|", "\\\\|"}, {"\\$", "\\\\\\$"}, {"\\^", "\\\\^"}, {"\\+", "\\+"}, {"\\-", "\\\\-"}, {"\\#", "\\\\#"}, {"\\?", "\\\\?"}, {"\\*", "\\\\*"}, {"\\/", "\\\\/"}, {"\\{", "\\\\{"}, {"\\}", "\\\\}"}, {"\\[", "\\\\["}, {"\\]", "\\\\]"}, {"\\(", "\\\\("}, {"\\)", "\\\\)"}, {"\\+", "\\\\+"}, {"\"([^\\\\\"]*)\"", "\"([^\"]*)\""}, {"(?<=^|[ .,])\\d+[ ]", "(\\\\d+) "}, {"(?<=^|[ .,])\\d+[,]", "(\\\\d+),"}, {"(?<=^|[ .,])\\d+[.]", "(\\\\d+)."}, {"(?<=^|[ .,])\\d+$", "(\\\\d+)"}, {"\\.", "\\\\."}, {"(<[^>]*>)", "(.*)"}};
    public static final String PREFIX_CHAR = "^";
    public static final String SUFFIX_CHAR = "$";
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("([\\\\^\\[$.|?*+\\]])");
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("(\\\\\\\\)?\\(([^)]+)\\)");
    private static final Pattern PARAMETER_SUBSTITUTION_PATTERN = Pattern.compile("<(?!<)([^>\n\r]+)>");
    private static final Pattern SCRIPT_STYLE_REGEXP = Pattern.compile("^/(.*)/$");
    public static final Map<String, String> STANDARD_PARAMETER_TYPES;

    public static boolean findGherkinReferencesToElement(@NotNull PsiElement stepDefinitionElement, @NotNull String regexp, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchScope effectiveSearchScope) {
        if (stepDefinitionElement == null) {
            CucumberUtil.$$$reportNull$$$0(0);
        }
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            CucumberUtil.$$$reportNull$$$0(2);
        }
        if (effectiveSearchScope == null) {
            CucumberUtil.$$$reportNull$$$0(3);
        }
        return CucumberUtil.findPossibleGherkinElementUsages(stepDefinitionElement, regexp, new MyReferenceCheckingProcessor(stepDefinitionElement, consumer), effectiveSearchScope);
    }

    public static boolean findPossibleGherkinElementUsages(@NotNull PsiElement stepDefinitionElement, @NotNull String regexp, @NotNull TextOccurenceProcessor processor, @NotNull SearchScope effectiveSearchScope) {
        String word;
        if (stepDefinitionElement == null) {
            CucumberUtil.$$$reportNull$$$0(4);
        }
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            CucumberUtil.$$$reportNull$$$0(6);
        }
        if (effectiveSearchScope == null) {
            CucumberUtil.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmptyOrSpaces((String)(word = CucumberUtil.getTheBiggestWordToSearchByIndex(regexp)))) {
            return true;
        }
        SearchScope searchScope = (SearchScope)ReadAction.compute(() -> CucumberStepSearchUtil.restrictScopeToGherkinFiles(effectiveSearchScope));
        int context = 5;
        PsiSearchHelper instance = PsiSearchHelper.getInstance((Project)stepDefinitionElement.getProject());
        return instance.processElementsWithWord(processor, searchScope, word, (short)5, true);
    }

    public static void findPossibleGherkinElementUsages(@NotNull PsiElement stepDefinitionElement, @NotNull String regexp, @NotNull ReferencesSearch.SearchParameters params, @NotNull RequestResultProcessor processor) {
        String word;
        if (stepDefinitionElement == null) {
            CucumberUtil.$$$reportNull$$$0(8);
        }
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(9);
        }
        if (params == null) {
            CucumberUtil.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            CucumberUtil.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmptyOrSpaces((String)(word = CucumberUtil.getTheBiggestWordToSearchByIndex(regexp)))) {
            return;
        }
        SearchScope searchScope = CucumberStepSearchUtil.restrictScopeToGherkinFiles(params.getEffectiveSearchScope());
        int searchContext = 5;
        params.getOptimizer().searchWord(word, searchScope, (short)5, true, stepDefinitionElement, processor);
    }

    public static String getTheBiggestWordToSearchByIndex(@NotNull String regexp) {
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(12);
        }
        String result = "";
        int start = 0;
        if (regexp.startsWith(PREFIX_CHAR)) {
            start += PREFIX_CHAR.length();
        }
        int end = regexp.length();
        if (regexp.endsWith(SUFFIX_CHAR)) {
            end -= SUFFIX_CHAR.length();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            char c = regexp.charAt(i);
            if (sb != null && Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb != null && sb.length() > result.length()) {
                    result = sb.toString();
                }
                sb = new StringBuilder();
                continue;
            }
            sb = null;
        }
        if (sb != null && sb.toString().length() > result.length()) {
            result = sb.toString();
        }
        return result;
    }

    public static String prepareStepRegexp(String stepName) {
        String result = stepName;
        for (String[] rule : ARR) {
            result = result.replaceAll(rule[0], rule[1]);
        }
        return result;
    }

    @NotNull
    public static List<TextRange> getCukexHighlightRanges(@NotNull String expression) {
        if (expression == null) {
            CucumberUtil.$$$reportNull$$$0(13);
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int parameterStartIndex = -1;
        boolean isEscaped = false;
        for (int i = 0; i < expression.length(); ++i) {
            char currentChar = expression.charAt(i);
            if (isEscaped) {
                isEscaped = false;
                continue;
            }
            if (currentChar == '\\') {
                isEscaped = true;
                continue;
            }
            if (currentChar == '{') {
                if (parameterStartIndex != -1) continue;
                parameterStartIndex = i;
                continue;
            }
            if (currentChar != '}' || parameterStartIndex == -1) continue;
            ranges.add(new TextRange(parameterStartIndex, i + 1));
            parameterStartIndex = -1;
        }
        ArrayList<TextRange> arrayList = ranges;
        if (arrayList == null) {
            CucumberUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static List<TextRange> getCukexRanges(@NotNull String expression) {
        if (expression == null) {
            CucumberUtil.$$$reportNull$$$0(15);
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int parameterStartIndex = -1;
        boolean isEscaped = false;
        boolean inAlternativeGroup = false;
        int alternativeGroupStartIndex = -1;
        for (int i = 0; i < expression.length(); ++i) {
            char currentChar = expression.charAt(i);
            if (isEscaped) {
                isEscaped = false;
                continue;
            }
            if (currentChar == '\\') {
                isEscaped = true;
                continue;
            }
            if (currentChar == '{' || currentChar == '(') {
                if (parameterStartIndex != -1) continue;
                parameterStartIndex = i;
                continue;
            }
            if (currentChar == '}' || currentChar == ')') {
                if (parameterStartIndex == -1) continue;
                ranges.add(new TextRange(parameterStartIndex, i + 1));
                parameterStartIndex = -1;
                continue;
            }
            if (currentChar == '/') {
                int j;
                if (inAlternativeGroup) continue;
                for (j = i - 1; j >= 0 && !Character.isWhitespace(expression.charAt(j)); --j) {
                }
                alternativeGroupStartIndex = j + 1;
                inAlternativeGroup = true;
                continue;
            }
            if (!inAlternativeGroup || !Character.isWhitespace(currentChar)) continue;
            ranges.add(new TextRange(alternativeGroupStartIndex, i));
            inAlternativeGroup = false;
            alternativeGroupStartIndex = -1;
        }
        if (inAlternativeGroup && alternativeGroupStartIndex != -1) {
            ranges.add(new TextRange(alternativeGroupStartIndex, expression.length()));
        }
        ArrayList<TextRange> arrayList = ranges;
        if (arrayList == null) {
            CucumberUtil.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> textRangesOutsideToSubstrings(String cukex, @NotNull List<TextRange> ranges) {
        if (ranges == null) {
            CucumberUtil.$$$reportNull$$$0(17);
        }
        ArrayList<String> result = new ArrayList<String>();
        int lastStart = 0;
        for (TextRange range : ranges) {
            String part = cukex.substring(lastStart, range.getStartOffset());
            result.add(part);
            lastStart = range.getEndOffset();
        }
        if (lastStart != 0) {
            String lastPart = cukex.substring(lastStart);
            result.add(lastPart);
        } else {
            result.add(cukex);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            CucumberUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    public static boolean isCucumberExpression(@NotNull String expression) {
        if (expression == null) {
            CucumberUtil.$$$reportNull$$$0(19);
        }
        return !expression.startsWith(PREFIX_CHAR) && !expression.endsWith(SUFFIX_CHAR) && !SCRIPT_STYLE_REGEXP.matcher(expression).find();
    }

    @NotNull
    public static String replaceOptionalTextWithRegex(@NotNull String cucumberExpression) {
        if (cucumberExpression == null) {
            CucumberUtil.$$$reportNull$$$0(20);
        }
        Matcher matcher = OPTIONAL_PATTERN.matcher(cucumberExpression);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String parameterPart = matcher.group(2);
            if ("\\\\".equals(matcher.group(1))) {
                matcher.appendReplacement(result, "\\\\(" + parameterPart + "\\\\)");
                continue;
            }
            matcher.appendReplacement(result, "(" + parameterPart + ")?");
        }
        matcher.appendTail(result);
        String string = result.toString();
        if (string == null) {
            CucumberUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String replaceAlternativeTextWithRegex(@NotNull String cucumberExpression) {
        if (cucumberExpression == null) {
            CucumberUtil.$$$reportNull$$$0(22);
        }
        StringBuilder result = new StringBuilder();
        boolean inGroup = false;
        for (int i = 0; i < cucumberExpression.length(); ++i) {
            char c = cucumberExpression.charAt(i);
            if (c == '/') {
                if (!inGroup) {
                    int j;
                    for (j = result.length() - 1; j >= 0 && !Character.isWhitespace(result.charAt(j)); --j) {
                    }
                    result.insert(j + 1, "(");
                    inGroup = true;
                }
                result.append('|');
                continue;
            }
            if (c == '|') {
                result.append("\\|");
                continue;
            }
            if (inGroup && Character.isWhitespace(c)) {
                result.append(')');
                inGroup = false;
            }
            result.append(c);
        }
        if (inGroup) {
            result.append(')');
        }
        String string = result.toString();
        if (string == null) {
            CucumberUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @TestOnly
    @NotNull
    public static String buildRegexpFromCucumberExpression(@NotNull String cucumberExpression) {
        if (cucumberExpression == null) {
            CucumberUtil.$$$reportNull$$$0(24);
        }
        return CucumberUtil.buildRegexpFromCucumberExpression(cucumberExpression, MapParameterTypeManager.DEFAULT);
    }

    @NotNull
    public static String buildRegexpFromCucumberExpression(@NotNull String cucumberExpression, @NotNull ParameterTypeManager parameterTypeManager) {
        if (cucumberExpression == null) {
            CucumberUtil.$$$reportNull$$$0(25);
        }
        if (parameterTypeManager == null) {
            CucumberUtil.$$$reportNull$$$0(26);
        }
        String cucumberExpression1 = CucumberUtil.escapeCucumberExpression(cucumberExpression);
        String cucumberExpression2 = CucumberUtil.replaceOptionalTextWithRegex(cucumberExpression1);
        String escapedCucumberExpression = CucumberUtil.replaceAlternativeTextWithRegex(cucumberExpression2);
        ArrayList rangesAndParameterTypeValues = new ArrayList();
        CucumberUtil.processParameterTypesInCucumberExpression(escapedCucumberExpression, (Processor<? super TextRange>)((Processor)range -> {
            String parameterTypeName = escapedCucumberExpression.substring(range.getStartOffset() + 1, range.getEndOffset() - 1);
            String parameterTypeValue = parameterTypeManager.getParameterTypeValue(parameterTypeName);
            rangesAndParameterTypeValues.add(Pair.create((Object)range, (Object)parameterTypeValue));
            return true;
        }));
        StringBuilder result = new StringBuilder(escapedCucumberExpression);
        Collections.reverse(rangesAndParameterTypeValues);
        for (Pair rangeAndValue : rangesAndParameterTypeValues) {
            String value = (String)rangeAndValue.getSecond();
            if (value == null) {
                String string = escapedCucumberExpression;
                if (string == null) {
                    CucumberUtil.$$$reportNull$$$0(27);
                }
                return string;
            }
            int startOffset = ((TextRange)rangeAndValue.first).getStartOffset();
            int endOffset = ((TextRange)rangeAndValue.first).getEndOffset();
            result.replace(startOffset, endOffset, "(" + value + ")");
        }
        result.insert(0, '^');
        result.append('$');
        String string = result.toString();
        if (string == null) {
            CucumberUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    public static void processParameterTypesInCucumberExpression(@NotNull String cucumberExpression, @NotNull Processor<? super TextRange> processor) {
        if (cucumberExpression == null) {
            CucumberUtil.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            CucumberUtil.$$$reportNull$$$0(30);
        }
        int i = 0;
        boolean isEscaped = false;
        while (i < cucumberExpression.length()) {
            char c = cucumberExpression.charAt(i);
            if (isEscaped) {
                isEscaped = false;
                ++i;
                continue;
            }
            if (c == '{') {
                char parameterTypeChar;
                int j;
                for (j = i; j < cucumberExpression.length() && (parameterTypeChar = cucumberExpression.charAt(j)) != '}'; ++j) {
                    if (parameterTypeChar != '\\') continue;
                    ++j;
                }
                if (j < cucumberExpression.length()) {
                    processor.process((Object)TextRange.create((int)i, (int)(j + 1)));
                    i = j + 1;
                    continue;
                }
                return;
            }
            if (c == '\\') {
                if (i >= cucumberExpression.length() - 1) {
                    return;
                }
                isEscaped = true;
                ++i;
                continue;
            }
            ++i;
        }
    }

    @NotNull
    public static OutlineStepSubstitution substituteTableReferences(String stepName, @Nullable Map<String, String> outlineTableMap) {
        int start;
        if (outlineTableMap == null) {
            return new OutlineStepSubstitution(stepName, Collections.emptyList());
        }
        ArrayList<Pair> offsets = new ArrayList<Pair>();
        StringBuilder result = new StringBuilder();
        int currentOffset = 0;
        while ((start = stepName.indexOf(60, currentOffset)) >= 0) {
            int end = -1;
            for (int i = start + 1; i < stepName.length(); ++i) {
                char c = stepName.charAt(i);
                if (c == '>') {
                    end = i;
                    break;
                }
                if (c != '<') continue;
                start = i;
            }
            if (end < 0) break;
            String columnName = stepName.substring(start + 1, end);
            String value = outlineTableMap.get(columnName);
            if (value == null) {
                return new OutlineStepSubstitution(stepName);
            }
            result.append(stepName.subSequence(currentOffset, start));
            int replaceOffset = result.length();
            result.append(value);
            int outlineParameterLength = end - start + 1;
            int valueLength = value.length();
            offsets.add(new Pair((Object)replaceOffset, (Object)(outlineParameterLength - valueLength)));
            currentOffset = end + 1;
        }
        result.append(stepName.subSequence(currentOffset, stepName.length()));
        return new OutlineStepSubstitution(result.toString(), offsets);
    }

    public static void addSubstitutionFromText(String text, List<String> substitutions) {
        Matcher matcher = PARAMETER_SUBSTITUTION_PATTERN.matcher(text);
        boolean result = matcher.find();
        if (!result) {
            return;
        }
        do {
            String substitution;
            if (StringUtil.isEmpty((String)(substitution = matcher.group(1))) || substitutions.contains(substitution)) continue;
            substitutions.add(substitution);
        } while (result = matcher.find());
    }

    public static String escapeCucumberExpression(@NotNull String stepPattern) {
        if (stepPattern == null) {
            CucumberUtil.$$$reportNull$$$0(31);
        }
        return ESCAPE_PATTERN.matcher(stepPattern).replaceAll("\\\\$1");
    }

    @Nullable
    public static PsiElement resolveSep(@NotNull GherkinStep step) {
        PsiReference reference;
        if (step == null) {
            CucumberUtil.$$$reportNull$$$0(32);
        }
        return (reference = (PsiReference)ContainerUtil.find((Object[])step.getReferences(), r -> r instanceof CucumberStepReference)) != null ? reference.resolve() : null;
    }

    @Nullable
    public static Integer getLineNumber(@NotNull PsiElement element) {
        if (element == null) {
            CucumberUtil.$$$reportNull$$$0(33);
        }
        PsiFile containingFile = element.getContainingFile();
        Project project = containingFile.getProject();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = psiDocumentManager.getDocument(containingFile);
        int textOffset = element.getTextOffset();
        if (document == null) {
            return null;
        }
        return document.getLineNumber(textOffset) + 1;
    }

    @Nullable
    public static CucumberStepReference getCucumberStepReference(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        for (PsiReference ref : element.getReferences()) {
            if (!(ref instanceof CucumberStepReference)) continue;
            CucumberStepReference stepReference = (CucumberStepReference)ref;
            return stepReference;
        }
        return null;
    }

    static {
        HashMap<String, String> standardParameterTypes = new HashMap<String, String>();
        standardParameterTypes.put("int", "-?\\d+");
        standardParameterTypes.put("float", "-?\\d*[.,]?\\d+");
        standardParameterTypes.put("word", "[^\\s]+");
        standardParameterTypes.put("string", "\"(?:[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*)\"|'(?:[^'\\\\]*(?:\\\\.[^'\\\\]*)*)'");
        standardParameterTypes.put("", "(.*)");
        STANDARD_PARAMETER_TYPES = Collections.unmodifiableMap(standardParameterTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 16, 18, 21, 23, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinitionElement";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveSearchScope";
                break;
            }
            case 6: 
            case 11: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/CucumberUtil";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cucumberExpression";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypeManager";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepPattern";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/CucumberUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCukexHighlightRanges";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCukexRanges";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "textRangesOutsideToSubstrings";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceOptionalTextWithRegex";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceAlternativeTextWithRegex";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRegexpFromCucumberExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findGherkinReferencesToElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPossibleGherkinElementUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTheBiggestWordToSearchByIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCukexHighlightRanges";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 27: 
            case 28: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCukexRanges";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "textRangesOutsideToSubstrings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberExpression";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replaceOptionalTextWithRegex";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replaceAlternativeTextWithRegex";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buildRegexpFromCucumberExpression";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processParameterTypesInCucumberExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "escapeCucumberExpression";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveSep";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumber";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 16, 18, 21, 23, 27, 28 -> new IllegalStateException(string);
        };
    }

    private static final class MyReferenceCheckingProcessor
    implements TextOccurenceProcessor {
        @NotNull
        private final PsiElement myElementToFind;
        @NotNull
        private final Processor<? super PsiReference> myConsumer;

        private MyReferenceCheckingProcessor(@NotNull PsiElement elementToFind, @NotNull Processor<? super PsiReference> consumer) {
            if (elementToFind == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(1);
            }
            this.myElementToFind = elementToFind;
            this.myConsumer = consumer;
        }

        public boolean execute(@NotNull PsiElement element, int offsetInElement) {
            if (element == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(2);
            }
            PsiElement parent = element.getParent();
            boolean result = this.executeInternal(element);
            if (result && parent != null) {
                return this.executeInternal(parent);
            }
            return result;
        }

        private boolean executeInternal(@NotNull PsiElement referenceOwner) {
            if (referenceOwner == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(3);
            }
            for (PsiReference ref : referenceOwner.getReferences()) {
                if (ref == null || !ref.isReferenceTo(this.myElementToFind) || this.myConsumer.process((Object)ref)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToFind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceOwner";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/cucumber/CucumberUtil$MyReferenceCheckingProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeInternal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

