/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber;

import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Map;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.ParameterTypeManager;

@NotNullByDefault
public class MapParameterTypeManager
implements ParameterTypeManager {
    public static final MapParameterTypeManager DEFAULT = new MapParameterTypeManager(CucumberUtil.STANDARD_PARAMETER_TYPES);
    private final Map<String, String> parameterTypesValues;
    @Nullable
    private final Map<String, SmartPsiElementPointer<PsiElement>> parameterTypesDeclarations;

    public MapParameterTypeManager(Map<String, String> parameterTypesValues) {
        this(parameterTypesValues, null);
    }

    public MapParameterTypeManager(Map<String, String> parameterTypesValues, @Nullable Map<String, SmartPsiElementPointer<PsiElement>> parameterTypeDeclarations) {
        this.parameterTypesValues = parameterTypesValues;
        this.parameterTypesDeclarations = parameterTypeDeclarations;
    }

    @Override
    @Nullable
    public String getParameterTypeValue(String name) {
        return this.parameterTypesValues.get(name);
    }

    @Override
    @Nullable
    public PsiElement getParameterTypeDeclaration(String name) {
        if (this.parameterTypesDeclarations == null) {
            return null;
        }
        SmartPsiElementPointer<PsiElement> smartPointer = this.parameterTypesDeclarations.get(name);
        return smartPointer != null ? smartPointer.getElement() : null;
    }
}

