/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.model.CreateStepDefinitionFileModel;
import org.jetbrains.plugins.cucumber.inspections.model.FileTypeComboboxItem;
import org.jetbrains.plugins.cucumber.steps.CucumberStepHelper;

public class CreateStepDefinitionFileDialog
extends DialogWrapper {
    private JTextField myFileNameTextField;
    private JComboBox<FileTypeComboboxItem> myFileTypeCombobox;
    private JPanel myContentPanel;
    private TextFieldWithBrowseButton myDirectoryTextField;
    private final InputValidator myValidator;
    private final CreateStepDefinitionFileModel myModel;

    public CreateStepDefinitionFileDialog(@NotNull Project project, final @NotNull CreateStepDefinitionFileModel model, @NotNull InputValidator validator) {
        if (project == null) {
            CreateStepDefinitionFileDialog.$$$reportNull$$$0(0);
        }
        if (model == null) {
            CreateStepDefinitionFileDialog.$$$reportNull$$$0(1);
        }
        if (validator == null) {
            CreateStepDefinitionFileDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myModel = model;
        this.myValidator = validator;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(CucumberBundle.message("cucumber.quick.fix.create.step.choose.new.file.dialog.title", objectArray));
        this.init();
        this.myFileTypeCombobox.setModel(model.getFileTypeModel());
        this.myFileTypeCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FileTypeComboboxItem newItem = (FileTypeComboboxItem)CreateStepDefinitionFileDialog.this.myFileTypeCombobox.getSelectedItem();
                FileTypeComboboxItem oldItem = (FileTypeComboboxItem)e.getItem();
                if (newItem != null && oldItem.getDefaultFileName().equals(CreateStepDefinitionFileDialog.this.myFileNameTextField.getText())) {
                    CreateStepDefinitionFileDialog.this.myFileNameTextField.setText(newItem.getDefaultFileName());
                    CreateStepDefinitionFileDialog.this.myModel.setFileName(newItem.getDefaultFileName());
                }
                CreateStepDefinitionFileDialog.this.myDirectoryTextField.setText(FileUtil.toSystemDependentName((String)model.getDefaultDirectory()));
            }
        });
        this.myFileNameTextField.setText(model.getFileName());
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CreateStepDefinitionFileDialog.this.myModel.setFileName(CreateStepDefinitionFileDialog.this.myFileNameTextField.getText());
                CreateStepDefinitionFileDialog.this.myModel.setDirectory(CreateStepDefinitionFileDialog.this.myDirectoryTextField.getText());
                CreateStepDefinitionFileDialog.this.validateAll();
            }
        };
        this.myFileNameTextField.addKeyListener(keyListener);
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)model.getStepDefinitionFolderPath()));
        if (virtualFile == null) {
            virtualFile = model.getContext().getContainingFile().getContainingDirectory().getVirtualFile();
        }
        this.myDirectoryTextField.addBrowseFolderListener(project, FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(CucumberBundle.message("cucumber.quick.fix.create.step.folder.chooser.title", new Object[0])).withRoots(new VirtualFile[]{virtualFile}).withTreeRootVisible(true).withShowFileSystemRoots(false).withHideIgnored(true));
        this.myDirectoryTextField.getTextField().addKeyListener(keyListener);
        this.myDirectoryTextField.setText(FileUtil.toSystemDependentName((String)model.getDefaultDirectory()));
        this.validateAll();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFileNameTextField;
    }

    protected void doOKAction() {
        String directoryName = this.myDirectoryTextField.getText();
        if (directoryName.length() > 1 && directoryName.endsWith(File.separator)) {
            directoryName = directoryName.substring(0, directoryName.length() - 1);
        }
        this.myModel.setDirectory(directoryName);
        String fileName = this.myFileNameTextField.getText();
        if (this.myValidator == null) {
            this.close(0);
        } else if (this.myValidator.checkInput(fileName) && this.myValidator.canClose(fileName)) {
            this.myModel.setFileName(this.myFileNameTextField.getText());
            this.close(0);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return CreateStepDefinitionFileDialog.class.getName();
    }

    private static boolean isValidPath(@NotNull String path) {
        if (path == null) {
            CreateStepDefinitionFileDialog.$$$reportNull$$$0(3);
        }
        while (!path.isEmpty()) {
            if (!PathUtil.isValidFileName((String)PathUtil.getFileName((String)path))) {
                return false;
            }
            path = PathUtil.getParentPath((String)path);
        }
        return true;
    }

    protected void validateAll() {
        boolean fileNameIsOk;
        if (!CreateStepDefinitionFileDialog.isValidPath(this.myDirectoryTextField.getText())) {
            this.setErrorText(CucumberBundle.message("cucumber.quick.fix.create.step.file.error.incorrect.directory", new Object[0]), (JComponent)this.myDirectoryTextField);
        } else {
            this.setErrorText(null, (JComponent)this.myDirectoryTextField);
        }
        String fileName = this.myFileNameTextField.getText();
        boolean bl = fileNameIsOk = fileName != null && PathUtil.isValidFileName((String)fileName) && CucumberStepHelper.validateNewStepDefinitionFileName(this.myModel.getProject(), fileName, this.myModel.getSelectedFileType());
        if (!fileNameIsOk) {
            this.setErrorText(CucumberBundle.message("cucumber.quick.fix.create.step.file.error.incorrect.file.name", new Object[0]), this.myFileNameTextField);
        } else {
            String fileUrl = VfsUtilCore.pathToUrl((String)FileUtil.join((String[])new String[]{this.myModel.getStepDefinitionFolderPath(), this.myModel.getFileNameWithExtension()}));
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
            if (vFile != null) {
                this.setErrorText(CucumberBundle.message("cucumber.quick.fix.create.step.file.error.file.exists", this.myModel.getFileNameWithExtension()), this.myFileNameTextField);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/ui/CreateStepDefinitionFileDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new FormLayout("fill:87px:noGrow,left:4dlu:noGrow,fill:max(p;100px):grow,left:4dlu:noGrow,fill:65px:noGrow,left:4dlu:noGrow,fill:201px:noGrow", "center:d:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(10);
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/CucumberBundle", CreateStepDefinitionFileDialog.class).getString("cucumber.quick.fix.create.step.choose.new.file.dialog.label.file.name"));
        jPanel.add((Component)jLabel, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myFileNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new CellConstraints(3, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/CucumberBundle", CreateStepDefinitionFileDialog.class).getString("cucumber.quick.fix.create.step.choose.new.file.dialog.label.file.type"));
        jPanel.add((Component)jLabel2, new CellConstraints(5, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JComboBox jComboBox = new JComboBox();
        this.myFileTypeCombobox = jComboBox;
        jPanel.add(jComboBox, new CellConstraints(7, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myDirectoryTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new CellConstraints(3, 3, 5, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/CucumberBundle", CreateStepDefinitionFileDialog.class).getString("cucumber.quick.fix.create.step.choose.new.file.dialog.label.file.location"));
        jPanel.add((Component)jLabel3, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

