/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.navigation;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;

@NotNullByDefault
public final class CucumberGoToRelatedProvider
extends GotoRelatedProvider {
    public List<? extends GotoRelatedItem> getItems(DataContext context) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file != null) {
            return this.getItems((PsiElement)file);
        }
        return Collections.emptyList();
    }

    public List<? extends GotoRelatedItem> getItems(PsiElement psiElement) {
        PsiFile file = psiElement.getContainingFile();
        if (file instanceof GherkinFile) {
            GherkinFeature[] features;
            GherkinFile gherkinFile = (GherkinFile)file;
            ArrayList steps = new ArrayList();
            for (GherkinFeature feature : features = gherkinFile.getFeatures()) {
                GherkinStepsHolder[] stepHolders;
                for (GherkinStepsHolder stepHolder : stepHolders = feature.getScenarios()) {
                    Collections.addAll(steps, stepHolder.getSteps());
                }
            }
            ArrayList<PsiFile> resultFiles = new ArrayList<PsiFile>();
            ArrayList<GotoRelatedItem> result = new ArrayList<GotoRelatedItem>();
            for (GherkinStep step : steps) {
                PsiFile stepDefFile;
                PsiElement stepDefMethod = CucumberUtil.resolveSep(step);
                if (stepDefMethod == null || resultFiles.contains(stepDefFile = stepDefMethod.getContainingFile())) continue;
                resultFiles.add(stepDefFile);
                result.add(new GotoRelatedItem((PsiElement)stepDefFile, CucumberBundle.message("create.step.definition.title", new Object[0])));
            }
            return result;
        }
        return Collections.emptyList();
    }
}

