/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.web.symbols;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolQualifiedKind;
import com.intellij.polySymbols.query.PolySymbolListSymbolsQueryParams;
import com.intellij.polySymbols.query.PolySymbolQueryStack;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueDirectiveModifier;
import org.jetbrains.vuejs.model.VueModelVisitor;
import org.jetbrains.vuejs.model.VueScopeElement;
import org.jetbrains.vuejs.web.PolySymbolsUtilsKt;
import org.jetbrains.vuejs.web.VueSymbolQueryConfiguratorKt;
import org.jetbrains.vuejs.web.symbols.VueAnySymbol;
import org.jetbrains.vuejs.web.symbols.VueDirectiveModifierSymbol;
import org.jetbrains.vuejs.web.symbols.VueScopeElementSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/vuejs/web/symbols/VueDirectiveSymbolBase;", "T", "Lorg/jetbrains/vuejs/model/VueDirective;", "Lorg/jetbrains/vuejs/web/symbols/VueScopeElementSymbol;", "name", "", "directive", "<init>", "(Ljava/lang/String;Lorg/jetbrains/vuejs/model/VueDirective;)V", "vueProximity", "Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "getVueProximity", "()Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "priority", "Lcom/intellij/polySymbols/PolySymbol$Priority;", "getPriority", "()Lcom/intellij/polySymbols/PolySymbol$Priority;", "isEquivalentTo", "", "symbol", "Lcom/intellij/model/Symbol;", "getSymbols", "", "Lcom/intellij/polySymbols/PolySymbol;", "qualifiedKind", "Lcom/intellij/polySymbols/PolySymbolQualifiedKind;", "params", "Lcom/intellij/polySymbols/query/PolySymbolListSymbolsQueryParams;", "stack", "Lcom/intellij/polySymbols/query/PolySymbolQueryStack;", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueDirectiveSymbolBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueDirectiveSymbolBase.kt\norg/jetbrains/vuejs/web/symbols/VueDirectiveSymbolBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1563#2:58\n1634#2,3:59\n*S KotlinDebug\n*F\n+ 1 VueDirectiveSymbolBase.kt\norg/jetbrains/vuejs/web/symbols/VueDirectiveSymbolBase\n*L\n47#1:58\n47#1:59,3\n*E\n"})
public abstract class VueDirectiveSymbolBase<T extends VueDirective>
extends VueScopeElementSymbol<T> {
    public VueDirectiveSymbolBase(@NotNull String name, @NotNull T directive) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(directive, (String)"directive");
        super(name, (VueScopeElement)directive);
    }

    @NotNull
    protected abstract VueModelVisitor.Proximity getVueProximity();

    @NotNull
    public final PolySymbol.Priority getPriority() {
        return PolySymbolsUtilsKt.asPolySymbolPriority(this.getVueProximity());
    }

    @Override
    public final boolean isEquivalentTo(@NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        PsiElement target = PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        if (target != null && target.getManager().areElementsEquivalent(target, this.getRawSource())) {
            return true;
        }
        return super.isEquivalentTo(symbol);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PolySymbol> getSymbols(@NotNull PolySymbolQualifiedKind qualifiedKind, @NotNull PolySymbolListSymbolsQueryParams params, @NotNull PolySymbolQueryStack stack) {
        List list;
        Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        PolySymbolQualifiedKind polySymbolQualifiedKind = qualifiedKind;
        if (Intrinsics.areEqual((Object)polySymbolQualifiedKind, (Object)VueSymbolQueryConfiguratorKt.getVUE_DIRECTIVE_ARGUMENT()) && !params.getExpandPatterns()) {
            list = CollectionsKt.listOf((Object)new VueAnySymbol(this.getOrigin(), qualifiedKind, "Vue directive argument", null, 8, null));
        } else if (Intrinsics.areEqual((Object)polySymbolQualifiedKind, (Object)VueSymbolQueryConfiguratorKt.getVUE_DIRECTIVE_MODIFIERS())) {
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((VueDirective)this.getItem()).getModifiers();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void modifier;
                VueDirectiveModifier vueDirectiveModifier = (VueDirectiveModifier)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new VueDirectiveModifierSymbol((VueDirectiveModifier)modifier, this.getVueProximity()));
            }
            Collection collection3 = (List)destination$iv$iv;
            if (collection3.isEmpty()) {
                boolean bl = false;
                collection = CollectionsKt.listOf((Object)new VueAnySymbol(this.getOrigin(), qualifiedKind, "Vue directive modifier", null, 8, null));
            } else {
                collection = collection3;
            }
            list = (List)collection;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

