/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 81179393401136L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(216527640 + 10797, -216527640 + -26265, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(216527640 + 10796, 216527640 + 16633, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 90050964996755L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.G();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1614258120 + -24916, 1614258120 + (char)-21309, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1614258120 + -24915, 1614258120 + (char)-23010, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1614258120 + -24918, -1614258120 + -((char)-8855), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                int[] nArray;
                l2 = 19467740640112L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.G();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1346088900 + -((char)-32452), 1346088900 + 22649, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1346088900 + -((char)-32455), -1346088900 + -21313, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1346088900 + -((char)-32454), -1346088900 + -((char)-18353), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1346088900 + -((char)-32465), -1346088900 + -31644, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1346088900 + -((char)-32464), 1346088900 + (char)-13260, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1346088900 + -((char)-32467), 1346088900 + 27185, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1346088900 + -((char)-32465), -1346088900 + -31644, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1346088900 + -((char)-32466), 1346088900 + (char)-28252, (int)l2));
            if (ActionTimestamp.G() != null) {
                SshAgentIpcService.G(new int[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 77783441294545L;
                    nArray = SshAgentIpcService.G();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 98196995514108L;
                int[] nArray2 = SshAgentIpcService.G();
                this.assertConnectionThread();
                Object object3 = this.lock;
                nArray = nArray2;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26511, -1158265590 - -29155, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26507, 1158265590 - (char)-32310, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26510, -1158265590 - -18269, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26507, 1158265590 - (char)-32310, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26513, 1158265590 - 23164, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26511, -1158265590 - -29155, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26507, 1158265590 - (char)-32310, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26512, 1158265590 - 17854, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26511, -1158265590 - -29155, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26507, 1158265590 - (char)-32310, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26531, 1158265590 - (char)-29472, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26507, 1158265590 - (char)-32310, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26530, 1158265590 - 31328, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26507, 1158265590 - (char)-32310, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26513, 1158265590 - 23164, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26511, -1158265590 - -29155, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26507, 1158265590 - (char)-32310, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1158265590 - (char)-26533, 1158265590 - (char)-25098, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 52649996781192L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(2007337050 - (char)-2600, 2007337050 - (char)-17978, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 106394963020349L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-33160710 + -25540, -33160710 + -3200, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u000b\u00ba\u0086hhX\u00ca\u0014\u00e4?h7\u0015S\u00d2\u00b1jL\u00c0\u0014-\u0080B)\u00eb\u00b2\u00c7\u00cc\u00c7\"\u00c9@\u00e3D\u00cd\u00d8d\u00a7\u0006s";
                        var4_3 = "\u000b\u00ba\u0086hhX\u00ca\u0014\u00e4?h7\u0015S\u00d2\u00b1jL\u00c0\u0014-\u0080B)\u00eb\u00b2\u00c7\u00cc\u00c7\"\u00c9@\u00e3D\u00cd\u00d8d\u00a7\u0006s".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 64;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 24;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 118;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 120;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 57;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 8;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 42;
                                        break;
                                    }
                                    default: {
                                        v11 = 88;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFF940A) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 170;
                            case 1 -> 85;
                            case 2 -> 245;
                            case 3 -> 152;
                            case 4 -> 145;
                            case 5 -> 195;
                            case 6 -> 169;
                            case 7 -> 176;
                            case 8 -> 10;
                            case 9 -> 186;
                            case 10 -> 120;
                            case 11 -> 233;
                            case 12 -> 97;
                            case 13 -> 59;
                            case 14 -> 251;
                            case 15 -> 18;
                            case 16 -> 118;
                            case 17 -> 129;
                            case 18 -> 140;
                            case 19 -> 182;
                            case 20 -> 8;
                            case 21 -> 98;
                            case 22 -> 24;
                            case 23 -> 32;
                            case 24 -> 128;
                            case 25 -> 124;
                            case 26 -> 0;
                            case 27 -> 184;
                            case 28 -> 50;
                            case 29 -> 86;
                            case 30 -> 65;
                            case 31 -> 137;
                            case 32 -> 177;
                            case 33 -> 49;
                            case 34 -> 5;
                            case 35 -> 198;
                            case 36 -> 114;
                            case 37 -> 247;
                            case 38 -> 231;
                            case 39 -> 168;
                            case 40 -> 174;
                            case 41 -> 151;
                            case 42 -> 87;
                            case 43 -> 160;
                            case 44 -> 154;
                            case 45 -> 3;
                            case 46 -> 82;
                            case 47 -> 243;
                            case 48 -> 47;
                            case 49 -> 150;
                            case 50 -> 183;
                            case 51 -> 158;
                            case 52 -> 66;
                            case 53 -> 95;
                            case 54 -> 214;
                            case 55 -> 7;
                            case 56 -> 53;
                            case 57 -> 39;
                            case 58 -> 34;
                            case 59 -> 207;
                            case 60 -> 217;
                            case 61 -> 196;
                            case 62 -> 190;
                            case 63 -> 212;
                            case 64 -> 131;
                            case 65 -> 60;
                            case 66 -> 239;
                            case 67 -> 240;
                            case 68 -> 179;
                            case 69 -> 236;
                            case 70 -> 103;
                            case 71 -> 218;
                            case 72 -> 194;
                            case 73 -> 147;
                            case 74 -> 213;
                            case 75 -> 192;
                            case 76 -> 222;
                            case 77 -> 91;
                            case 78 -> 225;
                            case 79 -> 35;
                            case 80 -> 241;
                            case 81 -> 180;
                            case 82 -> 157;
                            case 83 -> 223;
                            case 84 -> 62;
                            case 85 -> 215;
                            case 86 -> 79;
                            case 87 -> 84;
                            case 88 -> 121;
                            case 89 -> 232;
                            case 90 -> 254;
                            case 91 -> 83;
                            case 92 -> 15;
                            case 93 -> 203;
                            case 94 -> 216;
                            case 95 -> 139;
                            case 96 -> 126;
                            case 97 -> 135;
                            case 98 -> 27;
                            case 99 -> 133;
                            case 100 -> 101;
                            case 101 -> 199;
                            case 102 -> 148;
                            case 103 -> 11;
                            case 104 -> 16;
                            case 105 -> 255;
                            case 106 -> 94;
                            case 107 -> 25;
                            case 108 -> 36;
                            case 109 -> 159;
                            case 110 -> 102;
                            case 111 -> 220;
                            case 112 -> 54;
                            case 113 -> 22;
                            case 114 -> 111;
                            case 115 -> 64;
                            case 116 -> 56;
                            case 117 -> 44;
                            case 118 -> 134;
                            case 119 -> 248;
                            case 120 -> 33;
                            case 121 -> 237;
                            case 122 -> 228;
                            case 123 -> 210;
                            case 124 -> 43;
                            case 125 -> 156;
                            case 126 -> 175;
                            case 127 -> 19;
                            case 128 -> 29;
                            case 129 -> 74;
                            case 130 -> 69;
                            case 131 -> 70;
                            case 132 -> 96;
                            case 133 -> 46;
                            case 134 -> 1;
                            case 135 -> 100;
                            case 136 -> 141;
                            case 137 -> 200;
                            case 138 -> 26;
                            case 139 -> 104;
                            case 140 -> 197;
                            case 141 -> 171;
                            case 142 -> 122;
                            case 143 -> 40;
                            case 144 -> 107;
                            case 145 -> 109;
                            case 146 -> 71;
                            case 147 -> 31;
                            case 148 -> 48;
                            case 149 -> 167;
                            case 150 -> 138;
                            case 151 -> 90;
                            case 152 -> 42;
                            case 153 -> 93;
                            case 154 -> 57;
                            case 155 -> 246;
                            case 156 -> 88;
                            case 157 -> 41;
                            case 158 -> 178;
                            case 159 -> 51;
                            case 160 -> 202;
                            case 161 -> 166;
                            case 162 -> 76;
                            case 163 -> 230;
                            case 164 -> 81;
                            case 165 -> 253;
                            case 166 -> 52;
                            case 167 -> 161;
                            case 168 -> 13;
                            case 169 -> 208;
                            case 170 -> 221;
                            case 171 -> 219;
                            case 172 -> 61;
                            case 173 -> 204;
                            case 174 -> 113;
                            case 175 -> 75;
                            case 176 -> 211;
                            case 177 -> 72;
                            case 178 -> 173;
                            case 179 -> 23;
                            case 180 -> 205;
                            case 181 -> 209;
                            case 182 -> 181;
                            case 183 -> 17;
                            case 184 -> 172;
                            case 185 -> 67;
                            case 186 -> 108;
                            case 187 -> 125;
                            case 188 -> 105;
                            case 189 -> 187;
                            case 190 -> 112;
                            case 191 -> 224;
                            case 192 -> 189;
                            case 193 -> 127;
                            case 194 -> 227;
                            case 195 -> 193;
                            case 196 -> 238;
                            case 197 -> 89;
                            case 198 -> 58;
                            case 199 -> 30;
                            case 200 -> 73;
                            case 201 -> 162;
                            case 202 -> 77;
                            case 203 -> 249;
                            case 204 -> 142;
                            case 205 -> 250;
                            case 206 -> 185;
                            case 207 -> 201;
                            case 208 -> 165;
                            case 209 -> 130;
                            case 210 -> 119;
                            case 211 -> 163;
                            case 212 -> 116;
                            case 213 -> 92;
                            case 214 -> 110;
                            case 215 -> 242;
                            case 216 -> 37;
                            case 217 -> 115;
                            case 218 -> 155;
                            case 219 -> 63;
                            case 220 -> 68;
                            case 221 -> 144;
                            case 222 -> 38;
                            case 223 -> 106;
                            case 224 -> 78;
                            case 225 -> 123;
                            case 226 -> 4;
                            case 227 -> 55;
                            case 228 -> 146;
                            case 229 -> 164;
                            case 230 -> 20;
                            case 231 -> 143;
                            case 232 -> 117;
                            case 233 -> 45;
                            case 234 -> 229;
                            case 235 -> 2;
                            case 236 -> 191;
                            case 237 -> 244;
                            case 238 -> 188;
                            case 239 -> 206;
                            case 240 -> 21;
                            case 241 -> 149;
                            case 242 -> 14;
                            case 243 -> 132;
                            case 244 -> 9;
                            case 245 -> 80;
                            case 246 -> 235;
                            case 247 -> 6;
                            case 248 -> 226;
                            case 249 -> 136;
                            case 250 -> 28;
                            case 251 -> 12;
                            case 252 -> 252;
                            case 253 -> 99;
                            case 254 -> 153;
                            default -> 234;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray != null) {
                ActionTimestamp.G("tG8ygb");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 86070282964210L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.G();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-861654180 - -15663, 861654180 + 6207, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-861654180 - -15667, -861654180 - -14278, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-861654180 - -15672, 861654180 + 5008, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-861654180 - -15663, 861654180 + 6207, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-861654180 - -15667, -861654180 - -14278, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-861654180 - -15671, -861654180 - -1762, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 471941027439L;
                        int[] nArray2 = SshAgentIpcService.G();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-505405920 - -((char)-29713), -505405920 - -((char)-30351), (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-505405920 - -((char)-29716), 505405920 - 30543, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 41215955383968L;
                int[] nArray2 = SshAgentIpcService.G();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24891, -1449240990 - -18511, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24895, 1449240990 - (char)-26578, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24868, -1449240990 - -13051, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24895, 1449240990 - (char)-26578, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24893, 1449240990 - 24952, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24891, -1449240990 - -18511, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24895, 1449240990 - (char)-26578, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24879, -1449240990 - -25144, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24891, -1449240990 - -18511, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24895, 1449240990 - (char)-26578, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24878, -1449240990 - -17965, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24891, -1449240990 - -18511, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24895, 1449240990 - (char)-26578, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1449240990 - (char)-24881, -1449240990 - -((char)-22967), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 90240438209239L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.G();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29682), 1119599940 + 25986, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29678), -1119599940 + -((char)-27211), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29693), -1119599940 + -26135, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29698), 1119599940 + (char)-17862, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29682), 1119599940 + 25986, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29678), -1119599940 + -((char)-27211), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29699), -1119599940 + -32010, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29682), 1119599940 + 25986, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29678), -1119599940 + -((char)-27211), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29696), 1119599940 + (char)-32703, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29682), 1119599940 + 25986, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29678), -1119599940 + -((char)-27211), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29697), 1119599940 + (char)-17256, (int)l2));
                    if (nArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29682), 1119599940 + 25986, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29678), -1119599940 + -((char)-27211), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29638), 1119599940 + 18822, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1119599940 + -((char)-29639), 1119599940 + 19847, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "O\u0002\u001bv\u0089\u00d3L\u00ea\u0014I\u001e\u00e3\u0012h\u00d7\u00dfp\u009f\u0007\u00eb\t\u0003\u00fbO$\u00e0C\u00e4]\u0006\u0003\u00c8\u0092/\u00d2\u00b9\u0018\u008ew{\u000f\u00f9\u00b1\u00ef|Q\u00fb=\u00e6\u00bf\u00f9\u008a\u00e6\u00f1r\u00e8\u00e6\u00f3\u0003\u0000h\t\u0003wT\u00bew\u0018&\u0001T\u0005wl\u001c\u00bb\u0019\b)\u00f3\u00d79B\u001c3\u00f1\u0014^zy\u0005V=-\u00ba\u00af\u0083F-\u00fc\u00dc\u000b-z\u00b1NA\u0005\u00c5)J\u0013\u00d3\u001e\u00e6\u00a0;F`\\~\u00bb\u00c6\u0017\u0084\u00fc\u00c4\u009aG\u00ee\u00a9\u00e21\u0000d\u00f0\u00fe\u00db\u009078\u00e6\u00fc\u0083\u0010\u001a\u00ef@jX\u00eb\u008f\u00b4\u0085Dak~=\u00bf\u0085\t\u00bb[\u0095*\u001c\u00adm(\u00d3\u0010\u0094#\u0091\u00f3b\u00d8\u00c8\u00d2m\u0088|\u00f2\u00dd\u000e\u00cb\u00e3?\u00f9\u00b6\u00d0\u0084\u0010\r\u00f5\u00fd\u00c6\u000e\u00c1$\u00d3w\u0098j\u0097\u0017\u008b{\u00bd\u00cd\u00be\u001a\u0088\u00e76H\n\u0000:A!\u00c2?\u008d\u0095\u00a6\u00d63\u00e0\u009ecv\u00f1\u00fa6=7\u0089A\u00e3U\u00c7\u00a2\u00fb;\u0007\u00cb\u008b3\u00ec\u00f2\b\u00c5\u00bbJ0\u00f1=E\u00d5\fz\u00e7\u00ad\u00a0\u0010M\u0097\u00dc\u00af\u0001v\u00c7F5\u00b5D\u00ea-\u00040\u00f5[(\u00e2&!?\u00d9EC\u0095\u0011\u0084\u00fc`\u0095\u009d\u00db<\u00af8\u0086'\u0091\u0099ho\u00d4\u00192y\u0089\f\u0098l\u00e7\u00d3\u00bf\u00cb\u00abfc\u001a\u00ad;'J\u00faQ\u00af&\u00cf\u0013\u0080\u0096\u00d8\u008d\u00d3\u00e9\u00f4x\u0001}\u001f\u0007u\u0007\u00fc\u00e7\u000b\u008eQ\u00d8JGW\u00bc\u00f2CRR\u009d3%\u00ef\u00d4X\u00f4%\u0002\u0099\u008c\u00d5?\u00f9\u000b6{$3!?\u00b1\u0092k\u00c4\u00e4\u0015<\u001ce\u00dc\u000e\u00aa\u00b8]t\u00dd\u00cfn\u0013y\u00abu\u00b4\u00ed2R\u00f9){\u00eb\u0088/\u0016q\u00b0\u001e\u001f\u00a3\u00bfj\u00a7_\u00be\u00e2\u00b2\u0003\u00f4Q\u00e7\"\u009f2\u00b2\u0093\u00bc\u00c6^\u0082\n\u0013\u00e5\u009b\u0003\n\u00d6\u0006\u009eJ\u00d9\u0007\r&L\u008c\u00aaX\u00bc\u0007\u00ec\u00ce\u0014\u00fdF\u00997(\u0090\u00db\u00b9\b\u0080\u00ff\u0094\u00e8\u00eb\u00aa\u000b}\u0012<J\r+Si\u001855\u00aa\u001b\u0084\n\u00cc\u008eg\u00eb\u00f6'\u0081v\u0011\u001a.y\u0012V\u000f\u00b5\u0007S\u00ba5\u00c5\u0087l\u00fc\u00b7H\u008f\u00da6\u00cd\"\u00b9z\u00d0\u001d\u001d7\u00d1\u00d63\u00ba:I\u00147\u00ac!\u001bRK9\u00fa/\u009c\u00c3A\u00f9\u000fU\f\u00c2\u00e2\u001c\u00d6\u0089\u000e\u0004=e\u00fd\u00f3-_q\u00e7\u0014+\u00fb\u00ba\u00b2\u001bX\u0002\u00e9\u001f\u0099\u00c4\u0087\u0010\u00ab\u00bf/\u008fj\nE\u0090\u008e\u00ceD6 \u00fa\u00b4\u00df\u000f\u0017\u0093\nM\u00b1\u008fnA\u000eOc\u0019\u00b3\u0018\u00e8T\u00ff\u00d8Z\u0080\u00de\u00c6\u009e\u00acKr_\u00e6\u001f,\u00b2X\u0014\u009dR\u00c4\u00a1K)hS\u00ea8Z\u00939B.(\u0099\u001bgx9}<\u0085\u00faD\u001c\u0090\u00a9h\u0001JW\u0011p$tV\u000f\u00ed\u008bP\u0019ig\u00a7\u00e6\t\u0004jb\u0012\u00e8e\u00a5jw";
                var4_3 = "O\u0002\u001bv\u0089\u00d3L\u00ea\u0014I\u001e\u00e3\u0012h\u00d7\u00dfp\u009f\u0007\u00eb\t\u0003\u00fbO$\u00e0C\u00e4]\u0006\u0003\u00c8\u0092/\u00d2\u00b9\u0018\u008ew{\u000f\u00f9\u00b1\u00ef|Q\u00fb=\u00e6\u00bf\u00f9\u008a\u00e6\u00f1r\u00e8\u00e6\u00f3\u0003\u0000h\t\u0003wT\u00bew\u0018&\u0001T\u0005wl\u001c\u00bb\u0019\b)\u00f3\u00d79B\u001c3\u00f1\u0014^zy\u0005V=-\u00ba\u00af\u0083F-\u00fc\u00dc\u000b-z\u00b1NA\u0005\u00c5)J\u0013\u00d3\u001e\u00e6\u00a0;F`\\~\u00bb\u00c6\u0017\u0084\u00fc\u00c4\u009aG\u00ee\u00a9\u00e21\u0000d\u00f0\u00fe\u00db\u009078\u00e6\u00fc\u0083\u0010\u001a\u00ef@jX\u00eb\u008f\u00b4\u0085Dak~=\u00bf\u0085\t\u00bb[\u0095*\u001c\u00adm(\u00d3\u0010\u0094#\u0091\u00f3b\u00d8\u00c8\u00d2m\u0088|\u00f2\u00dd\u000e\u00cb\u00e3?\u00f9\u00b6\u00d0\u0084\u0010\r\u00f5\u00fd\u00c6\u000e\u00c1$\u00d3w\u0098j\u0097\u0017\u008b{\u00bd\u00cd\u00be\u001a\u0088\u00e76H\n\u0000:A!\u00c2?\u008d\u0095\u00a6\u00d63\u00e0\u009ecv\u00f1\u00fa6=7\u0089A\u00e3U\u00c7\u00a2\u00fb;\u0007\u00cb\u008b3\u00ec\u00f2\b\u00c5\u00bbJ0\u00f1=E\u00d5\fz\u00e7\u00ad\u00a0\u0010M\u0097\u00dc\u00af\u0001v\u00c7F5\u00b5D\u00ea-\u00040\u00f5[(\u00e2&!?\u00d9EC\u0095\u0011\u0084\u00fc`\u0095\u009d\u00db<\u00af8\u0086'\u0091\u0099ho\u00d4\u00192y\u0089\f\u0098l\u00e7\u00d3\u00bf\u00cb\u00abfc\u001a\u00ad;'J\u00faQ\u00af&\u00cf\u0013\u0080\u0096\u00d8\u008d\u00d3\u00e9\u00f4x\u0001}\u001f\u0007u\u0007\u00fc\u00e7\u000b\u008eQ\u00d8JGW\u00bc\u00f2CRR\u009d3%\u00ef\u00d4X\u00f4%\u0002\u0099\u008c\u00d5?\u00f9\u000b6{$3!?\u00b1\u0092k\u00c4\u00e4\u0015<\u001ce\u00dc\u000e\u00aa\u00b8]t\u00dd\u00cfn\u0013y\u00abu\u00b4\u00ed2R\u00f9){\u00eb\u0088/\u0016q\u00b0\u001e\u001f\u00a3\u00bfj\u00a7_\u00be\u00e2\u00b2\u0003\u00f4Q\u00e7\"\u009f2\u00b2\u0093\u00bc\u00c6^\u0082\n\u0013\u00e5\u009b\u0003\n\u00d6\u0006\u009eJ\u00d9\u0007\r&L\u008c\u00aaX\u00bc\u0007\u00ec\u00ce\u0014\u00fdF\u00997(\u0090\u00db\u00b9\b\u0080\u00ff\u0094\u00e8\u00eb\u00aa\u000b}\u0012<J\r+Si\u001855\u00aa\u001b\u0084\n\u00cc\u008eg\u00eb\u00f6'\u0081v\u0011\u001a.y\u0012V\u000f\u00b5\u0007S\u00ba5\u00c5\u0087l\u00fc\u00b7H\u008f\u00da6\u00cd\"\u00b9z\u00d0\u001d\u001d7\u00d1\u00d63\u00ba:I\u00147\u00ac!\u001bRK9\u00fa/\u009c\u00c3A\u00f9\u000fU\f\u00c2\u00e2\u001c\u00d6\u0089\u000e\u0004=e\u00fd\u00f3-_q\u00e7\u0014+\u00fb\u00ba\u00b2\u001bX\u0002\u00e9\u001f\u0099\u00c4\u0087\u0010\u00ab\u00bf/\u008fj\nE\u0090\u008e\u00ceD6 \u00fa\u00b4\u00df\u000f\u0017\u0093\nM\u00b1\u008fnA\u000eOc\u0019\u00b3\u0018\u00e8T\u00ff\u00d8Z\u0080\u00de\u00c6\u009e\u00acKr_\u00e6\u001f,\u00b2X\u0014\u009dR\u00c4\u00a1K)hS\u00ea8Z\u00939B.(\u0099\u001bgx9}<\u0085\u00faD\u001c\u0090\u00a9h\u0001JW\u0011p$tV\u000f\u00ed\u008bP\u0019ig\u00a7\u00e6\t\u0004jb\u0012\u00e8e\u00a5jw".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 53;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0013\u00ca\u0007\u0089e'\\V\u0000(\u00de\u0099\r\u00aa\u00f6\u00a5G\u0010G\u00f0|\u00bb\u00d4Q\u0087\u00f3\u0094\u00e1\u001a\u0014\u00d70\u00b2U\u00c0\u00bdH\u00bf\u00ef|g\u00e4\u0010\u00c4\u00afA~m\u00b5\u001a";
                    var4_3 = "\u0013\u00ca\u0007\u0089e'\\V\u0000(\u00de\u0099\r\u00aa\u00f6\u00a5G\u0010G\u00f0|\u00bb\u00d4Q\u0087\u00f3\u0094\u00e1\u001a\u0014\u00d70\u00b2U\u00c0\u00bdH\u00bf\u00ef|g\u00e4\u0010\u00c4\u00afA~m\u00b5\u001a".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 90;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 107;
                            break;
                        }
                        case 1: {
                            v15 = 55;
                            break;
                        }
                        case 2: {
                            v15 = 2;
                            break;
                        }
                        case 3: {
                            v15 = 98;
                            break;
                        }
                        case 4: {
                            v15 = 23;
                            break;
                        }
                        case 5: {
                            v15 = 106;
                            break;
                        }
                        default: {
                            v15 = 34;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x3C75) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 90;
                case 1 -> 86;
                case 2 -> 227;
                case 3 -> 185;
                case 4 -> 228;
                case 5 -> 231;
                case 6 -> 54;
                case 7 -> 1;
                case 8 -> 19;
                case 9 -> 147;
                case 10 -> 222;
                case 11 -> 16;
                case 12 -> 28;
                case 13 -> 251;
                case 14 -> 148;
                case 15 -> 4;
                case 16 -> 248;
                case 17 -> 30;
                case 18 -> 95;
                case 19 -> 106;
                case 20 -> 199;
                case 21 -> 203;
                case 22 -> 240;
                case 23 -> 195;
                case 24 -> 46;
                case 25 -> 204;
                case 26 -> 31;
                case 27 -> 163;
                case 28 -> 208;
                case 29 -> 154;
                case 30 -> 209;
                case 31 -> 246;
                case 32 -> 221;
                case 33 -> 202;
                case 34 -> 5;
                case 35 -> 12;
                case 36 -> 166;
                case 37 -> 173;
                case 38 -> 85;
                case 39 -> 65;
                case 40 -> 73;
                case 41 -> 244;
                case 42 -> 112;
                case 43 -> 193;
                case 44 -> 42;
                case 45 -> 243;
                case 46 -> 53;
                case 47 -> 155;
                case 48 -> 120;
                case 49 -> 175;
                case 50 -> 71;
                case 51 -> 116;
                case 52 -> 88;
                case 53 -> 113;
                case 54 -> 70;
                case 55 -> 32;
                case 56 -> 87;
                case 57 -> 172;
                case 58 -> 198;
                case 59 -> 80;
                case 60 -> 206;
                case 61 -> 75;
                case 62 -> 255;
                case 63 -> 11;
                case 64 -> 89;
                case 65 -> 21;
                case 66 -> 220;
                case 67 -> 158;
                case 68 -> 98;
                case 69 -> 194;
                case 70 -> 181;
                case 71 -> 79;
                case 72 -> 252;
                case 73 -> 66;
                case 74 -> 143;
                case 75 -> 210;
                case 76 -> 137;
                case 77 -> 104;
                case 78 -> 245;
                case 79 -> 51;
                case 80 -> 129;
                case 81 -> 2;
                case 82 -> 190;
                case 83 -> 219;
                case 84 -> 130;
                case 85 -> 52;
                case 86 -> 24;
                case 87 -> 83;
                case 88 -> 234;
                case 89 -> 7;
                case 90 -> 171;
                case 91 -> 192;
                case 92 -> 157;
                case 93 -> 235;
                case 94 -> 92;
                case 95 -> 187;
                case 96 -> 17;
                case 97 -> 107;
                case 98 -> 110;
                case 99 -> 177;
                case 100 -> 36;
                case 101 -> 99;
                case 102 -> 249;
                case 103 -> 168;
                case 104 -> 170;
                case 105 -> 242;
                case 106 -> 179;
                case 107 -> 153;
                case 108 -> 241;
                case 109 -> 186;
                case 110 -> 141;
                case 111 -> 131;
                case 112 -> 45;
                case 113 -> 127;
                case 114 -> 236;
                case 115 -> 211;
                case 116 -> 97;
                case 117 -> 134;
                case 118 -> 27;
                case 119 -> 62;
                case 120 -> 76;
                case 121 -> 196;
                case 122 -> 38;
                case 123 -> 43;
                case 124 -> 101;
                case 125 -> 142;
                case 126 -> 151;
                case 127 -> 169;
                case 128 -> 115;
                case 129 -> 55;
                case 130 -> 96;
                case 131 -> 77;
                case 132 -> 156;
                case 133 -> 74;
                case 134 -> 114;
                case 135 -> 140;
                case 136 -> 118;
                case 137 -> 14;
                case 138 -> 20;
                case 139 -> 183;
                case 140 -> 63;
                case 141 -> 139;
                case 142 -> 125;
                case 143 -> 189;
                case 144 -> 212;
                case 145 -> 59;
                case 146 -> 124;
                case 147 -> 197;
                case 148 -> 56;
                case 149 -> 111;
                case 150 -> 188;
                case 151 -> 123;
                case 152 -> 149;
                case 153 -> 218;
                case 154 -> 214;
                case 155 -> 229;
                case 156 -> 223;
                case 157 -> 191;
                case 158 -> 60;
                case 159 -> 182;
                case 160 -> 8;
                case 161 -> 226;
                case 162 -> 238;
                case 163 -> 49;
                case 164 -> 184;
                case 165 -> 93;
                case 166 -> 138;
                case 167 -> 254;
                case 168 -> 250;
                case 169 -> 225;
                case 170 -> 29;
                case 171 -> 40;
                case 172 -> 33;
                case 173 -> 22;
                case 174 -> 180;
                case 175 -> 9;
                case 176 -> 216;
                case 177 -> 224;
                case 178 -> 61;
                case 179 -> 41;
                case 180 -> 253;
                case 181 -> 67;
                case 182 -> 217;
                case 183 -> 23;
                case 184 -> 6;
                case 185 -> 58;
                case 186 -> 18;
                case 187 -> 117;
                case 188 -> 72;
                case 189 -> 145;
                case 190 -> 178;
                case 191 -> 205;
                case 192 -> 150;
                case 193 -> 102;
                case 194 -> 119;
                case 195 -> 200;
                case 196 -> 84;
                case 197 -> 25;
                case 198 -> 247;
                case 199 -> 215;
                case 200 -> 160;
                case 201 -> 230;
                case 202 -> 100;
                case 203 -> 174;
                case 204 -> 78;
                case 205 -> 3;
                case 206 -> 15;
                case 207 -> 35;
                case 208 -> 133;
                case 209 -> 162;
                case 210 -> 146;
                case 211 -> 81;
                case 212 -> 68;
                case 213 -> 13;
                case 214 -> 121;
                case 215 -> 47;
                case 216 -> 26;
                case 217 -> 232;
                case 218 -> 10;
                case 219 -> 0;
                case 220 -> 132;
                case 221 -> 48;
                case 222 -> 176;
                case 223 -> 239;
                case 224 -> 164;
                case 225 -> 103;
                case 226 -> 91;
                case 227 -> 135;
                case 228 -> 233;
                case 229 -> 57;
                case 230 -> 109;
                case 231 -> 82;
                case 232 -> 122;
                case 233 -> 94;
                case 234 -> 213;
                case 235 -> 105;
                case 236 -> 39;
                case 237 -> 136;
                case 238 -> 108;
                case 239 -> 165;
                case 240 -> 152;
                case 241 -> 50;
                case 242 -> 64;
                case 243 -> 144;
                case 244 -> 159;
                case 245 -> 128;
                case 246 -> 126;
                case 247 -> 237;
                case 248 -> 37;
                case 249 -> 167;
                case 250 -> 207;
                case 251 -> 69;
                case 252 -> 34;
                case 253 -> 201;
                case 254 -> 44;
                default -> 161;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 24877385578166L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(935053380 - (char)-6768, 935053380 - (char)-4811, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 107692557078621L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.G();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(547086180 + 9466, 547086180 + 28419, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(547086180 + 9465, 547086180 + 21099, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(547086180 + 9464, 547086180 + 9903, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00f0\u0019\u00cfK\u00b1\u00c2[\u00c1\u0010j\u00e0m\u00d5_\u00aa\u007f\u0095+C\u00ea)\u00b9eN>";
                    var4_3 = "\u00f0\u0019\u00cfK\u00b1\u00c2[\u00c1\u0010j\u00e0m\u00d5_\u00aa\u007f\u0095+C\u00ea)\u00b9eN>".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 10;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "p\u00f4\u00d5\u00fc\u00885\u0099'\u00ff\u00ea\u001f~e\u00ae\u0015\u0095\u00b59\u00af\u0087\u0083\u00e2\u00c3\u009b>\u00c7\r\u00dc\u00beE\u00bd\u000b3\u00e59?\u00a4\u00b5\u00a6\\\u00d1\u001c7\u0097\u0092\u00d6d\u0017g\u0015\r)\u00f3i!\u00f6*\u0000)";
                        var4_3 = "p\u00f4\u00d5\u00fc\u00885\u0099'\u00ff\u00ea\u001f~e\u00ae\u0015\u0095\u00b59\u00af\u0087\u0083\u00e2\u00c3\u009b>\u00c7\r\u00dc\u00beE\u00bd\u000b3\u00e59?\u00a4\u00b5\u00a6\\\u00d1\u001c7\u0097\u0092\u00d6d\u0017g\u0015\r)\u00f3i!\u00f6*\u0000)".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 72;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 127;
                                break;
                            }
                            case 1: {
                                v15 = 19;
                                break;
                            }
                            case 2: {
                                v15 = 123;
                                break;
                            }
                            case 3: {
                                v15 = 96;
                                break;
                            }
                            case 4: {
                                v15 = 66;
                                break;
                            }
                            case 5: {
                                v15 = 68;
                                break;
                            }
                            default: {
                                v15 = 64;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x1402) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 175;
                    case 1 -> 22;
                    case 2 -> 2;
                    case 3 -> 110;
                    case 4 -> 204;
                    case 5 -> 140;
                    case 6 -> 158;
                    case 7 -> 225;
                    case 8 -> 193;
                    case 9 -> 70;
                    case 10 -> 78;
                    case 11 -> 81;
                    case 12 -> 3;
                    case 13 -> 149;
                    case 14 -> 48;
                    case 15 -> 97;
                    case 16 -> 252;
                    case 17 -> 198;
                    case 18 -> 192;
                    case 19 -> 60;
                    case 20 -> 155;
                    case 21 -> 187;
                    case 22 -> 120;
                    case 23 -> 174;
                    case 24 -> 10;
                    case 25 -> 125;
                    case 26 -> 35;
                    case 27 -> 9;
                    case 28 -> 166;
                    case 29 -> 139;
                    case 30 -> 80;
                    case 31 -> 194;
                    case 32 -> 241;
                    case 33 -> 107;
                    case 34 -> 111;
                    case 35 -> 228;
                    case 36 -> 17;
                    case 37 -> 136;
                    case 38 -> 98;
                    case 39 -> 93;
                    case 40 -> 182;
                    case 41 -> 164;
                    case 42 -> 151;
                    case 43 -> 243;
                    case 44 -> 61;
                    case 45 -> 24;
                    case 46 -> 109;
                    case 47 -> 165;
                    case 48 -> 230;
                    case 49 -> 176;
                    case 50 -> 205;
                    case 51 -> 83;
                    case 52 -> 5;
                    case 53 -> 200;
                    case 54 -> 195;
                    case 55 -> 54;
                    case 56 -> 161;
                    case 57 -> 43;
                    case 58 -> 231;
                    case 59 -> 190;
                    case 60 -> 222;
                    case 61 -> 253;
                    case 62 -> 108;
                    case 63 -> 31;
                    case 64 -> 8;
                    case 65 -> 49;
                    case 66 -> 77;
                    case 67 -> 191;
                    case 68 -> 199;
                    case 69 -> 227;
                    case 70 -> 249;
                    case 71 -> 91;
                    case 72 -> 126;
                    case 73 -> 63;
                    case 74 -> 217;
                    case 75 -> 65;
                    case 76 -> 103;
                    case 77 -> 203;
                    case 78 -> 154;
                    case 79 -> 67;
                    case 80 -> 15;
                    case 81 -> 30;
                    case 82 -> 42;
                    case 83 -> 11;
                    case 84 -> 157;
                    case 85 -> 1;
                    case 86 -> 50;
                    case 87 -> 169;
                    case 88 -> 251;
                    case 89 -> 179;
                    case 90 -> 238;
                    case 91 -> 142;
                    case 92 -> 153;
                    case 93 -> 37;
                    case 94 -> 105;
                    case 95 -> 68;
                    case 96 -> 118;
                    case 97 -> 183;
                    case 98 -> 188;
                    case 99 -> 129;
                    case 100 -> 20;
                    case 101 -> 185;
                    case 102 -> 184;
                    case 103 -> 148;
                    case 104 -> 152;
                    case 105 -> 58;
                    case 106 -> 56;
                    case 107 -> 23;
                    case 108 -> 53;
                    case 109 -> 240;
                    case 110 -> 247;
                    case 111 -> 127;
                    case 112 -> 177;
                    case 113 -> 72;
                    case 114 -> 7;
                    case 115 -> 95;
                    case 116 -> 162;
                    case 117 -> 209;
                    case 118 -> 59;
                    case 119 -> 178;
                    case 120 -> 82;
                    case 121 -> 21;
                    case 122 -> 66;
                    case 123 -> 76;
                    case 124 -> 233;
                    case 125 -> 219;
                    case 126 -> 64;
                    case 127 -> 180;
                    case 128 -> 57;
                    case 129 -> 106;
                    case 130 -> 172;
                    case 131 -> 201;
                    case 132 -> 90;
                    case 133 -> 196;
                    case 134 -> 27;
                    case 135 -> 73;
                    case 136 -> 102;
                    case 137 -> 150;
                    case 138 -> 74;
                    case 139 -> 62;
                    case 140 -> 189;
                    case 141 -> 250;
                    case 142 -> 87;
                    case 143 -> 13;
                    case 144 -> 86;
                    case 145 -> 254;
                    case 146 -> 131;
                    case 147 -> 221;
                    case 148 -> 96;
                    case 149 -> 18;
                    case 150 -> 19;
                    case 151 -> 146;
                    case 152 -> 163;
                    case 153 -> 94;
                    case 154 -> 181;
                    case 155 -> 236;
                    case 156 -> 160;
                    case 157 -> 208;
                    case 158 -> 210;
                    case 159 -> 69;
                    case 160 -> 44;
                    case 161 -> 244;
                    case 162 -> 4;
                    case 163 -> 218;
                    case 164 -> 229;
                    case 165 -> 141;
                    case 166 -> 45;
                    case 167 -> 223;
                    case 168 -> 84;
                    case 169 -> 206;
                    case 170 -> 144;
                    case 171 -> 34;
                    case 172 -> 143;
                    case 173 -> 248;
                    case 174 -> 186;
                    case 175 -> 122;
                    case 176 -> 202;
                    case 177 -> 214;
                    case 178 -> 159;
                    case 179 -> 138;
                    case 180 -> 52;
                    case 181 -> 117;
                    case 182 -> 12;
                    case 183 -> 137;
                    case 184 -> 119;
                    case 185 -> 171;
                    case 186 -> 100;
                    case 187 -> 75;
                    case 188 -> 255;
                    case 189 -> 237;
                    case 190 -> 85;
                    case 191 -> 213;
                    case 192 -> 46;
                    case 193 -> 25;
                    case 194 -> 224;
                    case 195 -> 104;
                    case 196 -> 130;
                    case 197 -> 124;
                    case 198 -> 173;
                    case 199 -> 79;
                    case 200 -> 235;
                    case 201 -> 134;
                    case 202 -> 220;
                    case 203 -> 51;
                    case 204 -> 92;
                    case 205 -> 88;
                    case 206 -> 234;
                    case 207 -> 135;
                    case 208 -> 28;
                    case 209 -> 226;
                    case 210 -> 29;
                    case 211 -> 113;
                    case 212 -> 38;
                    case 213 -> 147;
                    case 214 -> 232;
                    case 215 -> 168;
                    case 216 -> 16;
                    case 217 -> 114;
                    case 218 -> 39;
                    case 219 -> 133;
                    case 220 -> 6;
                    case 221 -> 99;
                    case 222 -> 112;
                    case 223 -> 47;
                    case 224 -> 215;
                    case 225 -> 14;
                    case 226 -> 26;
                    case 227 -> 0;
                    case 228 -> 33;
                    case 229 -> 41;
                    case 230 -> 170;
                    case 231 -> 132;
                    case 232 -> 246;
                    case 233 -> 245;
                    case 234 -> 216;
                    case 235 -> 212;
                    case 236 -> 156;
                    case 237 -> 71;
                    case 238 -> 128;
                    case 239 -> 145;
                    case 240 -> 55;
                    case 241 -> 123;
                    case 242 -> 101;
                    case 243 -> 32;
                    case 244 -> 36;
                    case 245 -> 115;
                    case 246 -> 89;
                    case 247 -> 242;
                    case 248 -> 167;
                    case 249 -> 116;
                    case 250 -> 239;
                    case 251 -> 197;
                    case 252 -> 40;
                    case 253 -> 121;
                    case 254 -> 207;
                    default -> 211;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 27712568325850L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\n\u001f$y<i\u0017S\t\r\u00157sq+\nOS";
                    var5_4 = "\n\u001f$y<i\u0017S\t\r\u00157sq+\nOS".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 19;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 114;
                                    break;
                                }
                                case 1: {
                                    v11 = 105;
                                    break;
                                }
                                case 2: {
                                    v11 = 69;
                                    break;
                                }
                                case 3: {
                                    v11 = 4;
                                    break;
                                }
                                case 4: {
                                    v11 = 74;
                                    break;
                                }
                                case 5: {
                                    v11 = 22;
                                    break;
                                }
                                default: {
                                    v11 = 55;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 74152073862597L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u001e.\u00059<R \u0004\u00180\t#\n\u0014/\u0002#0P8>.\u000b\t\u0014/\u0002#0P82$\r\u0013)\u001f.:]\"2#\u0018$;T";
                    var5_4 = "\u001e.\u00059<R \u0004\u00180\t#\n\u0014/\u0002#0P8>.\u000b\t\u0014/\u0002#0P82$\r\u0013)\u001f.:]\"2#\u0018$;T".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 40;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = ",\u0014;\u0006\u0004e\u0013\u0006,\u0014;\u0006\bo";
                        var5_4 = ",\u0014;\u0006\u0004e\u0013\u0006,\u0014;\u0006\bo".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 16;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 127;
                                break;
                            }
                            case 1: {
                                v15 = 104;
                                break;
                            }
                            case 2: {
                                v15 = 68;
                                break;
                            }
                            case 3: {
                                v15 = 101;
                                break;
                            }
                            case 4: {
                                v15 = 125;
                                break;
                            }
                            case 5: {
                                v15 = 27;
                                break;
                            }
                            default: {
                                v15 = 100;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 67929721499735L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(518775060 - 30753, 518775060 - 30242, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 105058855043964L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00bcM\u00e9\u00ab\u0016\u0003W\u0012 \u0005?g\u00bf*?\r\u00b6\u00fc\u00b8\u0013*0_S\u00ac\u0096W.?\u0010\u00c0\u00ab\u00b1\u00124\u0085\u00b7\u00d8xc.\u00dd\u00f6^\u000f\u0013\u0005\u007f9\u00b7\u00e1>3\u009c\u008e\u00da`\u008c\u008f\u0090\u008d\u00e14\u0096\u001e'w\u0019)#]\u00af\u00c27\u00d8\u00df\u00ce\u00fe\u001fo\u009e\u00ae\u00a4\u00ea?Tv\u00c0\u0090\u00af\u00c7\u0095,\u00c4\u00bd\u00c02\u000b\u001b\u00a7\u00d8\u008dR\u000f";
                    var4_3 = "\u00bcM\u00e9\u00ab\u0016\u0003W\u0012 \u0005?g\u00bf*?\r\u00b6\u00fc\u00b8\u0013*0_S\u00ac\u0096W.?\u0010\u00c0\u00ab\u00b1\u00124\u0085\u00b7\u00d8xc.\u00dd\u00f6^\u000f\u0013\u0005\u007f9\u00b7\u00e1>3\u009c\u008e\u00da`\u008c\u008f\u0090\u008d\u00e14\u0096\u001e'w\u0019)#]\u00af\u00c27\u00d8\u00df\u00ce\u00fe\u001fo\u009e\u00ae\u00a4\u00ea?Tv\u00c0\u0090\u00af\u00c7\u0095,\u00c4\u00bd\u00c02\u000b\u001b\u00a7\u00d8\u008dR\u000f".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 121;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "Ve\u00dbs\u00c1\u0011\u00b1\u00f2\u0000\u009e\u0099\u00da\u00b8\u0006~\u00a0L\u0093(\u0094\u0010\u0002\u00b5\u00a7\bKR\\\u00fa\u000e\u008c;\u0088\u00da\u0000\u00d7'\u00e8\u00b8\u00b6\u00d8H\u008e$\u00d2\u0085\u00dc\u00d8\u00e7\u00ba;\u00d4\u009d\u00a7\u0000\u0016\n:<h\u00c7\u00b3\u00c3\u00c3CK\u00ad\u0087\u00c4\u00ea\u0010s\u00fe\u001c1\u00f2<\u00ca\u00bbhD\u00f2\u00c2b\u0096\u00a3\u00fa\u00d8\u0096I\u00fc\u00a8/";
                        var4_3 = "Ve\u00dbs\u00c1\u0011\u00b1\u00f2\u0000\u009e\u0099\u00da\u00b8\u0006~\u00a0L\u0093(\u0094\u0010\u0002\u00b5\u00a7\bKR\\\u00fa\u000e\u008c;\u0088\u00da\u0000\u00d7'\u00e8\u00b8\u00b6\u00d8H\u008e$\u00d2\u0085\u00dc\u00d8\u00e7\u00ba;\u00d4\u009d\u00a7\u0000\u0016\n:<h\u00c7\u00b3\u00c3\u00c3CK\u00ad\u0087\u00c4\u00ea\u0010s\u00fe\u001c1\u00f2<\u00ca\u00bbhD\u00f2\u00c2b\u0096\u00a3\u00fa\u00d8\u0096I\u00fc\u00a8/".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 15;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 99;
                                break;
                            }
                            case 1: {
                                v15 = 111;
                                break;
                            }
                            case 2: {
                                v15 = 108;
                                break;
                            }
                            case 3: {
                                v15 = 92;
                                break;
                            }
                            case 4: {
                                v15 = 77;
                                break;
                            }
                            case 5: {
                                v15 = 9;
                                break;
                            }
                            default: {
                                v15 = 25;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x18A4) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 238;
                    case 1 -> 34;
                    case 2 -> 234;
                    case 3 -> 87;
                    case 4 -> 248;
                    case 5 -> 106;
                    case 6 -> 117;
                    case 7 -> 60;
                    case 8 -> 233;
                    case 9 -> 25;
                    case 10 -> 247;
                    case 11 -> 221;
                    case 12 -> 178;
                    case 13 -> 0;
                    case 14 -> 66;
                    case 15 -> 161;
                    case 16 -> 79;
                    case 17 -> 189;
                    case 18 -> 121;
                    case 19 -> 73;
                    case 20 -> 229;
                    case 21 -> 114;
                    case 22 -> 19;
                    case 23 -> 21;
                    case 24 -> 155;
                    case 25 -> 84;
                    case 26 -> 24;
                    case 27 -> 105;
                    case 28 -> 254;
                    case 29 -> 200;
                    case 30 -> 139;
                    case 31 -> 31;
                    case 32 -> 204;
                    case 33 -> 82;
                    case 34 -> 81;
                    case 35 -> 70;
                    case 36 -> 125;
                    case 37 -> 92;
                    case 38 -> 101;
                    case 39 -> 53;
                    case 40 -> 98;
                    case 41 -> 88;
                    case 42 -> 62;
                    case 43 -> 228;
                    case 44 -> 71;
                    case 45 -> 15;
                    case 46 -> 52;
                    case 47 -> 58;
                    case 48 -> 29;
                    case 49 -> 184;
                    case 50 -> 153;
                    case 51 -> 147;
                    case 52 -> 207;
                    case 53 -> 160;
                    case 54 -> 241;
                    case 55 -> 169;
                    case 56 -> 142;
                    case 57 -> 231;
                    case 58 -> 10;
                    case 59 -> 18;
                    case 60 -> 180;
                    case 61 -> 245;
                    case 62 -> 83;
                    case 63 -> 20;
                    case 64 -> 143;
                    case 65 -> 12;
                    case 66 -> 63;
                    case 67 -> 152;
                    case 68 -> 172;
                    case 69 -> 249;
                    case 70 -> 5;
                    case 71 -> 43;
                    case 72 -> 176;
                    case 73 -> 3;
                    case 74 -> 218;
                    case 75 -> 146;
                    case 76 -> 186;
                    case 77 -> 17;
                    case 78 -> 48;
                    case 79 -> 74;
                    case 80 -> 246;
                    case 81 -> 46;
                    case 82 -> 38;
                    case 83 -> 32;
                    case 84 -> 185;
                    case 85 -> 135;
                    case 86 -> 100;
                    case 87 -> 134;
                    case 88 -> 57;
                    case 89 -> 223;
                    case 90 -> 192;
                    case 91 -> 113;
                    case 92 -> 206;
                    case 93 -> 170;
                    case 94 -> 6;
                    case 95 -> 111;
                    case 96 -> 115;
                    case 97 -> 69;
                    case 98 -> 49;
                    case 99 -> 151;
                    case 100 -> 30;
                    case 101 -> 149;
                    case 102 -> 183;
                    case 103 -> 56;
                    case 104 -> 181;
                    case 105 -> 215;
                    case 106 -> 131;
                    case 107 -> 141;
                    case 108 -> 133;
                    case 109 -> 130;
                    case 110 -> 33;
                    case 111 -> 211;
                    case 112 -> 9;
                    case 113 -> 119;
                    case 114 -> 16;
                    case 115 -> 61;
                    case 116 -> 197;
                    case 117 -> 216;
                    case 118 -> 102;
                    case 119 -> 242;
                    case 120 -> 227;
                    case 121 -> 1;
                    case 122 -> 201;
                    case 123 -> 78;
                    case 124 -> 148;
                    case 125 -> 253;
                    case 126 -> 7;
                    case 127 -> 251;
                    case 128 -> 91;
                    case 129 -> 237;
                    case 130 -> 165;
                    case 131 -> 50;
                    case 132 -> 156;
                    case 133 -> 145;
                    case 134 -> 232;
                    case 135 -> 86;
                    case 136 -> 72;
                    case 137 -> 220;
                    case 138 -> 76;
                    case 139 -> 154;
                    case 140 -> 37;
                    case 141 -> 128;
                    case 142 -> 110;
                    case 143 -> 235;
                    case 144 -> 93;
                    case 145 -> 150;
                    case 146 -> 94;
                    case 147 -> 198;
                    case 148 -> 44;
                    case 149 -> 166;
                    case 150 -> 45;
                    case 151 -> 118;
                    case 152 -> 179;
                    case 153 -> 132;
                    case 154 -> 209;
                    case 155 -> 107;
                    case 156 -> 167;
                    case 157 -> 163;
                    case 158 -> 230;
                    case 159 -> 196;
                    case 160 -> 51;
                    case 161 -> 239;
                    case 162 -> 157;
                    case 163 -> 109;
                    case 164 -> 23;
                    case 165 -> 2;
                    case 166 -> 222;
                    case 167 -> 26;
                    case 168 -> 164;
                    case 169 -> 203;
                    case 170 -> 244;
                    case 171 -> 210;
                    case 172 -> 124;
                    case 173 -> 129;
                    case 174 -> 224;
                    case 175 -> 85;
                    case 176 -> 14;
                    case 177 -> 213;
                    case 178 -> 108;
                    case 179 -> 22;
                    case 180 -> 190;
                    case 181 -> 199;
                    case 182 -> 255;
                    case 183 -> 175;
                    case 184 -> 4;
                    case 185 -> 236;
                    case 186 -> 27;
                    case 187 -> 75;
                    case 188 -> 188;
                    case 189 -> 112;
                    case 190 -> 217;
                    case 191 -> 41;
                    case 192 -> 219;
                    case 193 -> 67;
                    case 194 -> 104;
                    case 195 -> 123;
                    case 196 -> 127;
                    case 197 -> 13;
                    case 198 -> 65;
                    case 199 -> 39;
                    case 200 -> 137;
                    case 201 -> 243;
                    case 202 -> 174;
                    case 203 -> 96;
                    case 204 -> 99;
                    case 205 -> 35;
                    case 206 -> 171;
                    case 207 -> 159;
                    case 208 -> 120;
                    case 209 -> 162;
                    case 210 -> 140;
                    case 211 -> 226;
                    case 212 -> 90;
                    case 213 -> 95;
                    case 214 -> 187;
                    case 215 -> 225;
                    case 216 -> 116;
                    case 217 -> 208;
                    case 218 -> 252;
                    case 219 -> 214;
                    case 220 -> 89;
                    case 221 -> 40;
                    case 222 -> 77;
                    case 223 -> 122;
                    case 224 -> 194;
                    case 225 -> 47;
                    case 226 -> 195;
                    case 227 -> 54;
                    case 228 -> 250;
                    case 229 -> 202;
                    case 230 -> 177;
                    case 231 -> 138;
                    case 232 -> 42;
                    case 233 -> 126;
                    case 234 -> 240;
                    case 235 -> 205;
                    case 236 -> 55;
                    case 237 -> 8;
                    case 238 -> 168;
                    case 239 -> 173;
                    case 240 -> 144;
                    case 241 -> 59;
                    case 242 -> 80;
                    case 243 -> 103;
                    case 244 -> 28;
                    case 245 -> 158;
                    case 246 -> 68;
                    case 247 -> 11;
                    case 248 -> 36;
                    case 249 -> 64;
                    case 250 -> 182;
                    case 251 -> 136;
                    case 252 -> 193;
                    case 253 -> 191;
                    case 254 -> 212;
                    default -> 97;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 40846445100576L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1306112550 + -18432, -1306112550 - -2469, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 130329868612125L;
                    int[] nArray = SshAgentIpcService.G();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(913951110 + 16480, -913951110 + -20493, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 29239467685899L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00c4g\u00d3`\u00ff\u0003^@\u00d6";
                var4_3 = "\u00c4g\u00d3`\u00ff\u0003^@\u00d6".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 1;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 75;
                                break;
                            }
                            case 1: {
                                v11 = 120;
                                break;
                            }
                            case 2: {
                                v11 = 43;
                                break;
                            }
                            case 3: {
                                v11 = 71;
                                break;
                            }
                            case 4: {
                                v11 = 124;
                                break;
                            }
                            case 5: {
                                v11 = 25;
                                break;
                            }
                            default: {
                                v11 = 60;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFBBFA) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 211;
                    case 1 -> 207;
                    case 2 -> 239;
                    case 3 -> 162;
                    case 4 -> 203;
                    case 5 -> 109;
                    case 6 -> 136;
                    case 7 -> 115;
                    case 8 -> 71;
                    case 9 -> 219;
                    case 10 -> 139;
                    case 11 -> 61;
                    case 12 -> 129;
                    case 13 -> 36;
                    case 14 -> 231;
                    case 15 -> 106;
                    case 16 -> 194;
                    case 17 -> 134;
                    case 18 -> 167;
                    case 19 -> 159;
                    case 20 -> 9;
                    case 21 -> 121;
                    case 22 -> 14;
                    case 23 -> 8;
                    case 24 -> 246;
                    case 25 -> 141;
                    case 26 -> 228;
                    case 27 -> 104;
                    case 28 -> 240;
                    case 29 -> 117;
                    case 30 -> 66;
                    case 31 -> 52;
                    case 32 -> 124;
                    case 33 -> 51;
                    case 34 -> 181;
                    case 35 -> 178;
                    case 36 -> 204;
                    case 37 -> 50;
                    case 38 -> 197;
                    case 39 -> 174;
                    case 40 -> 53;
                    case 41 -> 90;
                    case 42 -> 85;
                    case 43 -> 44;
                    case 44 -> 111;
                    case 45 -> 221;
                    case 46 -> 72;
                    case 47 -> 113;
                    case 48 -> 224;
                    case 49 -> 130;
                    case 50 -> 17;
                    case 51 -> 96;
                    case 52 -> 229;
                    case 53 -> 160;
                    case 54 -> 107;
                    case 55 -> 118;
                    case 56 -> 40;
                    case 57 -> 168;
                    case 58 -> 184;
                    case 59 -> 205;
                    case 60 -> 215;
                    case 61 -> 58;
                    case 62 -> 30;
                    case 63 -> 206;
                    case 64 -> 34;
                    case 65 -> 151;
                    case 66 -> 16;
                    case 67 -> 146;
                    case 68 -> 218;
                    case 69 -> 212;
                    case 70 -> 188;
                    case 71 -> 235;
                    case 72 -> 97;
                    case 73 -> 42;
                    case 74 -> 176;
                    case 75 -> 236;
                    case 76 -> 67;
                    case 77 -> 116;
                    case 78 -> 161;
                    case 79 -> 169;
                    case 80 -> 48;
                    case 81 -> 92;
                    case 82 -> 64;
                    case 83 -> 148;
                    case 84 -> 180;
                    case 85 -> 190;
                    case 86 -> 89;
                    case 87 -> 99;
                    case 88 -> 143;
                    case 89 -> 31;
                    case 90 -> 56;
                    case 91 -> 202;
                    case 92 -> 192;
                    case 93 -> 244;
                    case 94 -> 185;
                    case 95 -> 170;
                    case 96 -> 179;
                    case 97 -> 251;
                    case 98 -> 155;
                    case 99 -> 245;
                    case 100 -> 108;
                    case 101 -> 144;
                    case 102 -> 95;
                    case 103 -> 220;
                    case 104 -> 54;
                    case 105 -> 22;
                    case 106 -> 12;
                    case 107 -> 171;
                    case 108 -> 55;
                    case 109 -> 62;
                    case 110 -> 122;
                    case 111 -> 196;
                    case 112 -> 209;
                    case 113 -> 33;
                    case 114 -> 214;
                    case 115 -> 254;
                    case 116 -> 175;
                    case 117 -> 102;
                    case 118 -> 74;
                    case 119 -> 128;
                    case 120 -> 133;
                    case 121 -> 29;
                    case 122 -> 253;
                    case 123 -> 213;
                    case 124 -> 98;
                    case 125 -> 49;
                    case 126 -> 217;
                    case 127 -> 100;
                    case 128 -> 195;
                    case 129 -> 37;
                    case 130 -> 86;
                    case 131 -> 77;
                    case 132 -> 21;
                    case 133 -> 80;
                    case 134 -> 191;
                    case 135 -> 153;
                    case 136 -> 24;
                    case 137 -> 201;
                    case 138 -> 38;
                    case 139 -> 69;
                    case 140 -> 147;
                    case 141 -> 189;
                    case 142 -> 112;
                    case 143 -> 1;
                    case 144 -> 103;
                    case 145 -> 19;
                    case 146 -> 126;
                    case 147 -> 3;
                    case 148 -> 23;
                    case 149 -> 119;
                    case 150 -> 94;
                    case 151 -> 132;
                    case 152 -> 172;
                    case 153 -> 5;
                    case 154 -> 88;
                    case 155 -> 152;
                    case 156 -> 7;
                    case 157 -> 25;
                    case 158 -> 233;
                    case 159 -> 79;
                    case 160 -> 10;
                    case 161 -> 39;
                    case 162 -> 15;
                    case 163 -> 232;
                    case 164 -> 4;
                    case 165 -> 216;
                    case 166 -> 84;
                    case 167 -> 223;
                    case 168 -> 46;
                    case 169 -> 199;
                    case 170 -> 250;
                    case 171 -> 158;
                    case 172 -> 241;
                    case 173 -> 76;
                    case 174 -> 75;
                    case 175 -> 82;
                    case 176 -> 32;
                    case 177 -> 57;
                    case 178 -> 91;
                    case 179 -> 0;
                    case 180 -> 35;
                    case 181 -> 11;
                    case 182 -> 114;
                    case 183 -> 41;
                    case 184 -> 140;
                    case 185 -> 142;
                    case 186 -> 105;
                    case 187 -> 131;
                    case 188 -> 247;
                    case 189 -> 248;
                    case 190 -> 18;
                    case 191 -> 166;
                    case 192 -> 237;
                    case 193 -> 59;
                    case 194 -> 2;
                    case 195 -> 6;
                    case 196 -> 242;
                    case 197 -> 182;
                    case 198 -> 163;
                    case 199 -> 13;
                    case 200 -> 252;
                    case 201 -> 234;
                    case 202 -> 28;
                    case 203 -> 83;
                    case 204 -> 149;
                    case 205 -> 230;
                    case 206 -> 238;
                    case 207 -> 150;
                    case 208 -> 225;
                    case 209 -> 135;
                    case 210 -> 210;
                    case 211 -> 81;
                    case 212 -> 183;
                    case 213 -> 255;
                    case 214 -> 173;
                    case 215 -> 200;
                    case 216 -> 120;
                    case 217 -> 110;
                    case 218 -> 70;
                    case 219 -> 101;
                    case 220 -> 164;
                    case 221 -> 138;
                    case 222 -> 154;
                    case 223 -> 249;
                    case 224 -> 73;
                    case 225 -> 68;
                    case 226 -> 165;
                    case 227 -> 123;
                    case 228 -> 93;
                    case 229 -> 27;
                    case 230 -> 20;
                    case 231 -> 157;
                    case 232 -> 198;
                    case 233 -> 125;
                    case 234 -> 222;
                    case 235 -> 243;
                    case 236 -> 45;
                    case 237 -> 87;
                    case 238 -> 127;
                    case 239 -> 43;
                    case 240 -> 186;
                    case 241 -> 145;
                    case 242 -> 177;
                    case 243 -> 65;
                    case 244 -> 193;
                    case 245 -> 208;
                    case 246 -> 78;
                    case 247 -> 63;
                    case 248 -> 26;
                    case 249 -> 47;
                    case 250 -> 227;
                    case 251 -> 226;
                    case 252 -> 60;
                    case 253 -> 137;
                    case 254 -> 187;
                    default -> 156;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

