/*
 * Decompiled with CFR 0.152.
 */
package com.laravel_idea.plugin.packages;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.laravel_idea.plugin.extension.notifications.HelpersKt;
import com.laravel_idea.plugin.extension.notifications.NotificationAction;
import com.laravel_idea.plugin.extension.settings.LaravelIdeaSettings;
import com.laravel_idea.plugin.packages.BasePackageSupport;
import com.laravel_idea.plugin.packages.models.PackageDescription;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@State(name="LaravelModulesSettings", storages={@Storage(value="laravel-idea.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0000H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/laravel_idea/plugin/packages/LaravelModulesSettings;", "Lcom/laravel_idea/plugin/packages/BasePackageSupport;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "getName", "", "getDescription", "Lcom/laravel_idea/plugin/packages/models/PackageDescription;", "getState", "loadState", "", "state", "afterProjectOpen", "laravel-idea"})
public final class LaravelModulesSettings
extends BasePackageSupport
implements PersistentStateComponent<LaravelModulesSettings> {
    @Override
    @NotNull
    public String getName() {
        return "nwidart/laravel-modules";
    }

    @Override
    @NotNull
    public PackageDescription getDescription() {
        return new PackageDescription("https://nwidart.com/laravel-modules", "This package helps separate your application into modules with their own routes, controllers, models, etc.", "<b>Laravel Idea</b> supports routes, configs, translations, views, and properly generates the code.");
    }

    @NotNull
    public LaravelModulesSettings getState() {
        return this;
    }

    public void loadState(@NotNull LaravelModulesSettings state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @Override
    public void afterProjectOpen() {
        if (!Intrinsics.areEqual((Object)LaravelIdeaSettings.Companion.getInstance((Project)this.getProject()).state.getModuleSystemName(), (Object)"app")) {
            return;
        }
        HelpersKt.showNotificationWithDontShowAnymore(this.getProject(), "Modules.showNwidartNotification", "nWidart/laravel-modules package determined", "Switch Laravel Idea module system to laravel-modules?", CollectionsKt.listOf((Object)((Object)new NotificationAction("Switch", (Function0<Unit>)((Function0)() -> LaravelModulesSettings.afterProjectOpen$lambda$0(this))))));
    }

    private static final Unit afterProjectOpen$lambda$0(LaravelModulesSettings this$0) {
        LaravelIdeaSettings.Companion.getInstance(this$0.getProject()).changeModuleSystem("nwidart/laravel-modules");
        HelpersKt.showNotificationInfo$default(this$0.getProject(), "Laravel Idea", "Module system switched successfully. Please choose 'File > Invalidate Caches and Restart...' in case of issues with completion", null, 8, null);
        return Unit.INSTANCE;
    }
}

