/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.Parser;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.rewriter.ReWriteVisitor;

public class VagrantFileConfig {
    private static final Logger LOG = Logger.getInstance(VagrantFileConfig.class);
    public static final String VAGRANTFILE = "Vagrantfile";
    public static final String DISABLED_OPTION = "disabled";
    public static final String DEFAULT_VAGRANT_MACHINE_NAME = "default";
    private final File myFile;

    public VagrantFileConfig(File file) {
        this.myFile = file;
    }

    @Nullable
    public List<String> getMachineConfigurationNames() {
        try {
            String content = FileUtil.loadFile((File)this.myFile);
            if (!StringUtil.isEmpty((String)content)) {
                return VagrantFileConfig.readMachineConfigurationNames(this.myFile.getPath(), content);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static List<String> readMachineConfigurationNames(String file, String content) {
        final HashSet<String> result = new HashSet<String>();
        try {
            Node node = VagrantFileConfig.parseVagrantFile(file, content);
            node.accept((NodeVisitor)new ReWriteVisitor(new StringWriter(), content){

                public Object visitCallNode(CallNode iVisited) {
                    if ("define".equals(iVisited.getName())) {
                        List nodes;
                        if (!iVisited.childNodes().isEmpty() && "vm".equals(((CallNode)iVisited.childNodes().get(0)).getName()) && iVisited.getArgs() instanceof ArrayNode && !(nodes = iVisited.getArgs().childNodes()).isEmpty()) {
                            Object e = nodes.get(0);
                            if (e instanceof StrNode) {
                                StrNode vm = (StrNode)e;
                                result.add(vm.getValue());
                            } else {
                                e = nodes.get(0);
                                if (e instanceof SymbolNode) {
                                    SymbolNode vm = (SymbolNode)e;
                                    result.add(vm.getName());
                                }
                            }
                        }
                    } else {
                        super.visitCallNode(iVisited);
                    }
                    return null;
                }
            });
        }
        catch (Throwable e) {
            LOG.warn("Error parsing Vagrant file", e);
            return null;
        }
        if (result.isEmpty()) {
            result.add(DEFAULT_VAGRANT_MACHINE_NAME);
            if (LOG.isDebugEnabled()) {
                LOG.debug("No explicitly defined Vagrant machines in \"" + file + "\" found");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Explicitly defined Vagrant machines in \"" + file + "\": " + Joiner.on((String)", ").join(result));
        }
        return Lists.newArrayList(result);
    }

    private static Node parseVagrantFile(String file, String content) {
        Parser parser = new Parser();
        return parser.parse(file, (Reader)new StringReader(content), new ParserConfiguration(0, CompatVersion.RUBY2_0));
    }

    @Nullable
    public PathMappingSettings getCustomMappings() {
        try {
            String content = FileUtil.loadFile((File)this.myFile);
            if (!StringUtil.isEmpty((String)content)) {
                return this.mappingsFromContent(this.myFile.getPath(), content);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private PathMappingSettings mappingsFromContent(String file, String content) {
        final PathMappingSettings mappings = new PathMappingSettings();
        final Ref defaultSyncedFolderOverwritten = Ref.create((Object)false);
        try {
            Node node = VagrantFileConfig.parseVagrantFile(file, content);
            node.accept((NodeVisitor)new ReWriteVisitor(new StringWriter(), content){

                public Object visitCallNode(CallNode iVisited) {
                    if ("share_folder".equals(iVisited.getName())) {
                        Object e;
                        List nodes;
                        if (iVisited.getArgs() instanceof ArrayNode && (nodes = iVisited.getArgs().childNodes()).size() >= 3 && (e = nodes.get(1)) instanceof StrNode) {
                            StrNode guest = (StrNode)e;
                            e = nodes.get(2);
                            if (e instanceof StrNode) {
                                StrNode host = (StrNode)e;
                                VagrantFileConfig.this.addMapping(mappings, host.getValue(), guest.getValue());
                                if (".".equals(host.getValue())) {
                                    defaultSyncedFolderOverwritten.set((Object)true);
                                }
                            }
                        }
                    } else if ("synced_folder".equals(iVisited.getName())) {
                        Object e;
                        List nodes;
                        if (iVisited.getArgs() instanceof ArrayNode && (nodes = iVisited.getArgs().childNodes()).size() >= 2 && (e = nodes.get(0)) instanceof StrNode) {
                            StrNode host = (StrNode)e;
                            e = nodes.get(1);
                            if (e instanceof StrNode) {
                                StrNode guest = (StrNode)e;
                                boolean disabled = VagrantFileConfig.checkSyncedFolderDisabled(nodes);
                                if (!disabled) {
                                    VagrantFileConfig.this.addMapping(mappings, host.getValue(), guest.getValue());
                                }
                                if (".".equals(host.getValue())) {
                                    defaultSyncedFolderOverwritten.set((Object)true);
                                }
                            }
                        }
                    } else {
                        super.visitCallNode(iVisited);
                    }
                    return null;
                }
            });
        }
        catch (Throwable e) {
            LOG.error("Error parsing Vagrant file", e, new String[]{content});
        }
        if (!((Boolean)defaultSyncedFolderOverwritten.get()).booleanValue()) {
            this.addMapping(mappings, this.myFile.getParent(), "/vagrant");
        }
        return mappings;
    }

    private static boolean checkSyncedFolderDisabled(@NotNull List<Node> nodes) {
        Node optionsNode;
        if (nodes == null) {
            VagrantFileConfig.$$$reportNull$$$0(0);
        }
        if (nodes.size() >= 3 && nodes.get(2).getNodeType() == NodeType.HASHNODE && !(optionsNode = nodes.get(2)).childNodes().isEmpty()) {
            Iterator iterator = ((Node)optionsNode.childNodes().get(0)).childNodes().iterator();
            while (iterator.hasNext()) {
                Node key = (Node)iterator.next();
                if (!iterator.hasNext()) continue;
                Node value = (Node)iterator.next();
                if (!(key instanceof SymbolNode) || !DISABLED_OPTION.equals(((SymbolNode)key).getName()) || value.getNodeType() != NodeType.TRUENODE) continue;
                return true;
            }
        }
        return false;
    }

    private void addMapping(PathMappingSettings mappings, String hostValue, String guestValue) {
        if (".".equals(hostValue)) {
            hostValue = this.myFile.getParent();
        } else {
            if (!FileUtil.isAbsolutePlatformIndependent((String)(hostValue = OSAgnosticPathUtil.expandUserHome((String)hostValue)))) {
                hostValue = new File(this.myFile.getParent(), hostValue).getPath();
            }
            hostValue = FileUtil.toCanonicalPath((String)hostValue);
        }
        mappings.addMapping(hostValue, guestValue);
    }

    @Nullable
    public static VagrantFileConfig findInFolder(String folder) {
        File vagrantfile = new File(folder, VAGRANTFILE);
        if (vagrantfile.exists() && vagrantfile.isFile()) {
            try {
                return new VagrantFileConfig(vagrantfile);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/jetbrains/plugins/vagrant/VagrantFileConfig", "checkSyncedFolderDisabled"));
    }
}

