/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.init;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.wordpress.WPBundle;
import com.jetbrains.php.wordpress.WPUtil;
import com.jetbrains.php.wordpress.settings.WPDataService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WPContentConfigurationManager {
    private static final WPContentConfigurationManager INSTANCE = new WPContentConfigurationManager();
    private static final Set<String> INCLUDE_PATHS = Set.of("wp-includes", "wp-admin");

    public static WPContentConfigurationManager getInstance() {
        return INSTANCE;
    }

    private WPContentConfigurationManager() {
    }

    public void refreshIncludePaths(WPDataService.State newState, Project project) {
        if (!project.isDefault() && newState.isEnabled() && !newState.isDoNotAskContentConfigAgain()) {
            VirtualFile wpFile = WPContentConfigurationManager.getWPFile(newState);
            if (wpFile == null) {
                return;
            }
            if (VfsUtilCore.isAncestor((VirtualFile)project.getBaseDir(), (VirtualFile)wpFile, (boolean)false)) {
                return;
            }
            boolean isPluginInsideWP = VfsUtilCore.isAncestor((VirtualFile)wpFile, (VirtualFile)project.getBaseDir(), (boolean)false);
            if (isPluginInsideWP) {
                Module module;
                boolean isWPIncluded;
                Module[] modules = ModuleManager.getInstance((Project)project).getModules();
                if (modules.length == 1 && !(isWPIncluded = WPContentConfigurationManager.isFileInsideModule(wpFile, module = modules[0]))) {
                    WPContentConfigurationManager.suggestToChangeContentRoots(wpFile, project, module);
                }
            } else {
                WPContentConfigurationManager.addToIncludePath(wpFile, project);
            }
        }
    }

    private static void suggestToChangeContentRoots(@NotNull VirtualFile wpFile, @NotNull Project project, @NotNull Module module) {
        if (wpFile == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(0);
        }
        if (project == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(1);
        }
        if (module == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(2);
        }
        if (WPDataService.getInstance(project).isDoNotAskContentConfigurationAgain()) {
            return;
        }
        String message = WPBundle.message("wp.suggestion.content.roots", new Object[0]);
        Function<Notification, AnAction> fixAction = notification -> new DumbAwareAction(WPBundle.message("fix", new Object[0]), (Notification)notification, module, project, wpFile){
            final /* synthetic */ Notification val$notification;
            final /* synthetic */ Module val$module;
            final /* synthetic */ Project val$project;
            final /* synthetic */ VirtualFile val$wpFile;
            {
                this.val$notification = notification;
                this.val$module = module;
                this.val$project = project;
                this.val$wpFile = virtualFile;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.val$notification.expire();
                ModuleRootModificationUtil.updateModel((Module)this.val$module, model -> {
                    ContentEntry[] contentEntries = model.getContentEntries();
                    ContentEntry rootEntry = null;
                    for (ContentEntry entry : contentEntries) {
                        VirtualFile entryFile = entry.getFile();
                        if (entryFile == null || !VfsUtilCore.isAncestor((VirtualFile)entryFile, (VirtualFile)this.val$project.getBaseDir(), (boolean)false)) continue;
                        rootEntry = entry;
                        break;
                    }
                    if (rootEntry != null) {
                        VirtualFile rootEntryFile = rootEntry.getFile();
                        if (rootEntryFile == null || !VfsUtilCore.isAncestor((VirtualFile)rootEntryFile, (VirtualFile)this.val$wpFile, (boolean)false)) {
                            model.addContentEntry(this.val$wpFile);
                            model.removeContentEntry(rootEntry);
                        }
                    } else {
                        model.addContentEntry(this.val$wpFile);
                    }
                });
                if (PlatformUtils.isPhpStorm()) {
                    Runnable runnable = () -> ShowSettingsUtil.getInstance().showSettingsDialog(this.val$project, WPBundle.message("configurable.name.directories", new Object[0]));
                    ApplicationManager.getApplication().invokeLater(runnable, ModalityState.nonModal());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/wordpress/init/WPContentConfigurationManager$1", "actionPerformed"));
            }
        };
        Function<Notification, AnAction> ignoreAction = notification -> new DumbAwareAction(WPBundle.message("ignore", new Object[0]), (Notification)notification, project){
            final /* synthetic */ Notification val$notification;
            final /* synthetic */ Project val$project;
            {
                this.val$notification = notification;
                this.val$project = project;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.val$notification.expire();
                WPDataService.getInstance(this.val$project).setDoNotAskContentConfigurationAgain(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/wordpress/init/WPContentConfigurationManager$2", "actionPerformed"));
            }
        };
        WPContentConfigurationManager.showPopup(project, message, fixAction, ignoreAction);
    }

    private static void addToIncludePath(@NotNull VirtualFile wpFile, @NotNull Project project) {
        if (wpFile == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(3);
        }
        if (project == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(4);
        }
        ReadAction.nonBlocking(() -> {
            ArrayList<String> includePaths = new ArrayList<String>();
            for (String path : INCLUDE_PATHS) {
                VirtualFile file = VfsUtilCore.findRelativeFile((String)path, (VirtualFile)wpFile);
                if (file == null || WPContentConfigurationManager.isInIncludePath(file, project)) continue;
                includePaths.add(file.getPath());
            }
            return includePaths;
        }).finishOnUiThread(ModalityState.nonModal(), result -> PhpIncludePathManager.getInstance((Project)project).setIncludePath((List)result)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static boolean isInIncludePath(@NotNull VirtualFile fileToCheck, @NotNull Project project) {
        if (fileToCheck == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(5);
        }
        if (project == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(6);
        }
        List includePaths = PhpIncludePathManager.getInstance((Project)project).getAllIncludedRoots();
        for (VirtualFile file : includePaths) {
            if (file == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)fileToCheck, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getWPFile(WPDataService.State state) {
        String path = state.getWPPath();
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        NewVirtualFile file = ApplicationManager.getApplication().isUnitTestMode() ? VfsImplUtil.findFileByPath((NewVirtualFileSystem)TempFileSystem.getInstance(), (String)path) : LocalFileSystem.getInstance().findFileByPath(path);
        return file != null && file.isDirectory() ? file : null;
    }

    private static boolean isFileInsideModule(@NotNull VirtualFile wpFile, @NotNull Module module) {
        VirtualFile[] contentRoots;
        if (wpFile == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(7);
        }
        if (module == null) {
            WPContentConfigurationManager.$$$reportNull$$$0(8);
        }
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)wpFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static void showPopup(Project project, @NlsContexts.NotificationContent String message, Function<Notification, AnAction> ... actions) {
        Runnable runnable = () -> WPUtil.notifyGlobally(project, WPBundle.message("wp.plugin.title", new Object[0]), message, NotificationType.INFORMATION, actions);
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.nonModal());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wpFile";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToCheck";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/init/WPContentConfigurationManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestToChangeContentRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addToIncludePath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInIncludePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileInsideModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

