/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.externalProcessAuthHelper.SshPrompts;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshRemoteHostIdentificationHasChangedException;
import com.intellij.ssh.rsync.RSyncOptions;
import com.intellij.ssh.rsync.RsyncService;
import com.intellij.ssh.rsync.RsyncStatusService;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class RSyncUtil {
    private static final Logger LOG = Logger.getInstance(RSyncUtil.class);
    @NlsSafe
    public static final String RSYNC = "rsync";
    @NlsSafe
    public static final String SSH = "ssh";
    public static final String RSYNC_OPTIONS = "-zar";
    private static final String RSYNC_VERBOSE = "-v";
    private static final String RSYNC_SSH_PORT_OPTION = "-e";
    private static final String RSYNC_PORT_OPTION = "-p %s";
    private static final String RSYNC_PUBLIC_KEY_OPTION = "-i %s";
    private static final String RSYNC_SSH_OPTIONS = "%s %s %s";
    private static final String RSYNC_LOG_FILE_OPTION = "--log-file=%s";
    private static final String RSYNC_RELATIVE_OPTION = "-R";
    private static final String RSYNC_COPY_UNSAFE_LINKS_OPTION = "--copy-unsafe-links";
    private static final String RSYNC_COPY_LINKS_OPTION = "--copy-links";
    public static final int CHECK_CANCELLED_TIMEOUT = 200;
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Remote Transfer", (String)SshBundle.message("notification.group.name", new Object[0]));
    public static final String USE_RSYNC_REGISTRY_KEY = "ide.remote.interpreters.use.rsync";

    public static boolean checkRsyncInstalled() {
        return RsyncStatusService.getInstance().checkIfRSyncCommandExists();
    }

    public static boolean shouldInstallRSync() {
        if (!Registry.is((String)USE_RSYNC_REGISTRY_KEY)) {
            return false;
        }
        if (!PlatformUtils.isRubyMine()) {
            return false;
        }
        return !RSyncUtil.checkRsyncInstalled();
    }

    public static boolean canUseRSync() {
        if (!Registry.is((String)USE_RSYNC_REGISTRY_KEY) || SystemInfo.isWindows && !Registry.is((String)"ide.remote.interpreters.rsync.enabled.on.windows")) {
            return false;
        }
        return RSyncUtil.checkRsyncInstalled();
    }

    public static void uploadWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator2) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.G(0);
        }
        if (remotePath == null) {
            RSyncUtil.G(1);
        }
        if (credentials == null) {
            RSyncUtil.G(2);
        }
        if (progressIndicator2 == null) {
            RSyncUtil.G(3);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, RSyncUtil.wrap(progressIndicator2));
    }

    public static void uploadWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.G(4);
        }
        if (remotePath == null) {
            RSyncUtil.G(5);
        }
        if (credentials == null) {
            RSyncUtil.G(6);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.G(7);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, true, indicatorWrapper);
    }

    @ApiStatus.Experimental
    public static void uploadWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, boolean omitRemoteLastDirectoryNameIfNeeded, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.G(8);
        }
        if (remotePath == null) {
            RSyncUtil.G(9);
        }
        if (credentials == null) {
            RSyncUtil.G(10);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.G(11);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, Collections.emptyList(), omitRemoteLastDirectoryNameIfNeeded, false, indicatorWrapper, true);
    }

    @ApiStatus.Experimental
    public static void uploadWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull List<String> excludeElements, boolean omitRemoteLastDirectoryNameIfNeeded, boolean deleteFilesWithoutLocalPrototype, @NotNull IndicatorWrapper indicatorWrapper, boolean verbose) throws ExecutionException {
        Object object;
        if (localPath == null) {
            RSyncUtil.G(12);
        }
        if (remotePath == null) {
            RSyncUtil.G(13);
        }
        if (credentials == null) {
            RSyncUtil.G(14);
        }
        if (excludeElements == null) {
            RSyncUtil.G(15);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.G(16);
        }
        if (omitRemoteLastDirectoryNameIfNeeded && ((String)(object = PathUtilRt.getFileName((String)remotePath))).equals(PathUtilRt.getFileName((String)localPath))) {
            remotePath = remotePath.substring(0, remotePath.length() - ((String)object).length());
        }
        object = new RSyncOptions().withExcludeElements(excludeElements).withVerbose(verbose);
        RsyncCommandData rsyncCommandData = RSyncUtil.getRSyncCommandParameters(localPath, remotePath, credentials, (RSyncOptions)object, true);
        if (deleteFilesWithoutLocalPrototype) {
            rsyncCommandData.parameters.add("--delete");
        }
        RSyncUtil.G(rsyncCommandData, indicatorWrapper, credentials);
    }

    @ApiStatus.Experimental
    public static void uploadInBatchWithRSync(@NotNull String sharedLocalPath, @NotNull String sharedRemotePath, @NotNull Collection<String> relativePaths, @NotNull RemoteCredentials credentials, @NotNull List<String> excludeElements, boolean deleteFilesWithoutLocalPrototype, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (sharedLocalPath == null) {
            RSyncUtil.G(17);
        }
        if (sharedRemotePath == null) {
            RSyncUtil.G(18);
        }
        if (relativePaths == null) {
            RSyncUtil.G(19);
        }
        if (credentials == null) {
            RSyncUtil.G(20);
        }
        if (excludeElements == null) {
            RSyncUtil.G(21);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.G(22);
        }
        try (FilesFromOption filesFromOption = RSyncUtil.G(sharedLocalPath, relativePaths);){
            RSyncOptions rSyncOptions = new RSyncOptions().withExcludeElements(excludeElements).withVerbose(true).withFilesFrom(filesFromOption.G());
            RsyncCommandData rsyncCommandData = RSyncUtil.getRSyncCommandParameters(sharedLocalPath, sharedRemotePath, credentials, rSyncOptions, true);
            if (deleteFilesWithoutLocalPrototype) {
                rsyncCommandData.parameters.add(rsyncCommandData.parameters.size() - 2, "--delete");
            }
            RSyncUtil.G(rsyncCommandData, indicatorWrapper, credentials);
        }
        catch (IOException iOException) {
            throw new ExecutionException(SshBundle.message("dialog.message.rsync.failed.to.create.file.with.paths.to.upload", new Object[0]), (Throwable)iOException);
        }
    }

    @ApiStatus.Experimental
    public static void downloadInBatchWithRSync(@NotNull String sharedLocalPath, @NotNull String sharedRemotePath, @NotNull Collection<String> relativePaths, @NotNull RemoteCredentials credentials, @NotNull List<String> excludeElements, boolean deleteFilesWithoutLocalPrototype, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (sharedLocalPath == null) {
            RSyncUtil.G(23);
        }
        if (sharedRemotePath == null) {
            RSyncUtil.G(24);
        }
        if (relativePaths == null) {
            RSyncUtil.G(25);
        }
        if (credentials == null) {
            RSyncUtil.G(26);
        }
        if (excludeElements == null) {
            RSyncUtil.G(27);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.G(28);
        }
        try (FilesFromOption filesFromOption = RSyncUtil.G(sharedLocalPath, relativePaths);){
            RSyncOptions rSyncOptions = new RSyncOptions().withExcludeElements(excludeElements).withFilesFrom(filesFromOption.G()).withVerbose(true);
            RsyncCommandData rsyncCommandData = RSyncUtil.getRSyncCommandParameters(sharedLocalPath, sharedRemotePath, credentials, rSyncOptions, false);
            if (deleteFilesWithoutLocalPrototype) {
                rsyncCommandData.parameters.add(rsyncCommandData.parameters.size() - 2, "--delete");
            }
            RSyncUtil.G(rsyncCommandData, indicatorWrapper, credentials);
        }
        catch (IOException iOException) {
            throw new ExecutionException(SshBundle.message("dialog.message.rsync.failed.to.create.file.with.paths.to.upload", new Object[0]), (Throwable)iOException);
        }
    }

    private static void G(@NotNull Collection<String> collection, @NotNull File file) throws ExecutionException {
        if (collection == null) {
            RSyncUtil.G(29);
        }
        if (file == null) {
            RSyncUtil.G(30);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            boolean bl = true;
            for (String string : collection) {
                if (bl) {
                    bl = false;
                } else {
                    ((OutputStream)fileOutputStream).write("\n".getBytes(StandardCharsets.UTF_8));
                }
                ((OutputStream)fileOutputStream).write(string.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.error((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ExecutionException(SshBundle.message("dialog.message.rsync.failed.to.write.paths.to.upload.to.file", new Object[0]), (Throwable)iOException);
        }
    }

    public static void testConnection(@NotNull RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (credentials == null) {
            RSyncUtil.G(31);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.G(32);
        }
        String string = Ssh.wrapIPv6Address(credentials.getHost());
        String string2 = RSyncUtil.G(credentials);
        String string3 = String.format(RSYNC_PORT_OPTION, credentials.getPort());
        String string4 = String.format(RSYNC_SSH_OPTIONS, RsyncService.getInstance().getShellPath(), string3, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-n");
        arrayList.add(RSYNC_SSH_PORT_OPTION);
        arrayList.add(string4);
        arrayList.add(String.format("%s@%s:%s", credentials.getUserName(), string, ""));
        RSyncUtil.G(new RsyncCommandData(arrayList, new File(".")), indicatorWrapper, credentials);
    }

    @NotNull
    private static String G(@NotNull RemoteCredentials remoteCredentials) {
        if (remoteCredentials == null) {
            RSyncUtil.G(33);
        }
        return !StringUtil.isEmpty((String)remoteCredentials.getPrivateKeyFile()) ? String.format(RSYNC_PUBLIC_KEY_OPTION, remoteCredentials.getPrivateKeyFile()) : "";
    }

    public static boolean downloadFolderWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper, @NotNull RSyncOptions options) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.G(34);
        }
        if (remotePath == null) {
            RSyncUtil.G(35);
        }
        if (credentials == null) {
            RSyncUtil.G(36);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.G(37);
        }
        if (options == null) {
            RSyncUtil.G(38);
        }
        if (!((String)remotePath).endsWith("/")) {
            remotePath = (String)remotePath + "/";
        }
        RsyncCommandData rsyncCommandData = RSyncUtil.getRSyncCommandParameters(localPath, (String)remotePath, credentials, options, false);
        return RSyncUtil.G(rsyncCommandData, indicatorWrapper, credentials);
    }

    public static boolean downloadFolderWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator2, @NotNull RSyncOptions options) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.G(39);
        }
        if (remotePath == null) {
            RSyncUtil.G(40);
        }
        if (credentials == null) {
            RSyncUtil.G(41);
        }
        if (progressIndicator2 == null) {
            RSyncUtil.G(42);
        }
        if (options == null) {
            RSyncUtil.G(43);
        }
        return RSyncUtil.downloadFolderWithRSync(localPath, remotePath, credentials, RSyncUtil.wrap(progressIndicator2), options);
    }

    public static void downloadFileOrFolderWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper, @NotNull RSyncOptions options) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.G(44);
        }
        if (remotePath == null) {
            RSyncUtil.G(45);
        }
        if (credentials == null) {
            RSyncUtil.G(46);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.G(47);
        }
        if (options == null) {
            RSyncUtil.G(48);
        }
        if (remotePath.endsWith("/")) {
            RSyncUtil.downloadFolderWithRSync(localPath, remotePath, credentials, indicatorWrapper, options);
            return;
        }
        RsyncCommandData rsyncCommandData = RSyncUtil.getRSyncCommandParameters(localPath, remotePath, credentials, options, false);
        RSyncUtil.G(rsyncCommandData, indicatorWrapper, credentials);
    }

    public static void downloadFileOrFolderWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator2) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.G(49);
        }
        if (remotePath == null) {
            RSyncUtil.G(50);
        }
        if (credentials == null) {
            RSyncUtil.G(51);
        }
        if (progressIndicator2 == null) {
            RSyncUtil.G(52);
        }
        RSyncUtil.downloadFileOrFolderWithRSync(localPath, remotePath, credentials, RSyncUtil.wrap(progressIndicator2), new RSyncOptions().withVerbose(true));
    }

    public static void download(@NotNull List<? extends PathMappingSettings.PathMapping> pathMappings, @NotNull List<String> excludeElements, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator2) throws ExecutionException {
        Object object;
        if (pathMappings == null) {
            RSyncUtil.G(53);
        }
        if (excludeElements == null) {
            RSyncUtil.G(54);
        }
        if (credentials == null) {
            RSyncUtil.G(55);
        }
        if (progressIndicator2 == null) {
            RSyncUtil.G(56);
        }
        Notification notification = null;
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"rsync_download", (String)".log");
            object = new RSyncOptions().withExcludeElements(excludeElements).withLogfilePath(file.getPath()).withCopyLinks(true).withVerbose(true);
            for (PathMappingSettings.PathMapping pathMapping : pathMappings) {
                String string = new File(pathMapping.getLocalRoot()).getParent() + "/";
                String string2 = pathMapping.getRemoteRoot();
                RSyncUtil.downloadFileOrFolderWithRSync(string, string2, credentials, RSyncUtil.wrap(progressIndicator2), (RSyncOptions)object);
            }
        }
        catch (IOException iOException) {
        }
        catch (SshRemoteHostIdentificationHasChangedException sshRemoteHostIdentificationHasChangedException) {
            String string = sshRemoteHostIdentificationHasChangedException.getMessage() + "\n" + SshBundle.message("rsync.ssh.remote.host.identification.has.changed.message", new Object[0]);
            notification = NOTIFICATION_GROUP.createNotification(string, NotificationType.ERROR);
        }
        if (notification == null) {
            notification = NOTIFICATION_GROUP.createNotification(SshBundle.message("rsync.download.complete.title", new Object[0]), NotificationType.INFORMATION);
            if (file != null) {
                object = file.getPath();
                LOG.debug(SshBundle.message("rsync.download.complete.message", object));
                notification.addAction((AnAction)new DumbAwareAction(SshBundle.messagePointer("action.Anonymous.text.log.file", new Object[0]), (String)object){
                    final /* synthetic */ String val$logfilePath;
                    {
                        this.val$logfilePath = string;
                        super(arg0);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.G(0);
                        }
                        IdeUiService.getInstance().revealFile(Path.of(this.val$logfilePath, new String[0]));
                    }

                    private static /* synthetic */ void G(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/RSyncUtil$1", "actionPerformed"));
                    }
                });
            }
        }
        notification.notify(null);
    }

    private static boolean G(@NotNull RsyncCommandData rsyncCommandData, final @NotNull IndicatorWrapper indicatorWrapper, final @NotNull RemoteCredentials remoteCredentials) throws ExecutionException {
        String string;
        File file;
        if (rsyncCommandData == null) {
            RSyncUtil.G(57);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.G(58);
        }
        if (remoteCredentials == null) {
            RSyncUtil.G(59);
        }
        if (!(file = new File(string = RSyncUtil.getRsyncCommand())).exists() && (file = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)string)) == null) {
            throw new ExecutionException(SshBundle.message("rsync.missing.command", string));
        }
        boolean bl = SystemInfo.isWindows;
        PtyCommandLine ptyCommandLine = new PtyCommandLine().withConsoleMode(bl);
        ptyCommandLine.setExePath(file.getPath());
        ptyCommandLine.addParameters(rsyncCommandData.parameters);
        ptyCommandLine.setWorkDirectory(rsyncCommandData.workingDir);
        RSyncUtil.updateCommandLineIfWSL(ptyCommandLine, file);
        LOG.debug("Running " + ptyCommandLine.getCommandLineString());
        final OSProcessHandler oSProcessHandler = new OSProcessHandler((GeneralCommandLine)ptyCommandLine);
        final Ref ref = new Ref();
        final PrintWriter printWriter = new PrintWriter(oSProcessHandler.getProcessInput(), false, StandardCharsets.UTF_8);
        oSProcessHandler.addProcessListener(new ProcessListener(){
            private final AnsiEscapeDecoder myAnsiDecoder = new AnsiEscapeDecoder();
            private final AnsiEscapeDecoder.ColoredTextAcceptor myAcceptor = (string, key) -> {
                indicatorWrapper.addText(string, key);
                if (SshPrompts.PASSPHRASE_PROMPT.matcher(string).matches()) {
                    this.G(remoteCredentials.getPassphrase());
                } else if (string.toLowerCase(Locale.getDefault()).contains("remote host identification has changed")) {
                    ref.set((Object)true);
                    oSProcessHandler.destroyProcess();
                } else if (RSyncUtil.isPasswordRequired(string)) {
                    String string2 = remoteCredentials.getPassword() != null ? remoteCredentials.getPassword() : remoteCredentials.getUserName();
                    this.G(string2);
                } else if (string.contains("Are you sure you want to continue connecting")) {
                    this.G("yes");
                }
            };

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.G(0);
                }
                if (outputType == null) {
                    2.G(1);
                }
                try {
                    indicatorWrapper.checkCanceled();
                }
                catch (ProcessCanceledException processCanceledException) {
                    oSProcessHandler.destroyProcess();
                }
                String string = event.getText();
                if (string == null) {
                    return;
                }
                if (outputType == ProcessOutputTypes.STDERR && !string.contains("No such file or directory")) {
                    LOG.info(string);
                }
                LOG.debug(outputType.toString(), new Object[]{": ", string});
                this.myAnsiDecoder.escapeText(string, outputType, this.myAcceptor);
            }

            private void G(String string) {
                printWriter.print(StringUtil.notNullize((String)string) + "\r");
                printWriter.flush();
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.G(2);
                }
                indicatorWrapper.finished(event.getExitCode());
            }

            private static /* synthetic */ void G(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ssh/RSyncUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        oSProcessHandler.startNotify();
        while (!oSProcessHandler.waitFor(200L)) {
            if (indicatorWrapper.isCanceled()) {
                oSProcessHandler.destroyProcess();
            }
            indicatorWrapper.checkCanceled();
        }
        oSProcessHandler.waitFor();
        if (!indicatorWrapper.isCanceled() && oSProcessHandler.getExitCode() != null && oSProcessHandler.getExitCode() != 0) {
            LOG.warn("RSync exited with code: " + oSProcessHandler.getExitCode() + "\n\t" + ptyCommandLine.getCommandLineString());
        }
        if (ref.get() == Boolean.TRUE) {
            throw new SshRemoteHostIdentificationHasChangedException();
        }
        return oSProcessHandler.getExitCode() != null && oSProcessHandler.getExitCode() == 0;
    }

    public static IndicatorWrapper wrap(final @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            RSyncUtil.G(60);
        }
        return new IndicatorWrapper(){

            @Override
            public boolean isCanceled() {
                return indicator.isCanceled();
            }

            @Override
            public void checkCanceled() throws ProcessCanceledException {
                indicator.checkCanceled();
            }

            @Override
            public void addText(@NotNull @Nls String text, @NotNull Key<?> key) {
                if (text == null) {
                    3.G(0);
                }
                if (key == null) {
                    3.G(1);
                }
                if (key == ProcessOutputType.STDOUT && (text.contains("/") || text.contains("\\"))) {
                    indicator.setText(text);
                }
            }

            private static /* synthetic */ void G(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ssh/RSyncUtil$3";
                objectArray[2] = "addText";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    static boolean isPasswordRequired(String text) {
        String string = text.trim().toLowerCase(Locale.getDefault());
        return string.startsWith("password for") || string.endsWith("password:");
    }

    @NotNull
    static String getRsyncCommand() {
        String string = RsyncService.getInstance().getRsyncPath();
        if (string == null) {
            RSyncUtil.G(61);
        }
        return string;
    }

    static RsyncCommandData getRSyncCommandParameters(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull RSyncOptions options, boolean isServerSideModification) {
        if (localPath == null) {
            RSyncUtil.G(62);
        }
        if (remotePath == null) {
            RSyncUtil.G(63);
        }
        if (credentials == null) {
            RSyncUtil.G(64);
        }
        if (options == null) {
            RSyncUtil.G(65);
        }
        return RSyncUtil.getRSyncCommandParameters(localPath, remotePath, credentials, options, isServerSideModification, RsyncService.getInstance().getShellPath());
    }

    static RsyncCommandData getRSyncCommandParameters(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull RSyncOptions rSyncOptions, boolean isServerSideModification, String shellPath) {
        Object object;
        Object object2;
        if (localPath == null) {
            RSyncUtil.G(66);
        }
        if (remotePath == null) {
            RSyncUtil.G(67);
        }
        if (credentials == null) {
            RSyncUtil.G(68);
        }
        if (rSyncOptions == null) {
            RSyncUtil.G(69);
        }
        remotePath = StringUtil.escapeChars((String)remotePath, (char[])new char[]{' ', '$'});
        Object object3 = PathUtil.getFileName((String)localPath);
        if (localPath.endsWith("/") || localPath.endsWith("\\")) {
            object3 = (String)object3 + localPath.charAt(localPath.length() - 1);
        }
        String string = Ssh.wrapIPv6Address(credentials.getHost());
        String string2 = String.format("%s@%s:%s", credentials.getUserName(), string, remotePath);
        if (isServerSideModification) {
            object2 = object3;
            object = string2;
        } else {
            object2 = string2;
            object = object3;
        }
        String string3 = RSyncUtil.G(credentials);
        String string4 = String.format(RSYNC_PORT_OPTION, credentials.getPort());
        String string5 = String.format(RSYNC_SSH_OPTIONS, shellPath, string4, string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string6 = RsyncService.getInstance().getOptions();
        if (string6.equals(RSYNC_OPTIONS)) {
            arrayList.add(RSYNC_OPTIONS);
        } else {
            arrayList.addAll(StringUtil.split((String)string6, (String)","));
        }
        if (rSyncOptions.getRelative()) {
            arrayList.add(RSYNC_RELATIVE_OPTION);
        }
        if (rSyncOptions.getCopyUnsafeLinks()) {
            arrayList.add(RSYNC_COPY_UNSAFE_LINKS_OPTION);
        }
        if (rSyncOptions.getCopyLinks()) {
            arrayList.add(RSYNC_COPY_LINKS_OPTION);
        }
        if (rSyncOptions.getVerbose()) {
            arrayList.add(RSYNC_VERBOSE);
        }
        arrayList.add(RSYNC_SSH_PORT_OPTION);
        arrayList.add(string5);
        if (rSyncOptions.getLogfilePath() != null) {
            arrayList.add(String.format(RSYNC_LOG_FILE_OPTION, rSyncOptions.getLogfilePath()));
        }
        if (rSyncOptions.getFilesFrom() != null) {
            arrayList.add("--files-from=" + FileUtil.toSystemIndependentName((String)rSyncOptions.getFilesFrom()));
        }
        for (String string7 : rSyncOptions.getExcludeElements()) {
            arrayList.add("--exclude=" + string7);
        }
        arrayList.add((String)object2);
        arrayList.add((String)object);
        return new RsyncCommandData(arrayList, RSyncUtil.G(localPath));
    }

    @NotNull
    private static FilesFromOption G(@NotNull String string, @NotNull Collection<String> collection) throws ExecutionException, IOException {
        FilesFromOption filesFromOption;
        if (string == null) {
            RSyncUtil.G(70);
        }
        if (collection == null) {
            RSyncUtil.G(71);
        }
        if (SystemInfo.isWindows) {
            File file = RSyncUtil.G(string);
            File file2 = FileUtil.createTempFile((File)file, (String)"fileList", (String)".txt");
            filesFromOption = new FilesFromOption(file2, file2.getName());
        } else {
            File file = FileUtil.createTempFile((String)"fileList", (String)".txt");
            filesFromOption = new FilesFromOption(file, file.getPath());
        }
        RSyncUtil.G(collection, filesFromOption.G());
        FilesFromOption filesFromOption2 = filesFromOption;
        if (filesFromOption2 == null) {
            RSyncUtil.G(72);
        }
        return filesFromOption2;
    }

    public static void updateCommandLineIfWSL(PtyCommandLine commandLine, File executablePath) throws ExecutionException {
        WSLDistribution wSLDistribution;
        WslPath wslPath = WslPath.parseWindowsUncPath((String)executablePath.getPath());
        if (wslPath != null && (wSLDistribution = WslPath.getDistributionByWindowsUncPath((String)executablePath.getPath())) != null) {
            commandLine.setExePath(RSyncUtil.updateCommandIfWSL(commandLine.getExePath(), wSLDistribution));
            ParametersList parametersList = commandLine.getParametersList();
            List list = parametersList.getList();
            parametersList.clearAll();
            for (String string : list) {
                parametersList.add(RSyncUtil.updateCommandIfWSL(string, wSLDistribution));
            }
            wSLDistribution.patchCommandLine((GeneralCommandLine)commandLine, null, new WSLCommandLineOptions());
        }
    }

    @NotNull
    public static String updateCommandIfWSL(String path2, WSLDistribution distribution) {
        String string = distribution.getWslPath(path2);
        String string2 = string != null ? string : path2;
        if (string2 == null) {
            RSyncUtil.G(73);
        }
        return string2;
    }

    @NotNull
    private static File G(@NotNull String string) {
        if (string == null) {
            RSyncUtil.G(74);
        }
        File file = new File(string).getParentFile();
        FileUtil.createDirectory((File)file);
        File file2 = file;
        if (file2 == null) {
            RSyncUtil.G(75);
        }
        return file2;
    }

    private static /* synthetic */ void G(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 61, 72, 73, 75 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 35: 
            case 40: 
            case 45: 
            case 50: 
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 20: 
            case 26: 
            case 31: 
            case 33: 
            case 36: 
            case 41: 
            case 46: 
            case 51: 
            case 55: 
            case 59: 
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: 
            case 42: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 22: 
            case 28: 
            case 32: 
            case 37: 
            case 47: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorWrapper";
                break;
            }
            case 15: 
            case 21: 
            case 27: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeElements";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedLocalPath";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedRemotePath";
                break;
            }
            case 19: 
            case 25: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 38: 
            case 43: 
            case 48: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 61: 
            case 72: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/RSyncUtil";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSyncOptions";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/RSyncUtil";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getRsyncCommand";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareFilesFromOption";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "updateCommandIfWSL";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uploadWithRSync";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "uploadInBatchWithRSync";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "downloadInBatchWithRSync";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "writePaths";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "testConnection";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "downloadFolderWithRSync";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileOrFolderWithRSync";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "runAndListenBashCommand";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 61: 
            case 72: 
            case 73: 
            case 75: {
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getRSyncCommandParameters";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "prepareFilesFromOption";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 61, 72, 73, 75 -> new IllegalStateException(string);
        };
    }

    public static interface IndicatorWrapper {
        public boolean isCanceled();

        public void checkCanceled() throws ProcessCanceledException;

        public void addText(@NotNull @Nls String var1, @NotNull Key<?> var2);

        default public void finished(int exitCode2) {
        }
    }

    static class RsyncCommandData {
        @NotNull
        public final List<String> parameters;
        @NotNull
        public final File workingDir;

        private RsyncCommandData(@NotNull List<String> parameters, @NotNull File workingDir) {
            if (parameters == null) {
                RsyncCommandData.G(0);
            }
            if (workingDir == null) {
                RsyncCommandData.G(1);
            }
            this.parameters = parameters;
            this.workingDir = workingDir;
        }

        private static /* synthetic */ void G(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ssh/RSyncUtil$RsyncCommandData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class FilesFromOption
    implements Closeable {
        @NotNull
        private final File myFile;
        @NotNull
        private final String myOptionValue;

        private FilesFromOption(@NotNull File file, @NotNull String optionValue) {
            if (file == null) {
                FilesFromOption.G(0);
            }
            if (optionValue == null) {
                FilesFromOption.G(1);
            }
            this.myFile = file;
            this.myOptionValue = optionValue;
        }

        @NotNull
        private File G() {
            File file = this.myFile;
            if (file == null) {
                FilesFromOption.G(2);
            }
            return file;
        }

        @NotNull
        private String G() {
            String string = this.myOptionValue;
            if (string == null) {
                FilesFromOption.G(3);
            }
            return string;
        }

        @Override
        public void close() {
            FileUtil.delete((File)this.myFile);
        }

        private static /* synthetic */ void G(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionValue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/RSyncUtil$FilesFromOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/RSyncUtil$FilesFromOption";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptionValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

