/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec.resolve.type;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.phpspec.PhpSpecUtil;
import com.jetbrains.php.phpspec.resolve.type.PhpSpecBaseTypeProvider;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PhpSpecTypeProvider
extends PhpSpecBaseTypeProvider {
    private static final String SUBJECT = "\\PhpSpec\\Wrapper\\Subject";
    private static final String GET_WRAPPED_OBJECT = "getWrappedObject";

    public char getKey() {
        return '\u01a7';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        PhpExpression reference;
        PhpClass clazz;
        Project project = element.getProject();
        if (!PhpSpecTypeProvider.isEnabled(project)) {
            return null;
        }
        Method method = (Method)PhpPsiUtil.getParentOfClass((PsiElement)element, Method.class);
        PhpClass phpClass = clazz = method != null ? method.getContainingClass() : null;
        if (clazz == null || !PhpSpecUtil.isSpecTestClass(project, clazz.getFQN())) {
            return null;
        }
        if (PhpLangUtil.isThisReference((PsiElement)element)) {
            return new PhpType().add(PhpSpecUtil.toMockedClass(project, clazz.getFQN()));
        }
        if (element instanceof MethodReference && (reference = ((MethodReference)element).getClassReference()) != null) {
            PhpType result = new PhpType();
            if (PhpLangUtil.equalsMethodNames((CharSequence)GET_WRAPPED_OBJECT, (CharSequence)((MethodReference)element).getName())) {
                reference.getType().getTypes().stream().filter(s -> !s.startsWith("#" + this.getKey()) && !PhpSpecUtil.isSpecTestClass(project, s)).forEach(arg_0 -> ((PhpType)result).add(arg_0));
            } else {
                reference.getType().getTypes().stream().filter(s -> s.startsWith("#" + this.getKey()) || PhpSpecUtil.isSpecTestClass(project, s)).map(s -> "#" + this.getKey() + s + "." + ((MethodReference)element).getName()).forEach(arg_0 -> ((PhpType)result).add(arg_0));
            }
            return result;
        }
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        int i = expression.indexOf(46);
        if (i > 0 && expression.length() > i + 1) {
            String classSignature = expression.substring(0, i);
            String methodName = expression.substring(i + 1);
            PhpIndex index = PhpIndex.getInstance((Project)project);
            boolean hasMethod = (classSignature.startsWith("#") ? index.getBySignature(classSignature, visited, depth) : index.getAnyByFQN(classSignature)).stream().anyMatch(c -> c instanceof PhpClass && ((PhpClass)c).findMethodByName((CharSequence)methodName) != null);
            if (!hasMethod) {
                return index.getAnyByFQN(SUBJECT);
            }
        }
        return null;
    }
}

