/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.English;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.en.BritishReplaceRule;
import org.languagetool.rules.en.MorfologikBritishSpellerRule;
import org.languagetool.rules.en.UnitConversionRuleImperial;
import org.languagetool.rules.spelling.SpellingCheckRule;

public class BritishEnglish
extends English {
    private static final String LANGUAGE_SHORT_CODE = "en-GB";
    private static volatile Throwable instantiationTrace;
    private static final Map<String, Integer> id2prio;

    public BritishEnglish() {
        Throwable trace = instantiationTrace;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTrace = new Throwable();
    }

    protected BritishEnglish(boolean fakeValue) {
    }

    @Override
    public String[] getCountries() {
        return new String[]{"GB"};
    }

    @Override
    public String getName() {
        return "English (GB)";
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new BritishReplaceRule(messages, "/en/en-GB/replace.txt"));
        rules.add((Rule)new UnitConversionRuleImperial(messages));
        return rules;
    }

    @Override
    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikBritishSpellerRule(messages, (Language)this, null, Collections.emptyList());
    }

    @Override
    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel lm, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>(super.getRelevantLanguageModelCapableRules(messages, lm, globalConfig, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new MorfologikBritishSpellerRule(messages, (Language)this, globalConfig, userConfig, altLanguages, lm, motherTongue));
        return rules;
    }

    @Override
    public Map<String, Integer> getPriorityMap() {
        return id2prio;
    }

    @Override
    protected int getPriorityForId(String id) {
        Integer prio = id2prio.get(id);
        if (prio != null) {
            return prio;
        }
        return super.getPriorityForId(id);
    }

    @NotNull
    public static English getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode((String)LANGUAGE_SHORT_CODE));
        if (language instanceof English) {
            English britishEnglish = (English)language;
            return britishEnglish;
        }
        throw new RuntimeException("BritishEnglish language expected, got " + String.valueOf(language));
    }

    static {
        id2prio = new HashMap<String, Integer>();
        id2prio.put("OXFORD_SPELLING_ISATION_NOUNS", -20);
        id2prio.put("OXFORD_SPELLING_ISE_VERBS", -21);
        id2prio.put("OXFORD_SPELLING_IZE", -22);
    }
}

