/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.editor.enterHandlers;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.lang.editor.enterHandlers.PhpEnterHandlerBase;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.util.PhpFlexibleHeredocHelper;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PhpHeredocEnterHandler
extends PhpEnterHandlerBase {
    @Override
    public boolean beforeEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext, @NotNull Project project, @NotNull Document document, int lineNumber, int caret, @NotNull PsiElement elementAt) {
        StringLiteralExpression string;
        String name;
        PsiElement parent;
        if (file == null) {
            PhpHeredocEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpHeredocEnterHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            PhpHeredocEnterHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpHeredocEnterHandler.$$$reportNull$$$0(3);
        }
        if (document == null) {
            PhpHeredocEnterHandler.$$$reportNull$$$0(4);
        }
        if (elementAt == null) {
            PhpHeredocEnterHandler.$$$reportNull$$$0(5);
        }
        if (BasicPhpPsiUtil.isOfType(elementAt, HEREDOC_START) && elementAt.getTextRange().getEndOffset() <= caret + 1 && lineNumber == document.getLineNumber(elementAt.getTextOffset()) && (parent = elementAt.getParent()) instanceof StringLiteralExpression && (name = (string = (StringLiteralExpression)parent).getName()) != null) {
            if (!BasicPhpPsiUtil.isOfType(string.getLastChild(), HEREDOC_END) || PhpHeredocEnterHandler.containsHeredocOrNowdoc(string, name)) {
                String endOfString = string.getParent() instanceof ParameterList ? "\n" : ";\n";
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)("\n\n" + name + endOfString));
                editor.getCaretModel().moveCaretRelatively(0, -2, false, false, true);
                return true;
            }
            if (BasicPhpPsiUtil.isOfType(string.getLastChild(), HEREDOC_END)) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)("\n" + PhpFlexibleHeredocHelper.getEndTagIndent(string)));
                return true;
            }
        }
        return false;
    }

    private static boolean containsHeredocOrNowdoc(@NotNull StringLiteralExpression string, @NotNull String name) {
        if (string == null) {
            PhpHeredocEnterHandler.$$$reportNull$$$0(6);
        }
        if (name == null) {
            PhpHeredocEnterHandler.$$$reportNull$$$0(7);
        }
        return Pattern.compile("<<<['\"]?" + name + "['\"]?").matcher(StringUtil.newBombedCharSequence((CharSequence)string.getContents(), (long)1000L)).find();
    }

    @Override
    public EnterHandlerDelegate.Result getNextAction() {
        return EnterHandlerDelegate.Result.Stop;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/editor/enterHandlers/PhpHeredocEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeEnter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "containsHeredocOrNowdoc";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

