/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import com.jetbrains.php.lang.formatter.PhpAlignmentProcessor;
import com.jetbrains.php.lang.formatter.PhpBlock;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpWrappingProcessor
extends PhpFormatterUtil {
    private final CommonCodeStyleSettings mySettings;
    private final PhpCodeStyleSettings myPhpSettings;
    private final ASTNode myNode;
    private Wrap mySharedWrap;
    private final PhpBlock myOwner;

    PhpWrappingProcessor(@NotNull PhpBlock owner, ASTNode node, CommonCodeStyleSettings settings, PhpCodeStyleSettings phpSettings) {
        if (owner == null) {
            PhpWrappingProcessor.$$$reportNull$$$0(0);
        }
        this.myNode = node;
        this.mySettings = settings;
        this.myPhpSettings = phpSettings;
        this.myOwner = owner;
        this.initSharedWrap(node);
    }

    Wrap createChildWrap(ASTNode child, @Nullable Wrap preferredWrap, @Nullable Wrap childWrap) {
        ASTNode superParent;
        IElementType childType = child.getElementType();
        IElementType parentType = this.myNode.getElementType();
        if (childType == PhpTokenTypes.opCOMMA || childType == PhpTokenTypes.opSEMICOLON) {
            return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
        }
        if ((parentType == PhpElementTypes.EXTENDS_LIST || parentType == PhpElementTypes.IMPLEMENTS_LIST) && childType != PhpTokenTypes.kwEXTENDS && childType != PhpTokenTypes.kwIMPLEMENTS) {
            return Wrap.createWrap((int)this.mySettings.EXTENDS_LIST_WRAP, (boolean)true);
        }
        if (childType == PhpElementTypes.IMPLEMENTS_LIST || childType == PhpElementTypes.EXTENDS_LIST) {
            return Wrap.createWrap((int)this.mySettings.EXTENDS_KEYWORD_WRAP, (boolean)true);
        }
        if (parentType == PhpElementTypes.PARAMETER_LIST && (superParent = this.myNode.getTreeParent()) != null) {
            if ((superParent.getElementType() == PhpElementTypes.FUNCTION_CALL || superParent.getElementType() == PhpElementTypes.METHOD_REFERENCE || superParent.getElementType() == PhpElementTypes.NEW_EXPRESSION) && this.mySettings.CALL_PARAMETERS_WRAP != 0) {
                if (BasicPhpPsiUtil.getNameIdentifier(child.getPsi()) != null || childType == PhpTokenTypes.opCOLON) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                if (this.myNode.getFirstChildNode() == child) {
                    return this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE ? Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true) : Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                if (!this.mySettings.PREFER_PARAMETERS_WRAP && preferredWrap != null) {
                    return Wrap.createChildWrap((Wrap)preferredWrap, (WrapType)WrappingUtil.getWrapType((int)this.mySettings.CALL_PARAMETERS_WRAP), (boolean)true);
                }
                if ((this.mySettings.CALL_PARAMETERS_WRAP & 4) != 0 && childWrap != null) {
                    return childWrap;
                }
                if (!PhpFormatterUtil.isPrecededBy(child, PhpTokenTypes.C_STYLE_COMMENT) && !PhpFormatterUtil.isPrecededBy(child, PhpDocStubElementTypes.DOC_COMMENT)) {
                    return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.CALL_PARAMETERS_WRAP), (boolean)true);
                }
            }
            if ((superParent.getElementType() == PhpStubElementTypes.FUNCTION || superParent.getElementType() == PhpStubElementTypes.CLASS_METHOD) && this.mySettings.METHOD_PARAMETERS_WRAP != 0) {
                if (this.myNode.getFirstChildNode() == child) {
                    return this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE ? Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true) : Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.METHOD_PARAMETERS_WRAP), (boolean)true);
            }
        }
        if (parentType == PhpElementTypes.FUNCTION_CALL || parentType == PhpElementTypes.METHOD_REFERENCE || parentType == PhpElementTypes.NEW_EXPRESSION) {
            if (this.mySettings.CALL_PARAMETERS_WRAP != 0 && childType == PhpTokenTypes.chRPAREN) {
                return Wrap.createWrap((WrapType)(this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE ? WrapType.NORMAL : WrapType.NONE), (boolean)true);
            }
            if (PhpAlignmentProcessor.isArrowOrNullsafeQuestOp(child)) {
                if (PhpFormatterUtil.isAtChainedCall(child) && !PhpFormatterUtil.isAtFirstMethodReference(child)) {
                    return childWrap != null ? childWrap : Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)true);
                }
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
            }
        }
        if ((parentType == PhpStubElementTypes.FUNCTION || parentType == PhpStubElementTypes.CLASS_METHOD) && this.mySettings.METHOD_PARAMETERS_WRAP != 0 && childType == PhpTokenTypes.chRPAREN && this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE) {
            return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
        }
        if (parentType == PhpStubElementTypes.USE_LIST && (superParent = this.myNode.getTreeParent()) != null && superParent.getElementType() == PhpStubElementTypes.FUNCTION && childType != PhpTokenTypes.kwUSE && childType != PhpTokenTypes.chLBRACE && childType != PhpTokenTypes.chRBRACE) {
            return Wrap.createWrap((int)this.mySettings.METHOD_PARAMETERS_WRAP, (boolean)true);
        }
        if (parentType == PhpElementTypes.USE_BRACES && childType == PhpStubElementTypes.USE) {
            return Wrap.createWrap((int)this.myPhpSettings.GROUP_USE_WRAP, (boolean)true);
        }
        if ((parentType == PhpElementTypes.FOR || parentType == PhpElementTypes.FOREACH) && this.mySettings.FOR_STATEMENT_WRAP != 0) {
            if (childType != PhpTokenTypes.chLPAREN && childType != PhpTokenTypes.chRPAREN && !PhpFormatterUtil.isPrecededBy(child, PhpTokenTypes.chLPAREN)) {
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.FOR_STATEMENT_WRAP), (boolean)true);
            }
            return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
        }
        if (this.mySettings.BINARY_OPERATION_WRAP != 0 && PhpElementTypes.BINARY_EXPRESSIONS.contains(parentType)) {
            if (!PhpFormatterUtil.isBinaryOperator(childType)) {
                if (this.myNode.getTextRange().getStartOffset() == child.getTextRange().getStartOffset()) {
                    return null;
                }
                if (PhpFormatterUtil.isPrecededBy(child, PhpFormatterUtil.BINARY_OPERATORS) && this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE || PhpFormatterUtil.isAfterLeftBrace(child)) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                return childWrap == null ? Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.BINARY_OPERATION_WRAP), (boolean)true) : childWrap;
            }
            if (this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                return childWrap == null ? Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.BINARY_OPERATION_WRAP), (boolean)true) : childWrap;
            }
        }
        if (this.mySettings.ASSIGNMENT_WRAP != 0 && (parentType == PhpElementTypes.ASSIGNMENT_EXPRESSION || parentType == PhpElementTypes.MULTIASSIGNMENT_EXPRESSION)) {
            if (!PhpFormatterUtil.isAssignmentOperator(childType)) {
                if (PhpFormatterUtil.isPrecededBy(child, PhpTokenTypes.tsASGN_OPS) && this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.ASSIGNMENT_WRAP), (boolean)true);
            }
            if (this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        }
        if (parentType == PhpElementTypes.TERNARY_EXPRESSION) {
            if (this.myNode.getFirstChildNode() != child && (this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE ? !PhpFormatterUtil.isPrecededBy(child, PhpTokenTypes.opQUEST) && !PhpFormatterUtil.isPrecededBy(child, PhpTokenTypes.opCOLON) : childType != PhpTokenTypes.opQUEST && childType != PhpTokenTypes.opCOLON)) {
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.TERNARY_OPERATION_WRAP), (boolean)true);
            }
            return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
        }
        if (parentType == PhpElementTypes.ARRAY_CREATION_EXPRESSION) {
            ASTNode firstChild = this.myNode.getFirstChildNode();
            if (firstChild != null && firstChild.getElementType() == PhpTokenTypes.kwARRAY) {
                if (childType != PhpTokenTypes.kwARRAY && childType != PhpTokenTypes.chLPAREN) {
                    WrapType elementWrapType = PhpWrappingProcessor.getArrayInitializerWrapType(this.mySettings, child, PhpTokenTypes.chLPAREN, PhpTokenTypes.chRPAREN);
                    if (elementWrapType == WrapType.CHOP_DOWN_IF_LONG) {
                        return childWrap;
                    }
                    return Wrap.createWrap((WrapType)elementWrapType, (boolean)true);
                }
            } else if (childType != PhpTokenTypes.chLBRACKET) {
                WrapType elementWrapType = PhpWrappingProcessor.getArrayInitializerWrapType(this.mySettings, child, PhpTokenTypes.chLBRACKET, PhpTokenTypes.chRBRACKET);
                if (elementWrapType == WrapType.CHOP_DOWN_IF_LONG) {
                    return childWrap;
                }
                return Wrap.createWrap((WrapType)elementWrapType, (boolean)true);
            }
        }
        if ((parentType == PhpStubElementTypes.CLASS_METHOD && childType == PhpTokenTypes.kwFUNCTION || parentType == PhpStubElementTypes.CLASS && childType == PhpTokenTypes.kwCLASS) && this.mySettings.MODIFIER_LIST_WRAP) {
            return Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
        }
        return null;
    }

    public static WrapType getArrayInitializerWrapType(CommonCodeStyleSettings settings, ASTNode node, IElementType lBraceType, IElementType rBraceType) {
        return node.getElementType() == rBraceType || FormatterUtil.isPrecededBy((ASTNode)node, (IElementType)lBraceType) ? WrapType.NONE : WrappingUtil.getWrapType((int)settings.ARRAY_INITIALIZER_WRAP);
    }

    private void initSharedWrap(ASTNode node) {
        if (node == null) {
            return;
        }
        IElementType nodeType = node.getElementType();
        if (PhpFormatterUtil.isAssignmentOperator(nodeType) && (this.mySettings.ASSIGNMENT_WRAP & 4) != 0 || PhpElementTypes.tsARRAY_EXPRESSIONS.contains(nodeType) && (this.mySettings.ARRAY_INITIALIZER_WRAP & 4) != 0 || PhpElementTypes.BINARY_EXPRESSIONS.contains(nodeType) && (this.mySettings.BINARY_OPERATION_WRAP & 4) != 0 || nodeType == PhpElementTypes.PARAMETER_LIST && (this.mySettings.CALL_PARAMETERS_WRAP & 4) != 0 || nodeType == PhpElementTypes.METHOD_REFERENCE && (this.mySettings.METHOD_CALL_CHAIN_WRAP & 4) != 0) {
            this.mySharedWrap = Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
        }
    }

    Wrap getSharedWrap() {
        BlockWithParent parentBlock;
        ASTNode parent;
        IElementType nodeType = this.myNode.getElementType();
        if ((PhpElementTypes.BINARY_EXPRESSIONS.contains(nodeType) && (this.mySettings.BINARY_OPERATION_WRAP & 4) != 0 || nodeType == PhpElementTypes.METHOD_REFERENCE && (this.mySettings.METHOD_CALL_CHAIN_WRAP & 4) != 0) && (parent = this.myNode.getTreeParent()) != null && parent.getElementType() == this.myNode.getElementType() && (parentBlock = this.myOwner.getParent()) instanceof PhpBlock) {
            return ((PhpBlock)parentBlock).getChildWrap();
        }
        return this.mySharedWrap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/jetbrains/php/lang/formatter/PhpWrappingProcessor", "<init>"));
    }
}

