/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocElementType;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.highlighter.PhpHighlightingLexer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PhpFileSyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    private static final Map<IElementType, TextAttributesKey> DOC_ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    private final Lexer myBaseLexer;
    private Project myProject = null;

    public PhpFileSyntaxHighlighter() {
        this(null);
    }

    public PhpFileSyntaxHighlighter(Lexer baseLexer) {
        this.myBaseLexer = baseLexer;
    }

    public PhpFileSyntaxHighlighter(Lexer baseLexer, Project project) {
        this(baseLexer);
        this.myProject = project;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new PhpHighlightingLexer(this.myProject, this.myBaseLexer);
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = PhpFileSyntaxHighlighter.pack((TextAttributesKey)ATTRIBUTES.get(tokenType), (TextAttributesKey)DOC_ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            PhpFileSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    private static void registerHtmlMarkup(IElementType[] htmlTokens, IElementType[] htmlTokens2) {
        for (IElementType idx : htmlTokens) {
            ATTRIBUTES.put(idx, PhpHighlightingData.DOC_COMMENT);
            DOC_ATTRIBUTES.put(idx, PhpHighlightingData.DOC_MARKUP);
        }
        for (IElementType idx : htmlTokens2) {
            ATTRIBUTES.put(idx, PhpHighlightingData.DOC_COMMENT);
        }
    }

    private static void registerPHPDoc() {
        IElementType[] phpdoc;
        ATTRIBUTES.put(PhpDocTokenTypes.DOC_TAG_NAME_FOR_EDITOR, PhpHighlightingData.DOC_COMMENT);
        DOC_ATTRIBUTES.put(PhpDocTokenTypes.DOC_TAG_NAME_FOR_EDITOR, PhpHighlightingData.DOC_TAG);
        DOC_ATTRIBUTES.put(PhpDocTokenTypes.DOC_MAIL, PhpHighlightingData.DOC_TAG);
        DOC_ATTRIBUTES.put(PhpDocTokenTypes.DOC_URL, PhpHighlightingData.DOC_TAG);
        for (IElementType type2 : phpdoc = IElementType.enumerate(type -> type instanceof PhpDocElementType)) {
            ATTRIBUTES.put(type2, PhpHighlightingData.DOC_COMMENT);
        }
        IElementType[] javaDocMarkup = new IElementType[]{XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_TAG_END, XmlTokenType.XML_EMPTY_ELEMENT_END, XmlTokenType.TAG_WHITE_SPACE, XmlTokenType.XML_TAG_NAME, XmlTokenType.XML_NAME, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, XmlTokenType.XML_EQ};
        IElementType[] javaDocMarkup2 = new IElementType[]{XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.TAG_WHITE_SPACE};
        PhpFileSyntaxHighlighter.registerHtmlMarkup(javaDocMarkup, javaDocMarkup2);
    }

    static {
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpTokenTypes.tsPHP_OPENING_TAGS, (TextAttributesKey)PhpHighlightingData.PHP_TAG);
        ATTRIBUTES.put(PhpTokenTypes.PHP_CLOSING_TAG, PhpHighlightingData.PHP_TAG);
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpElementTypes.tsCOMMENTS, (TextAttributesKey)PhpHighlightingData.COMMENT);
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpTokenTypes.tsNUMBERS, (TextAttributesKey)PhpHighlightingData.NUMBER);
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpTokenTypes.tsSTRING_EDGE, (TextAttributesKey)PhpHighlightingData.STRING);
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpTokenTypes.tsOPERATORS, (TextAttributesKey)PhpHighlightingData.OPERATION_SIGN);
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpTokenTypes.tsTERNARY_OPS, (TextAttributesKey)PhpHighlightingData.OPERATION_SIGN);
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpTokenTypes.tsKEYWORDS, (TextAttributesKey)PhpHighlightingData.KEYWORD);
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpTokenTypes.tsBRACKETS, (TextAttributesKey)PhpHighlightingData.BRACKETS);
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpTokenTypes.tsBRACES, (TextAttributesKey)PhpHighlightingData.BRACES);
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpTokenTypes.tsPARENTHESES, (TextAttributesKey)PhpHighlightingData.PARENTHESES);
        PhpFileSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PhpTokenTypes.tsHEREDOC_IDS, (TextAttributesKey)PhpHighlightingData.HEREDOC_ID);
        ATTRIBUTES.put(PhpTokenTypes.HEREDOC_CONTENTS, PhpHighlightingData.HEREDOC_CONTENT);
        ATTRIBUTES.put(PhpTokenTypes.opCOMMA, PhpHighlightingData.COMMA);
        ATTRIBUTES.put(PhpTokenTypes.opSEMICOLON, PhpHighlightingData.SEMICOLON);
        ATTRIBUTES.put(PhpTokenTypes.STRING_LITERAL, PhpHighlightingData.STRING);
        ATTRIBUTES.put(PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE, PhpHighlightingData.STRING);
        ATTRIBUTES.put(PhpTokenTypes.EXEC_COMMAND, PhpHighlightingData.EXEC_COMMAND);
        ATTRIBUTES.put(PhpTokenTypes.chLBACKTRICK, PhpHighlightingData.EXEC_COMMAND);
        ATTRIBUTES.put(PhpTokenTypes.chRBACKTRICK, PhpHighlightingData.EXEC_COMMAND);
        ATTRIBUTES.put(PhpTokenTypes.IDENTIFIER, PhpHighlightingData.IDENTIFIER);
        ATTRIBUTES.put(PhpTokenTypes.VARIABLE, PhpHighlightingData.VAR);
        ATTRIBUTES.put(PhpTokenTypes.VARIABLE_VARIABLE, PhpHighlightingData.VAR_VAR);
        ATTRIBUTES.put(PhpTokenTypes.ESCAPE_SEQUENCE, PhpHighlightingData.ESCAPE_SEQUENCE);
        ATTRIBUTES.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, PhpHighlightingData.ESCAPE_SEQUENCE);
        ATTRIBUTES.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, PhpHighlightingData.INVALID_ESCAPE_SEQUENCE);
        ATTRIBUTES.put(PhpTokenTypes.UNKNOWN_SYMBOL, PhpHighlightingData.BAD_CHARACTER);
        ATTRIBUTES.put(PhpTokenTypes.PREDEFINED_IDENTIFIER, PhpHighlightingData.PREDEFINED_SYMBOL);
        ATTRIBUTES.put(PhpTokenTypes.ARROW, PhpHighlightingData.OPERATION_SIGN);
        ATTRIBUTES.put(PhpTokenTypes.SCOPE_RESOLUTION, PhpHighlightingData.OPERATION_SIGN);
        PhpFileSyntaxHighlighter.registerPHPDoc();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/highlighter/PhpFileSyntaxHighlighter", "getTokenHighlights"));
    }
}

