/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.highlighter;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.HtmlLexer;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.lexer.RestartableLexer;
import com.intellij.lexer.TokenIterator;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.search.LexerEditorHighlighterLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocLexer;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import com.jetbrains.php.lang.lexer.PhpLexer;
import com.jetbrains.php.lang.lexer.PhpStringLiteralLexer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.lexer._PhpLexer;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class PhpHighlightingLexer
extends LayeredLexer
implements RestartableLexer {
    private static final Collection<String> GENERIC_ARRAYS_NAMES = Set.of("array", "list", "iterable", "non-empty-array", "non-empty-list");
    private static final ThreadLocal<Boolean> ourEnableHtmlLayerOnPhpDocs = ThreadLocal.withInitial(() -> Boolean.TRUE);

    public PhpHighlightingLexer() {
        this(null, null);
    }

    public int getStartState() {
        return 0;
    }

    public boolean isRestartableState(int state) {
        return state == 2 || state == 6 || state == 12;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState, TokenIterator tokenIterator) {
        if (buffer == null) {
            PhpHighlightingLexer.$$$reportNull$$$0(0);
        }
        if (initialState == 12 && tokenIterator.initialTokenIndex() + 1 < tokenIterator.getTokenCount()) {
            FlexLexer flex;
            String heredocTagName = null;
            for (int index = tokenIterator.initialTokenIndex(); index >= 0; --index) {
                if (tokenIterator.getType(index) != PhpTokenTypes.HEREDOC_START || tokenIterator.getState(index + 1) != 16) continue;
                heredocTagName = heredocTagName.substring((heredocTagName = buffer.subSequence(tokenIterator.getStartOffset(index), tokenIterator.getEndOffset(index)).toString()).charAt(0) == '<' ? 3 : 4).trim();
                break;
            }
            if ((flex = ((FlexAdapter)((MergingLexerAdapter)this.myDelegate).getDelegate()).getFlex()) instanceof _PhpLexer) {
                ((_PhpLexer)flex).getHdManager().setCurrentTagName(heredocTagName);
            }
        }
        super.start(buffer, startOffset, endOffset, initialState);
    }

    private static <T> T computeWithDisableHtmlLayersOnPhpDocs(Supplier<T> runnable) {
        Boolean oldValue = ourEnableHtmlLayerOnPhpDocs.get();
        try {
            ourEnableHtmlLayerOnPhpDocs.set(Boolean.FALSE);
            T t = runnable.get();
            return t;
        }
        finally {
            ourEnableHtmlLayerOnPhpDocs.set(oldValue);
        }
    }

    private static void runWithDisableHtmlLayersOnPhpDocs(Runnable runnable) {
        PhpHighlightingLexer.computeWithDisableHtmlLayersOnPhpDocs(() -> {
            runnable.run();
            return null;
        });
    }

    @NotNull
    public static Lexer createLexerEditorHighlighterWithDisabledHtmlLayersOnPhpDocs(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            PhpHighlightingLexer.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            PhpHighlightingLexer.$$$reportNull$$$0(2);
        }
        Lexer lexer = (Lexer)PhpHighlightingLexer.computeWithDisableHtmlLayersOnPhpDocs(() -> {
            EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)project, (VirtualFile)virtualFile);
            return new DelegateLexer((Lexer)new LexerEditorHighlighterLexer(highlighter, false)){

                public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
                    if (buffer == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PhpHighlightingLexer.runWithDisableHtmlLayersOnPhpDocs(() -> super.start(buffer, startOffset, endOffset, initialState));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/php/lang/highlighter/PhpHighlightingLexer$1", "start"));
                }
            };
        });
        if (lexer == null) {
            PhpHighlightingLexer.$$$reportNull$$$0(3);
        }
        return lexer;
    }

    private static boolean endOfDocTagLine(Lexer lexer) {
        return lexer.getTokenType() == PhpDocTokenTypes.DOC_WHITESPACE && lexer.getTokenText().indexOf(10) >= 0;
    }

    public PhpHighlightingLexer(Project project, Lexer baseLexer) {
        super((Lexer)(baseLexer == null ? new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _PhpLexer(true, true, true)), PhpLexer.ourTokensToMerge) : baseLexer));
        LayeredLexer docLexer = PhpHighlightingLexer.isOurHtmlLayerOnPhpDocEnabled() ? new LayeredLexer((Lexer)new MyMergingPhpDocTokensIntoCommentDataLexer((Lexer)new PhpDocLexer())) : new LayeredLexer((Lexer)new PhpDocLexer());
        this.registerSelfStoppingLayer((Lexer)docLexer, new IElementType[]{PhpDocStubElementTypes.DOC_COMMENT}, new IElementType[]{PhpDocTokenTypes.DOC_COMMENT_END});
        if (PhpHighlightingLexer.isOurHtmlLayerOnPhpDocEnabled()) {
            Lexer lexer = PhpHighlightingLexer.getHtmlHighlightingLexer();
            docLexer.registerLayer(lexer, new IElementType[]{PhpDocTokenTypes.DOC_COMMENT_DATA});
        }
        this.registerLayer((Lexer)new PhpStringLiteralLexer(PhpTokenTypes.STRING_LITERAL, 2), new IElementType[]{PhpTokenTypes.STRING_LITERAL});
        this.registerLayer((Lexer)new PhpStringLiteralLexer(PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE, 1), new IElementType[]{PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE});
    }

    private static boolean isOurHtmlLayerOnPhpDocEnabled() {
        return ourEnableHtmlLayerOnPhpDocs.get() == Boolean.TRUE;
    }

    private static Lexer getHtmlHighlightingLexer() {
        return new HtmlLexer(true);
    }

    public IElementType getTokenType() {
        IElementType tokenType = super.getTokenType();
        if (tokenType == PhpDocTokenTypes.DOC_IDENTIFIER) {
            tokenType = PhpDocTokenTypes.DOC_IDENTIFIER_FOR_EDITOR;
        } else if (tokenType == PhpDocTokenTypes.DOC_TAG_NAME) {
            tokenType = PhpDocTokenTypes.DOC_TAG_NAME_FOR_EDITOR;
        }
        return tokenType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/highlighter/PhpHighlightingLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/highlighter/PhpHighlightingLexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexerEditorHighlighterWithDisabledHtmlLayersOnPhpDocs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLexerEditorHighlighterWithDisabledHtmlLayersOnPhpDocs";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyMergingPhpDocTokensIntoCommentDataLexer
    extends MergingLexerAdapter {
        private boolean myInapplicableLine = false;
        private final MergeFunction myMergeFunction = (type, originalLexer) -> {
            IElementType tokenType = originalLexer.getTokenType();
            if (tokenType == PhpDocTokenTypes.DOC_COMMENT_END || tokenType == PhpDocTokenTypes.DOC_VARIABLE || PhpHighlightingLexer.endOfDocTagLine(originalLexer)) {
                this.myInapplicableLine = false;
                return type;
            }
            if (this.myInapplicableLine || !MyMergingPhpDocTokensIntoCommentDataLexer.applicableState(originalLexer.getState(), type) || !MyMergingPhpDocTokensIntoCommentDataLexer.canMergeTokenIntoCommentData(originalLexer)) {
                return type;
            }
            if (MyMergingPhpDocTokensIntoCommentDataLexer.invalidLineStartText(originalLexer.getTokenText())) {
                this.myInapplicableLine = true;
                return type;
            }
            do {
                originalLexer.advance();
            } while (MyMergingPhpDocTokensIntoCommentDataLexer.canMergeTokenIntoCommentData(originalLexer));
            return PhpDocTokenTypes.DOC_COMMENT_DATA;
        };

        private MyMergingPhpDocTokensIntoCommentDataLexer(Lexer original) {
            super(original, TokenSet.EMPTY);
        }

        public MergeFunction getMergeFunction() {
            return this.myMergeFunction;
        }

        private static boolean applicableState(int state, IElementType tokenType) {
            if (state == 8) {
                return true;
            }
            if (state == 2) {
                return tokenType != PhpDocTokenTypes.DOC_TAG_NAME;
            }
            return false;
        }

        private static boolean canMergeTokenIntoCommentData(Lexer originalLexer) {
            IElementType tokenType = originalLexer.getTokenType();
            return tokenType != null && tokenType != PhpDocTokenTypes.DOC_TAG_NAME && tokenType != PhpDocTokenTypes.DOC_LBRACE && tokenType != PhpDocTokenTypes.DOC_LPAREN && tokenType != PhpDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK && tokenType != PhpDocTokenTypes.DOC_LEADING_ASTERISK && !PhpHighlightingLexer.endOfDocTagLine(originalLexer);
        }

        private static boolean invalidLineStartText(String tokenText) {
            return "public".equals(tokenText) || "protected".equals(tokenText) || "private".equals(tokenText) || GENERIC_ARRAYS_NAMES.contains(tokenText);
        }
    }
}

