/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.lexer.managers;

import com.jetbrains.php.lang.lexer._PhpLexer;
import org.jetbrains.annotations.NotNull;

public class ReadingManager {
    static final int END_SEEN = 0;
    static final int SIMPLE_ESCAPE_SEEN = -1;
    static final int EXPR_SUBST_SEEN = -3;
    static final int VARIABLE_SEEN = -4;
    static final int NEW_LINE_SEEN = -5;
    static final char END = '\uffff';
    public static final int HEREDOC_SPACES_LIMIT = 100;
    protected final _PhpLexer lexer;
    private CharSequence zzBuffer;
    private int myLength;
    protected int heredocIndentLength;

    public ReadingManager(@NotNull _PhpLexer lexer) {
        if (lexer == null) {
            ReadingManager.$$$reportNull$$$0(0);
        }
        this.lexer = lexer;
        this.reset();
    }

    protected boolean checkForVariable(int pos) {
        if (this.safeReadAt(pos) == '$') {
            int slashCount = 0;
            int slashPos = pos;
            while (this.safeReadAt(--slashPos) == '\\') {
                ++slashCount;
            }
            if (slashCount % 2 == 1) {
                return false;
            }
            char nextChar = this.safeReadAt(pos + 1);
            return nextChar >= 'a' && nextChar <= 'z' || nextChar >= 'A' && nextChar <= 'Z' || nextChar >= '\u007f' && nextChar <= '\u00ff' || nextChar == '_' || nextChar == '{';
        }
        return false;
    }

    protected boolean checkForNewLine(int pos) {
        return this.safeReadAt(pos) == '\n';
    }

    protected String getHeredocID() {
        return null;
    }

    protected boolean checkForExprSubstitution(int pos) {
        int count = 0;
        for (int i = pos - 1; i >= 0 && this.safeReadAt(i) == '\\'; --i) {
            ++count;
        }
        if (count % 2 == 1) {
            return false;
        }
        return this.safeReadAt(pos) == '{' && this.safeReadAt(pos + 1) == '$';
    }

    boolean checkForSimpleEsc(int pos) {
        char c0 = this.safeReadAt(pos);
        if (c0 != '\\') {
            return false;
        }
        char c1 = this.safeReadAt(pos + 1);
        return c1 == 't' || c1 == 'n' || c1 == 'b' || c1 == 'f' || c1 == 'r' || c1 == '\\' || c1 == 'x' || c1 >= '0' && c1 <= '7';
    }

    protected boolean checkForEndDelimiter(int pos) {
        char c;
        if (this.safeReadAt(pos) != '\n') {
            return false;
        }
        for (int i = this.heredocIndentLength = this.skipSpaces(pos); i < this.getHeredocID().length() + this.heredocIndentLength; ++i) {
            c = this.safeReadAt(pos + 1 + i);
            if (c != '\uffff' && this.getHeredocID().charAt(i - this.heredocIndentLength) == c) continue;
            return false;
        }
        int afterID = pos + 1 + this.getHeredocID().length() + this.heredocIndentLength;
        c = this.safeReadAt(afterID);
        return true;
    }

    private int skipSpaces(int pos) {
        int counter = 0;
        char c = this.safeReadAt(pos + 1);
        while (c == ' ' || c == '\t' && counter < 100) {
            c = this.safeReadAt(pos + ++counter + 1);
        }
        return counter;
    }

    protected void reset() {
        this.zzBuffer = this.lexer.getBuffer();
        this.myLength = this.zzBuffer.length();
    }

    protected char safeReadAt(int pos) {
        return this.canReadAt(pos) ? this.zzBuffer.charAt(this.lexer.getTokenStart() + pos) : (char)'\uffff';
    }

    protected boolean canReadAt(int pos) {
        int zzStartRead = this.lexer.getTokenStart();
        int loc = zzStartRead + pos;
        return 0 <= loc && loc < this.myLength;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/jetbrains/php/lang/lexer/managers/ReadingManager", "<init>"));
    }
}

