/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.classes;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.Attributes;
import com.jetbrains.php.lang.parser.parsing.Namespace;
import com.jetbrains.php.lang.parser.parsing.classes.ClassConstant;
import com.jetbrains.php.lang.parser.parsing.classes.ClassDeclaration;
import com.jetbrains.php.lang.parser.parsing.classes.ClassField;
import com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import com.jetbrains.php.lang.parser.parsing.classes.ClassMethod;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public final class ClassStatementList {
    private static final TokenSet EXPECTED_AFTER_AS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsVISIBILITY_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.IDENTIFIER, PhpTokenTypes.kwFINAL})});
    private static final TokenSet EXPECTED_IN_USE_TRAIT_RULE = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwAS, PhpTokenTypes.kwINSTEADOF});
    public static final TokenSet MODIFIERS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsVISIBILITY_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwFINAL})});

    public static void parse(PhpPsiBuilder builder) {
        while (!builder.eof() && !builder.compare(PhpTokenTypes.chRBRACE)) {
            IElementType result = ClassStatementList.parseStatement(builder);
            if (result != PhpElementTypes.EMPTY_INPUT || ClassStatementList.permissivelyParseClassMemberModifiers(builder)) continue;
            builder.error(PhpParserErrors.unexpected(builder.getTokenType()));
            builder.advanceLexer();
        }
    }

    private static boolean permissivelyParseClassMemberModifiers(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.kwVAR) || ClassMemberModifiers.mayBeReadonlyKeyword(builder)) {
            ClassMemberModifiers.parseVariableModifiers(builder);
            builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("expected.property", new Object[0])));
            return true;
        }
        if (builder.compare(PhpTokenTypes.tsMODIFIERS)) {
            ClassMemberModifiers.parseVariableModifiers(builder);
            builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("property.or.function", new Object[0])));
            return true;
        }
        return false;
    }

    private static IElementType parseStatement(PhpPsiBuilder builder) {
        IElementType result = ClassStatementList.parseUse(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = ClassStatementList.parseEnumCase(builder);
            if (result != PhpElementTypes.EMPTY_INPUT) {
                return result;
            }
            result = ClassConstant.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT && (result = ClassField.parse(builder)) == PhpElementTypes.EMPTY_INPUT) {
                result = ClassMethod.parse(builder);
            }
        }
        return result;
    }

    private static IElementType parseEnumCase(PhpPsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        Attributes.parseAttributesList(builder);
        if (!builder.compareAndEat(PhpTokenTypes.kwCASE)) {
            mark.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        int identifiersCount = ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, b -> {
            IElementType result = PhpElementTypes.EMPTY_INPUT;
            if (ClassConstant.parseConstantName(builder, true)) {
                result = PhpTokenTypes.IDENTIFIER;
            }
            if (builder.compare(PhpTokenTypes.opASGN)) {
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("identifier", new Object[0])));
                }
                result = PhpTokenTypes.IDENTIFIER;
                builder.advanceLexer();
                IElementType expression = Expression.parse(builder);
                if (expression == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("initializer", new Object[0])));
                }
            }
            return result;
        }, false);
        if (identifiersCount <= 0) {
            builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("identifier", new Object[0])));
        }
        builder.match(PhpTokenTypes.opSEMICOLON);
        mark.done((IElementType)PhpStubElementTypes.ENUM_CASE);
        return PhpStubElementTypes.ENUM_CASE;
    }

    public static IElementType parseUse(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwUSE)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker useList = builder.mark();
        builder.advanceLexer();
        do {
            PsiBuilder.Marker use = builder.mark();
            IElementType result = ClassReference.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("class.reference", new Object[0])));
            }
            use.done((IElementType)PhpStubElementTypes.USE);
        } while (builder.compareAndEat(PhpTokenTypes.opCOMMA));
        if (builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
            while (!builder.compareAndEat(PhpTokenTypes.chRBRACE) && !builder.eof()) {
                PsiBuilder.Marker rule = builder.mark();
                PsiBuilder.Marker method = builder.mark();
                PsiBuilder.Marker classR = builder.mark();
                Namespace.parseReference(builder);
                builder.match(PhpTokenTypes.IDENTIFIER);
                if (builder.compare(PhpTokenTypes.SCOPE_RESOLUTION)) {
                    classR.done(PhpElementTypes.CLASS_REFERENCE);
                    builder.advanceLexer();
                    builder.match(PhpTokenTypes.IDENTIFIER);
                } else {
                    classR.drop();
                }
                method.done(PhpElementTypes.METHOD_REFERENCE);
                if (builder.compareAndEat(PhpTokenTypes.kwAS)) {
                    boolean vis = builder.compareAndEat(MODIFIERS);
                    boolean name = builder.compareAndEat(PhpTokenTypes.IDENTIFIER);
                    if (!vis && !name) {
                        builder.error(PhpParserErrors.expected(EXPECTED_AFTER_AS));
                    }
                } else if (builder.compareAndEat(PhpTokenTypes.kwINSTEADOF)) {
                    ClassDeclaration.parseClassNamesList(builder);
                } else {
                    builder.error(PhpParserErrors.expected(EXPECTED_IN_USE_TRAIT_RULE));
                }
                while (!(builder.compare(PhpTokenTypes.opSEMICOLON) || builder.compare(PhpTokenTypes.chRBRACE) || builder.eof())) {
                    builder.advanceLexer();
                }
                builder.match(PhpTokenTypes.opSEMICOLON);
                rule.done((IElementType)PhpStubElementTypes.TRAIT_USE_RULE);
            }
        } else {
            builder.match(PhpTokenTypes.opSEMICOLON);
        }
        useList.done((IElementType)PhpStubElementTypes.USE_LIST);
        return PhpStubElementTypes.USE_LIST;
    }
}

