/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import com.jetbrains.php.lang.parser.parsing.expressions.TernaryExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.primary.Array;
import com.jetbrains.php.lang.parser.parsing.expressions.primary.NewExpression;
import org.jetbrains.annotations.NotNull;

public final class AssignmentExpression {
    @NotNull
    private static final TokenSet CLOSING_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opSEMICOLON, PhpTokenTypes.chRPAREN, PhpTokenTypes.chRBRACKET});
    public static final ParserPart ASSIGNMENT_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            if (AssignmentExpression.parseArrayLiteral(builder, false) != PhpElementTypes.EMPTY_INPUT) {
                return PhpStubElementTypes.VARIABLE;
            }
            PsiBuilder.Marker marker = builder.mark();
            if (builder.compareAndEat(PhpTokenTypes.opBIT_AND)) {
                Variable.parse(builder);
            } else {
                Expression.parse(builder);
            }
            if (builder.compareAndEat(PhpTokenTypes.opHASH_ARRAY)) {
                marker.drop();
            } else {
                marker.rollbackTo();
            }
            builder.compareAndEat(PhpTokenTypes.opBIT_AND);
            marker = builder.mark();
            IElementType result = Variable.parse(builder);
            if (PhpElementTypes.ASSIGNABLE.contains(result)) {
                marker.done(result);
            } else {
                marker.drop();
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    return PhpElementTypes.EMPTY_EXPRESSION;
                }
                builder.error(PhpFrontBackBundle.message("parsing.error.expression.not.assignable", new Object[0]));
            }
            return result;
        }
    };

    private static IElementType parseArrayPair(PhpPsiBuilder builder) {
        IElementType res;
        if (builder.compareAndEat(PhpTokenTypes.opBIT_AND)) {
            Expression.parse(builder);
            return PhpStubElementTypes.VARIABLE;
        }
        boolean elipsis = builder.compareAndEat(PhpTokenTypes.opVARIADIC);
        IElementType iElementType = res = builder.compare(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwLIST, PhpTokenTypes.chLBRACKET})) ? AssignmentExpression.parseArrayLiteral(builder, false) : Expression.parse(builder);
        if (elipsis) {
            return res;
        }
        if (builder.compareAndEat(PhpTokenTypes.opHASH_ARRAY)) {
            if (builder.compareAndEat(PhpTokenTypes.opBIT_AND)) {
                Expression.parse(builder);
                return PhpStubElementTypes.VARIABLE;
            }
            return builder.compare(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwLIST, PhpTokenTypes.chLBRACKET})) ? AssignmentExpression.parseArrayLiteral(builder, false) : Expression.parse(builder);
        }
        return res;
    }

    public static IElementType parseArrayLiteral(PhpPsiBuilder builder, boolean wrapInValues) {
        if (wrapInValues && builder.compare(PhpTokenTypes.chLBRACKET)) {
            return Array.parse(builder);
        }
        PsiBuilder.Marker mark = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwLIST)) {
            builder.match(PhpTokenTypes.chLPAREN);
            if (wrapInValues) {
                ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, Array.PART.parse(builder), Array.PART, true, true);
            } else {
                AssignmentExpression.parseArrayPairList(builder);
            }
            builder.match(PhpTokenTypes.chRPAREN);
        } else if (builder.compareAndEat(PhpTokenTypes.chLBRACKET)) {
            AssignmentExpression.parseArrayPairList(builder);
            builder.match(PhpTokenTypes.chRBRACKET);
        } else {
            mark.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        mark.drop();
        return PhpElementTypes.ARRAY_CREATION_EXPRESSION;
    }

    private static void parseArrayPairList(PhpPsiBuilder builder) {
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, AssignmentExpression.parseArrayPair(builder), AssignmentExpression::parseArrayPair, false, true);
    }

    public static IElementType parse(PhpPsiBuilder builder) {
        IElementType result = AssignmentExpression.parseWithoutPriority(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            return result;
        }
        PsiBuilder.Marker marker = builder.mark();
        result = TernaryExpression.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT && builder.compare(PhpTokenTypes.tsASGN_OPS)) {
            IElementType type = builder.getTokenType() != PhpTokenTypes.opASGN ? PhpElementTypes.SELF_ASSIGNMENT_EXPRESSION : (result == PhpElementTypes.ARRAY_CREATION_EXPRESSION ? PhpElementTypes.MULTIASSIGNMENT_EXPRESSION : PhpElementTypes.ASSIGNMENT_EXPRESSION);
            builder.advanceLexer();
            PsiBuilder.Marker expression = builder.mark();
            result = AssignmentExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                expression.drop();
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            } else if (type != PhpElementTypes.MULTIASSIGNMENT_EXPRESSION) {
                expression.drop();
            } else {
                expression.done(PhpElementTypes.EXPRESSION);
            }
            marker.done(type);
            return type;
        }
        marker.drop();
        return result;
    }

    public static IElementType parseWithoutPriority(PhpPsiBuilder builder) {
        IElementType type;
        PsiBuilder.Marker marker = builder.mark();
        if (builder.compare(PhpTokenTypes.kwLIST)) {
            AssignmentExpression.parseArrayLiteral(builder, true);
            builder.match(PhpTokenTypes.opASGN);
            PsiBuilder.Marker value = builder.mark();
            IElementType result = TernaryExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                value.drop();
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            } else {
                value.done(PhpElementTypes.EXPRESSION);
            }
            marker.done(PhpElementTypes.MULTIASSIGNMENT_EXPRESSION);
            return PhpElementTypes.MULTIASSIGNMENT_EXPRESSION;
        }
        if (!builder.compare(Variable.START_TOKENS)) {
            marker.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
        IElementType result = Variable.parseAssignable(builder);
        if (result == PhpElementTypes.EMPTY_INPUT || !builder.compare(PhpTokenTypes.tsASGN_OPS) && !builder.compare(CLOSING_TOKENS)) {
            marker.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        marker.done(result);
        marker = marker.precede();
        while ((type = builder.getTokenType()) == PhpTokenTypes.opASGN || PhpTokenTypes.tsASGN_OPS.contains(type) && !builder.eof()) {
            builder.advanceLexer();
            if (builder.compare(PhpTokenTypes.opBIT_AND)) {
                builder.advanceLexer();
                if (builder.compare(PhpTokenTypes.kwNEW)) {
                    PsiBuilder.Marker newExpr = builder.mark();
                    result = NewExpression.parse(builder);
                    newExpr.done(result);
                    result = PhpElementTypes.ASSIGNMENT_EXPRESSION;
                    marker.done(result);
                    marker = marker.precede();
                    continue;
                }
                PsiBuilder.Marker variable = builder.mark();
                IElementType var = Variable.parse(builder);
                if (var == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("variable1", new Object[0])));
                    variable.drop();
                } else {
                    variable.done(var);
                }
                result = PhpElementTypes.ASSIGNMENT_EXPRESSION;
                marker.done(result);
                marker = marker.precede();
                continue;
            }
            if (type == PhpTokenTypes.opASGN) {
                result = TernaryExpression.parse(builder);
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.getExpressionExpectedMessage());
                }
                result = PhpElementTypes.ASSIGNMENT_EXPRESSION;
                marker.done(result);
                marker = marker.precede();
                continue;
            }
            result = TernaryExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            result = PhpElementTypes.SELF_ASSIGNMENT_EXPRESSION;
            marker.done(result);
            marker = marker.precede();
        }
        marker.drop();
        return result;
    }

    public static void parseAssignmentList(PhpPsiBuilder builder) {
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, ASSIGNMENT_PART.parse(builder), ASSIGNMENT_PART, false);
    }
}

