/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.expressions.StaticScalar;

public final class StaticArrayPairList {
    private static final ParserPart PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            PsiBuilder.Marker arrayElement = builder.mark();
            PsiBuilder.Marker staticArrayPair = builder.mark();
            IElementType result = StaticScalar.parse(builder);
            if (result != PhpElementTypes.EMPTY_INPUT) {
                boolean hash_array_element = false;
                if (builder.compare(PhpTokenTypes.opHASH_ARRAY)) {
                    staticArrayPair.done(PhpElementTypes.ARRAY_KEY);
                    hash_array_element = true;
                    builder.advanceLexer();
                    staticArrayPair = builder.mark();
                    if (StaticScalar.parse(builder) == PhpElementTypes.EMPTY_INPUT) {
                        builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("static.value", new Object[0])));
                    }
                }
                staticArrayPair.done(PhpElementTypes.ARRAY_VALUE);
                if (hash_array_element) {
                    arrayElement.done(PhpElementTypes.HASH_ARRAY_ELEMENT);
                } else {
                    arrayElement.drop();
                }
            } else {
                staticArrayPair.rollbackTo();
                arrayElement.drop();
            }
            return result;
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        IElementType result = PART.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, result, PART, true);
        }
        return result;
    }
}

