/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.functions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.Attributes;
import com.jetbrains.php.lang.parser.parsing.StatementList;
import com.jetbrains.php.lang.parser.parsing.TypeDeclaration;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import com.jetbrains.php.lang.parser.parsing.functions.IsReference;
import com.jetbrains.php.lang.parser.parsing.functions.ParameterList;

public final class Function {
    private static final ParserPart SOFT_VARIABLE_REFERENCE_PARSER_PART = new SoftVariableReferenceParserPart();

    public static IElementType parse(PhpPsiBuilder builder, boolean allowClosure) {
        PsiBuilder.Marker function = builder.mark();
        Attributes.parseAttributesList(builder);
        builder.compareAndEat(PhpTokenTypes.kwSTATIC);
        if (!builder.compare(PhpTokenTypes.kwFUNCTION)) {
            if (allowClosure && builder.compareFnWithoutRemapping()) {
                builder.remapBackToFnIfNeeded();
                IElementType res = Function.parseShortArrowClosure(builder);
                if (res != PhpElementTypes.EMPTY_INPUT) {
                    function.done(res);
                    return res;
                }
            }
            function.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        builder.advanceLexer();
        Attributes.parseAttributesList(builder);
        IsReference.parse(builder);
        if (builder.compare(PhpTokenTypes.tsEXIT) || builder.compare(PhpTokenTypes.kwCLONE)) {
            builder.remapToIdentifier();
        }
        if (!builder.compareAndEat(PhpTokenTypes.IDENTIFIER) && !allowClosure) {
            function.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        if (builder.compareAndEat(PhpTokenTypes.chLPAREN)) {
            ParameterList.parse(builder, false);
            builder.match(PhpTokenTypes.chRPAREN);
        } else {
            builder.match(PhpTokenTypes.chLPAREN);
        }
        PsiBuilder.Marker use = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwUSE)) {
            if (builder.compareAndEat(PhpTokenTypes.chLPAREN)) {
                int varsCount = ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, SOFT_VARIABLE_REFERENCE_PARSER_PART, true);
                if (varsCount == 0) {
                    builder.error(PhpParserErrors.expected(PhpTokenTypes.VARIABLE));
                }
                builder.match(PhpTokenTypes.chRPAREN);
            } else {
                builder.error(PhpParserErrors.expected(PhpTokenTypes.chLPAREN));
            }
            use.done((IElementType)PhpStubElementTypes.USE_LIST);
        } else {
            use.drop();
        }
        Function.parseReturnType(builder);
        if (builder.compare(PhpTokenTypes.chLBRACE)) {
            StatementList.parseFast(builder);
        } else {
            builder.match(PhpTokenTypes.chLBRACE);
        }
        function.done((IElementType)PhpStubElementTypes.FUNCTION);
        return PhpStubElementTypes.FUNCTION;
    }

    private static IElementType parseShortArrowClosure(PhpPsiBuilder builder) {
        IElementType parse;
        builder.advanceLexer();
        IsReference.parse(builder);
        builder.match(PhpTokenTypes.chLPAREN);
        ParameterList.parse(builder, false);
        builder.match(PhpTokenTypes.chRPAREN);
        Function.parseReturnType(builder);
        if (!builder.compareAndEat(PhpTokenTypes.opHASH_ARRAY)) {
            if (builder.arrowFunctionSyntaxSupported()) {
                builder.error(PhpParserErrors.expected(PhpTokenTypes.opHASH_ARRAY));
            } else {
                return PhpElementTypes.EMPTY_INPUT;
            }
        }
        if ((parse = Expression.parse(builder)) == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("expression1", new Object[0])));
        }
        return PhpStubElementTypes.FUNCTION;
    }

    public static void parseReturnType(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.opCOLON)) {
            Function.parseReturnTypeElement(builder);
        }
    }

    public static IElementType parseReturnTypeElement(PhpPsiBuilder builder) {
        IElementType type = TypeDeclaration.parseType(builder, PhpElementTypes.RETURN_TYPE);
        if (type == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("return.type", new Object[0])));
            return PhpElementTypes.EMPTY_INPUT;
        }
        return type;
    }

    private static class SoftVariableReferenceParserPart
    implements ParserPart {
        private SoftVariableReferenceParserPart() {
        }

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            if (builder.compare(PhpTokenTypes.chRPAREN)) {
                return PhpElementTypes.EMPTY_INPUT;
            }
            builder.compareAndEat(PhpTokenTypes.opBIT_AND);
            PsiBuilder.Marker var = builder.mark();
            IElementType result = Variable.parse(builder);
            if (result == PhpStubElementTypes.VARIABLE) {
                var.done(result);
                return result;
            }
            var.rollbackTo();
            builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("variable1", new Object[0])));
            PsiBuilder.Marker identifier = builder.mark();
            if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
                identifier.done(PhpElementTypes.CONSTANT_REF);
                return PhpElementTypes.CONSTANT_REF;
            }
            identifier.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
    }
}

