/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public final class GlobalStatement {
    private static final TokenSet VAR___DOLLAR = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE, PhpTokenTypes.DOLLAR});
    private static final ParserPart GLOBAL_VAR_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            if (!builder.compare(VAR___DOLLAR)) {
                return PhpElementTypes.EMPTY_INPUT;
            }
            PsiBuilder.Marker variable = builder.mark();
            if (builder.compareAndEat(PhpTokenTypes.VARIABLE)) {
                variable.done((IElementType)PhpStubElementTypes.VARIABLE);
                return PhpStubElementTypes.VARIABLE;
            }
            PsiBuilder.Marker dollar = builder.mark();
            builder.match(PhpTokenTypes.DOLLAR);
            if (builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
                dollar.drop();
                Expression.parse(builder);
                builder.match(PhpTokenTypes.chRBRACE);
                variable.done((IElementType)PhpStubElementTypes.VARIABLE);
                return PhpStubElementTypes.VARIABLE;
            }
            dollar.rollbackTo();
            Variable.parse(builder);
            variable.done((IElementType)PhpStubElementTypes.VARIABLE);
            return PhpStubElementTypes.VARIABLE;
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        if (!builder.compareAndEat(PhpTokenTypes.kwGLOBAL)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker statement = builder.mark();
        GlobalStatement.parseGlobalVarList(builder);
        if (!builder.compare(PhpTokenTypes.PHP_CLOSING_TAG)) {
            builder.match(PhpTokenTypes.opSEMICOLON);
        }
        statement.done(PhpElementTypes.GLOBAL);
        return PhpElementTypes.GLOBAL;
    }

    private static void parseGlobalVarList(PhpPsiBuilder builder) {
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, GLOBAL_VAR_PART.parse(builder), GLOBAL_VAR_PART, false);
    }
}

