/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.StatementList;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;

public final class TryStatement {
    public static final ParserPart PARSER_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            IElementType result = ClassReference.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("exception.class", new Object[0])));
            }
            return result;
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwTRY)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (builder.compare(PhpTokenTypes.chLBRACE)) {
            StatementList.parseFast(builder);
        } else {
            builder.match(PhpTokenTypes.chLBRACE);
        }
        int catchCount = TryStatement.parseCatchClauses(builder);
        PsiBuilder.Marker _finally = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwFINALLY)) {
            if (builder.compare(PhpTokenTypes.chLBRACE)) {
                StatementList.parseFast(builder);
            } else {
                builder.error(PhpParserErrors.expected("{"));
            }
            _finally.done(PhpElementTypes.FINALLY);
        } else {
            _finally.drop();
            if (catchCount == 0) {
                builder.error(PhpParserErrors.expected(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwCATCH, PhpTokenTypes.kwFINALLY})));
            }
        }
        statement.done(PhpElementTypes.TRY);
        return PhpElementTypes.TRY;
    }

    private static int parseCatchClauses(PhpPsiBuilder builder) {
        int i = 0;
        while (TryStatement.parseCatchClause(builder) != PhpElementTypes.EMPTY_INPUT) {
            ++i;
        }
        return i;
    }

    private static IElementType parseCatchClause(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwCATCH)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker catchClause = builder.mark();
        builder.advanceLexer();
        builder.match(PhpTokenTypes.chLPAREN);
        if (ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, PARSER_PART.parse(builder), PARSER_PART, PhpTokenTypes.opBIT_OR, true, false) < 0) {
            builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("exception.class", new Object[0])));
        }
        if (builder.compare(PhpTokenTypes.VARIABLE)) {
            PsiBuilder.Marker variable = builder.mark();
            builder.advanceLexer();
            variable.done((IElementType)PhpStubElementTypes.VARIABLE);
        }
        builder.match(PhpTokenTypes.chRPAREN);
        if (builder.compare(PhpTokenTypes.chLBRACE)) {
            StatementList.parseFast(builder);
        } else {
            builder.error(PhpParserErrors.expected("{"));
        }
        catchClause.done(PhpElementTypes.CATCH);
        return PhpElementTypes.CATCH;
    }
}

