/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayFactory;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import org.jetbrains.annotations.Nullable;

public interface PhpPropertyHook
extends PhpNamedElement,
Method {
    public static final Condition<PsiElement> IS_GET_HOOK = it -> it instanceof PhpPropertyHook && ((PhpPropertyHook)it).getHookType() == PhpPropertyHookType.GET;
    public static final Condition<PsiElement> IS_SET_HOOK = it -> it instanceof PhpPropertyHook && ((PhpPropertyHook)it).getHookType() == PhpPropertyHookType.SET;
    public static final Condition<PsiElement> INSTANCEOF = use -> use instanceof PhpPropertyHook;
    public static final ArrayFactory<PhpPropertyHook> ARRAY_FACTORY = count -> count > 0 ? new PhpPropertyHook[count] : new PhpPropertyHook[]{};

    public PhpPropertyHookType getHookType();

    public boolean isShort();

    @Nullable
    public Field getContainingField();

    @Nullable
    public ParameterList getParameterList();

    public static enum PhpPropertyHookType {
        GET("get", "return $this->%s;"),
        SET("set", "$this->%s = $value;");

        public final String keyWord;
        public final String defaultBody;

        private PhpPropertyHookType(String keyWord, String defaultBody) {
            this.keyWord = keyWord;
            this.defaultBody = defaultBody;
        }
    }
}

