/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptCoreBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\"B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u001b\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0019H\u0016J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u001f\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010 j\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "", "dialect", "Lcom/intellij/lang/javascript/JSLanguageDialect;", "dialectOptionHolder", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "resourceId", "", "descriptionId", "<init>", "(Ljava/lang/String;ILcom/intellij/lang/javascript/JSLanguageDialect;Lcom/intellij/lang/javascript/DialectOptionHolder;Ljava/lang/String;Ljava/lang/String;)V", "getDialect", "()Lcom/intellij/lang/javascript/JSLanguageDialect;", "getDialectOptionHolder", "()Lcom/intellij/lang/javascript/DialectOptionHolder;", "ES5", "ES6", "FLOW", "labelPointer", "Ljava/util/function/Supplier;", "descriptionPointer", "id", "getId", "()Ljava/lang/String;", "description", "Lorg/jetbrains/annotations/Nls;", "getDescription", "toString", "isAtLeast", "", "level", "isES6Compatible", "()Z", "isXmlEnabled", "Companion", "intellij.javascript.psi.impl"})
public final class JSLanguageLevel
extends Enum<JSLanguageLevel> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final JSLanguageDialect dialect;
    @NotNull
    private final DialectOptionHolder dialectOptionHolder;
    @NotNull
    private final Supplier<String> labelPointer;
    @NotNull
    private final Supplier<String> descriptionPointer;
    @JvmField
    @NotNull
    public static final Map<String, JSLanguageLevel> OBSOLETE_LEVELS;
    @JvmField
    @NotNull
    public static final JSLanguageLevel DEFAULT;
    public static final /* enum */ JSLanguageLevel ES5;
    public static final /* enum */ JSLanguageLevel ES6;
    public static final /* enum */ JSLanguageLevel FLOW;
    private static final /* synthetic */ JSLanguageLevel[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private JSLanguageLevel(@PropertyKey(resourceBundle="messages.JavaScriptCoreBundle") JSLanguageDialect dialect, @PropertyKey(resourceBundle="messages.JavaScriptCoreBundle") DialectOptionHolder dialectOptionHolder, String resourceId, String descriptionId) {
        this.dialect = dialect;
        this.dialectOptionHolder = dialectOptionHolder;
        this.labelPointer = JavaScriptCoreBundle.messagePointer(resourceId, new Object[0]);
        String string = descriptionId;
        this.descriptionPointer = string != null ? JavaScriptCoreBundle.messagePointer(string, new Object[0]) : JSLanguageLevel::descriptionPointer$lambda$0;
    }

    @NotNull
    public final JSLanguageDialect getDialect() {
        return this.dialect;
    }

    @NotNull
    public final DialectOptionHolder getDialectOptionHolder() {
        return this.dialectOptionHolder;
    }

    @NotNull
    public final String getId() {
        return super.toString();
    }

    @NotNull
    public final String getDescription() {
        String string = this.descriptionPointer.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.labelPointer.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    public final boolean isAtLeast(@NotNull JSLanguageLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        if (level == this) {
            return true;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1 -> false;
            case 2 -> ES5.isAtLeast(level);
            case 3 -> ES6.isAtLeast(level);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean isES6Compatible() {
        return this.isAtLeast(ES6);
    }

    public final boolean isXmlEnabled() {
        return this.dialect.getOptionHolder().hasFeature(JSLanguageFeature.E4X);
    }

    public static JSLanguageLevel[] values() {
        return (JSLanguageLevel[])$VALUES.clone();
    }

    public static JSLanguageLevel valueOf(String value) {
        return Enum.valueOf(JSLanguageLevel.class, value);
    }

    @NotNull
    public static EnumEntries<JSLanguageLevel> getEntries() {
        return $ENTRIES;
    }

    private static final String descriptionPointer$lambda$0() {
        return "";
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageLevel ofDialect(@Nullable JSLanguageDialect dialect) {
        return Companion.ofDialect(dialect);
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageLevel ofDialectOptionHolder(@Nullable DialectOptionHolder dialect) {
        return Companion.ofDialectOptionHolder(dialect);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageLevel ofId(@Nullable String id) {
        return Companion.ofId(id);
    }

    @NotNull
    public static final List<JSLanguageLevel> getVisibleLevels() {
        return Companion.getVisibleLevels();
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageLevel getLevelForJSX() {
        return Companion.getLevelForJSX();
    }

    static {
        ES5 = new JSLanguageLevel(JavascriptLanguage.INSTANCE, DialectOptionHolder.JS_1_5, "js.language.version.combo.es5", null);
        ES6 = new JSLanguageLevel(JavaScriptSupportLoader.ECMA_SCRIPT_6, JavaScriptSupportLoader.ECMA_SCRIPT_6.getOptionHolder(), "js.language.version.combo.es6", "js.language.version.combo.es6.description");
        FLOW = new JSLanguageLevel(JavaScriptSupportLoader.FLOW_JS, JavaScriptSupportLoader.FLOW_JS.getOptionHolder(), "js.language.version.combo.flow", "js.language.version.combo.flow.description");
        $VALUES = jSLanguageLevelArray = new JSLanguageLevel[]{JSLanguageLevel.ES5, JSLanguageLevel.ES6, JSLanguageLevel.FLOW};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"JS_1_5", (Object)((Object)ES5)), TuplesKt.to((Object)"JS_1_6", (Object)((Object)ES6)), TuplesKt.to((Object)"JS_1_7", (Object)((Object)ES6)), TuplesKt.to((Object)"JS_1_8", (Object)((Object)ES6)), TuplesKt.to((Object)"JS_1_8_5", (Object)((Object)ES6)), TuplesKt.to((Object)"E4X", (Object)((Object)ES6)), TuplesKt.to((Object)"JSX", (Object)((Object)ES6)), TuplesKt.to((Object)"NASHORN", (Object)((Object)ES6))};
        OBSOLETE_LEVELS = MapsKt.mapOf((Pair[])pairArray);
        DEFAULT = ES6;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0007J\b\u0010\u0015\u001a\u00020\u0007H\u0007R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00118FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0003\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/dialects/JSLanguageLevel$Companion;", "", "<init>", "()V", "OBSOLETE_LEVELS", "", "", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "DEFAULT", "ofDialect", "dialect", "Lcom/intellij/lang/javascript/JSLanguageDialect;", "ofDialectOptionHolder", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "ofId", "id", "visibleLevels", "", "getVisibleLevels$annotations", "getVisibleLevels", "()Ljava/util/List;", "getLevelForJSX", "intellij.javascript.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nJSLanguageLevel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageLevel.kt\ncom/intellij/lang/javascript/dialects/JSLanguageLevel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n295#2,2:123\n295#2,2:125\n295#2,2:127\n*S KotlinDebug\n*F\n+ 1 JSLanguageLevel.kt\ncom/intellij/lang/javascript/dialects/JSLanguageLevel$Companion\n*L\n100#1:123,2\n104#1:125,2\n110#1:127,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final JSLanguageLevel ofDialect(@Nullable JSLanguageDialect dialect) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = (Iterable)JSLanguageLevel.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JSLanguageLevel it = (JSLanguageLevel)((Object)element$iv);
                    boolean bl = false;
                    if (!(it.getDialect() == dialect)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @JvmStatic
        @Nullable
        public final JSLanguageLevel ofDialectOptionHolder(@Nullable DialectOptionHolder dialect) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = (Iterable)JSLanguageLevel.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JSLanguageLevel it = (JSLanguageLevel)((Object)element$iv);
                    boolean bl = false;
                    if (!(it.getDialectOptionHolder() == dialect)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @JvmStatic
        @NotNull
        public final JSLanguageLevel ofId(@Nullable String id) {
            JSLanguageLevel jSLanguageLevel;
            Object v0;
            block3: {
                if (id == null) {
                    return DEFAULT;
                }
                Iterable $this$firstOrNull$iv = (Iterable)JSLanguageLevel.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JSLanguageLevel it = (JSLanguageLevel)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((jSLanguageLevel = (JSLanguageLevel)v0) == null) {
                jSLanguageLevel = OBSOLETE_LEVELS.getOrDefault(id, DEFAULT);
            }
            return jSLanguageLevel;
        }

        @NotNull
        public final List<JSLanguageLevel> getVisibleLevels() {
            return (List)JSLanguageLevel.getEntries();
        }

        @JvmStatic
        public static /* synthetic */ void getVisibleLevels$annotations() {
        }

        @JvmStatic
        @NotNull
        public final JSLanguageLevel getLevelForJSX() {
            return ES6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JSLanguageLevel.values().length];
            try {
                nArray[JSLanguageLevel.ES5.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSLanguageLevel.ES6.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSLanguageLevel.FLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

