/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.runtime.UnixPathUtil;
import com.intellij.docker.remote.run.target.DockerEnvironment;
import com.intellij.docker.remote.run.target.configuration.DockerRunOptionsSubstitutions;
import com.intellij.docker.remote.run.target.configuration.DockerTargetEnvironmentConfiguration;
import com.intellij.docker.remote.run.target.prepare.BuildImageOperation;
import com.intellij.docker.remote.run.target.prepare.PrepareImageOperation;
import com.intellij.docker.remote.run.target.prepare.PullImageOperation;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.Platform;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.target.BaseTargetEnvironmentRequest;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.value.DeferredLocalTargetValue;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class DockerRemoteRequest
extends BaseTargetEnvironmentRequest {
    private final RemoteDockerRuntime myDocker;
    private final DockerTargetEnvironmentConfiguration myTargetConfiguration;
    private final Map<String, DockerTargetVolume> myVolumes;
    private final List<DockerVolumesFrom> myVolumesFromList;
    private String myVolumesRoot;
    private TargetEnvironmentRequest.Volume myDefaultVolume;
    private boolean mySaveFilesBeforeStartingProcess;
    @Nullable
    private String myRunCliOptions;
    @Nullable
    private Map<String, String> myEnvironmentVariables;

    public DockerRemoteRequest(RemoteDockerRuntime docker, DockerTargetEnvironmentConfiguration config) {
        this.myVolumes = new HashMap<String, DockerTargetVolume>();
        this.myVolumesFromList = new ArrayList<DockerVolumesFrom>();
        this.mySaveFilesBeforeStartingProcess = false;
        this.myDocker = docker;
        this.myTargetConfiguration = config;
    }

    private DockerRemoteRequest(RemoteDockerRuntime docker, DockerTargetEnvironmentConfiguration config, @NotNull Set<TargetEnvironment.UploadRoot> uploadVolumes, @NotNull Set<TargetEnvironment.DownloadRoot> downloadVolumes, @NotNull Set<TargetEnvironment.TargetPortBinding> targetPortBindings, @NotNull Set<TargetEnvironment.LocalPortBinding> localPortBindings) {
        if (uploadVolumes == null) {
            DockerRemoteRequest.$$$reportNull$$$0(0);
        }
        if (downloadVolumes == null) {
            DockerRemoteRequest.$$$reportNull$$$0(1);
        }
        if (targetPortBindings == null) {
            DockerRemoteRequest.$$$reportNull$$$0(2);
        }
        if (localPortBindings == null) {
            DockerRemoteRequest.$$$reportNull$$$0(3);
        }
        super(uploadVolumes, downloadVolumes, targetPortBindings, localPortBindings);
        this.myVolumes = new HashMap<String, DockerTargetVolume>();
        this.myVolumesFromList = new ArrayList<DockerVolumesFrom>();
        this.mySaveFilesBeforeStartingProcess = false;
        this.myDocker = docker;
        this.myTargetConfiguration = config;
    }

    @NotNull
    public TargetEnvironmentRequest duplicate() {
        return new DockerRemoteRequest(this.myDocker, this.myTargetConfiguration, new HashSet<TargetEnvironment.UploadRoot>(this.getUploadVolumes()), new HashSet<TargetEnvironment.DownloadRoot>(this.getDownloadVolumes()), new HashSet<TargetEnvironment.TargetPortBinding>(this.getTargetPortBindings()), new HashSet<TargetEnvironment.LocalPortBinding>(this.getLocalPortBindings()));
    }

    List<DockerVolumeBinding> prepareAgentVolumes(TargetProgressIndicator indicator) throws IOException {
        indicator.addSystemLine(DockerBundle.message((String)"progress.text.preparing.volumes", (Object[])new Object[0]));
        LinkedList<DockerVolumeBinding> result2 = new LinkedList<DockerVolumeBinding>();
        for (DockerTargetVolume next : this.myVolumes.values()) {
            result2.addAll(next.setupVolumes(indicator));
        }
        return result2;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = this.myTargetConfiguration.getValues().getTargetPlatform();
        if (targetPlatform == null) {
            DockerRemoteRequest.$$$reportNull$$$0(4);
        }
        return targetPlatform;
    }

    @NotNull
    public DockerTargetEnvironmentConfiguration getConfiguration() {
        DockerTargetEnvironmentConfiguration dockerTargetEnvironmentConfiguration = this.myTargetConfiguration;
        if (dockerTargetEnvironmentConfiguration == null) {
            DockerRemoteRequest.$$$reportNull$$$0(5);
        }
        return dockerTargetEnvironmentConfiguration;
    }

    public RemoteDockerRuntime getDocker() {
        return this.myDocker;
    }

    @NotNull
    private TargetEnvironmentRequest.Volume createTempVolume() {
        String safeRemoteRootPath = this.getRemoteAllVolumesRoot() + "/" + (this.myVolumes.size() + 1) + "/";
        TargetEnvironmentRequest.Volume volume2 = this.myVolumes.computeIfAbsent(safeRemoteRootPath, root -> new DockerTargetVolume(this, (String)root, true));
        if (volume2 == null) {
            DockerRemoteRequest.$$$reportNull$$$0(6);
        }
        return volume2;
    }

    @NotNull
    public TargetEnvironmentRequest.Volume getDefaultVolume() {
        if (this.myDefaultVolume == null) {
            this.myDefaultVolume = this.createTempVolume();
        }
        TargetEnvironmentRequest.Volume volume2 = this.myDefaultVolume;
        if (volume2 == null) {
            DockerRemoteRequest.$$$reportNull$$$0(7);
        }
        return volume2;
    }

    @NotNull
    public TargetEnvironment prepareEnvironment(@NotNull TargetProgressIndicator progressIndicator) throws com.intellij.execution.ExecutionException {
        DockerEnvironment dockerEnvironment;
        DockerAgentImage agentImage;
        if (progressIndicator == null) {
            DockerRemoteRequest.$$$reportNull$$$0(8);
        }
        progressIndicator.addSystemLine(DockerBundle.message((String)"DockerEnvironmentFactory.progress.text.preparing.docker.target", (Object[])new Object[0]));
        if (this.mySaveFilesBeforeStartingProcess) {
            WriteAction.runAndWait(() -> {
                Project project = this.myDocker.getProject();
                if (project != null) {
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                }
                FileDocumentManager.getInstance().saveAllDocuments();
            });
        }
        try {
            agentImage = this.prepareImageRuntime(progressIndicator);
        }
        catch (ServerRuntimeException e) {
            throw new RuntimeException(e);
        }
        try {
            String runCliOptions = this.myRunCliOptions != null ? this.myRunCliOptions : DockerRunOptionsSubstitutions.expandPathsInRunCliOptions(this.getConfiguration().getValues().getContainerConfig().getRunCliOptions(), this.myDocker.getProject());
            List<DockerVolumeBinding> bindings = this.prepareAgentVolumes(progressIndicator);
            List<DockerVolumesFrom> volumesFromList = this.getVolumesFromList();
            DockerEnvironment environment = DockerEnvironment.create(this.myDocker, agentImage, this, runCliOptions, bindings, volumesFromList, this.myEnvironmentVariables, progressIndicator);
            this.environmentPrepared(environment, progressIndicator);
            dockerEnvironment = environment;
        }
        catch (ServerRuntimeException | IOException e) {
            throw new RuntimeException(e);
        }
        if (dockerEnvironment == null) {
            DockerRemoteRequest.$$$reportNull$$$0(9);
        }
        return dockerEnvironment;
    }

    @NotNull
    private DockerAgentImage prepareImageRuntime(@NotNull TargetProgressIndicator indicator) throws ServerRuntimeException {
        String imageTagOrId;
        DockerAgentImage agentImage;
        if (indicator == null) {
            DockerRemoteRequest.$$$reportNull$$$0(10);
        }
        if ((agentImage = this.myDocker.findImageByNameOrId(imageTagOrId = this.isBuildNotPull() ? this.getBuildImageConfig().getBuiltImageTag() : this.getPullImageConfig().getTagToPull())) == null || this.shouldRebuildEveryTime()) {
            agentImage = this.forceRecreateImage(indicator);
        }
        if (agentImage == null) {
            throw new RuntimeException(DockerBundle.message((String)"DockerEnvironmentFactory.error.cant.find.image", (Object[])new Object[]{imageTagOrId}));
        }
        DockerAgentImage dockerAgentImage = agentImage;
        if (dockerAgentImage == null) {
            DockerRemoteRequest.$$$reportNull$$$0(11);
        }
        return dockerAgentImage;
    }

    private DockerTargetEnvironmentConfiguration.PullImageConfig getPullImageConfig() {
        return this.myTargetConfiguration.getValues().getPullImageConfig();
    }

    private boolean shouldRebuildEveryTime() {
        return this.isBuildNotPull() && this.getBuildImageConfig().getRebuildEveryTime();
    }

    private DockerTargetEnvironmentConfiguration.BuildImageConfig getBuildImageConfig() {
        return this.myTargetConfiguration.getValues().getBuildImageConfig();
    }

    private boolean isBuildNotPull() {
        return this.myTargetConfiguration.getValues().getBuildNotPull();
    }

    @Nullable
    private DockerAgentImage forceRecreateImage(final @NotNull TargetProgressIndicator indicator) throws ServerRuntimeException {
        if (indicator == null) {
            DockerRemoteRequest.$$$reportNull$$$0(12);
        }
        class PrintToIndicator
        implements Consumer<String> {
            private volatile boolean myHadRecentOutput = true;

            PrintToIndicator() {
            }

            @Override
            public void accept(@NlsSafe String text) {
                text = StringUtil.trimEnd((String)text, (char)'\n');
                indicator.addText(text, (Key)ProcessOutputType.STDOUT);
                this.myHadRecentOutput = true;
            }

            public void reset() {
                this.myHadRecentOutput = false;
            }

            public boolean hasRecentOutput() {
                return this.myHadRecentOutput;
            }
        }
        PrintToIndicator printToIndicator = new PrintToIndicator();
        TtySink ttySink = TtySink.wrapNonTty(printToIndicator);
        PrepareImageOperation preparation = this.isBuildNotPull() ? new BuildImageOperation(this.myDocker.getProject(), this.myTargetConfiguration, this.myDocker, ttySink) : new PullImageOperation(this.myDocker, this.getPullImageConfig().getTagToPull(), ttySink);
        LanguageRuntimeConfiguration firstLanguage = (LanguageRuntimeConfiguration)ContainerUtil.getFirstItem((List)this.myTargetConfiguration.getRuntimes().resolvedConfigs());
        CompletableFuture<DockerAgentImage> imagePromise = preparation.perform(firstLanguage);
        DockerAgentImage image = null;
        while (true) {
            try {
                image = imagePromise.get(5000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | TimeoutException ignored) {
                if (!printToIndicator.hasRecentOutput()) break;
                printToIndicator.reset();
                continue;
            }
            catch (ExecutionException e) {
                throw new ServerRuntimeException((Throwable)e);
            }
            break;
        }
        return image;
    }

    @NotNull
    public List<DockerVolumesFrom> getVolumesFromList() {
        return new ArrayList<DockerVolumesFrom>(this.myVolumesFromList);
    }

    @ApiStatus.Experimental
    public void addVolumesFrom(@NotNull DockerVolumesFrom volumesFrom2) {
        if (volumesFrom2 == null) {
            DockerRemoteRequest.$$$reportNull$$$0(13);
        }
        this.myVolumesFromList.add(volumesFrom2);
    }

    private String getRemoteAllVolumesRoot() {
        if (this.myVolumesRoot == null) {
            this.myVolumesRoot = "/tmp/" + String.valueOf(UUID.randomUUID());
        }
        return this.myVolumesRoot;
    }

    public void setSaveFilesBeforeStartingProcess(boolean saveFilesBeforeStartingProcess) {
        this.mySaveFilesBeforeStartingProcess = saveFilesBeforeStartingProcess;
    }

    private static String resolveRemotePath(@NotNull TargetEnvironmentRequest.Volume volume2, @NotNull String absolutePathToRoot, @NotNull String pathFromRoot) {
        if (volume2 == null) {
            DockerRemoteRequest.$$$reportNull$$$0(14);
        }
        if (absolutePathToRoot == null) {
            DockerRemoteRequest.$$$reportNull$$$0(15);
        }
        if (pathFromRoot == null) {
            DockerRemoteRequest.$$$reportNull$$$0(16);
        }
        char separator = volume2.getPlatform().fileSeparator;
        return StringUtil.trimTrailing((String)absolutePathToRoot, (char)separator) + separator + pathFromRoot;
    }

    @ApiStatus.Internal
    public void setRunCliOptions(@Nullable String runCliOptions) {
        this.myRunCliOptions = runCliOptions;
    }

    @ApiStatus.Internal
    public void setEnvironmentVariables(@NotNull Map<String, String> envs) {
        if (envs == null) {
            DockerRemoteRequest.$$$reportNull$$$0(17);
        }
        this.myEnvironmentVariables = Map.copyOf(envs);
    }

    static DockerVolumeBinding safeVolumeBinding(String containerPath, String localPath) {
        return new DockerVolumeBindingImpl(containerPath, UnixPathUtil.toUnixPath(localPath), false);
    }

    private static Logger getLogger() {
        return Logger.getInstance(DockerRemoteRequest.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uploadVolumes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadVolumes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPortBindings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPortBindings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/target/DockerRemoteRequest";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumesFrom";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volume";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePathToRoot";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFromRoot";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVolume";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVolume";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareEnvironment";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareImageRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareImageRuntime";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forceRecreateImage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addVolumesFrom";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveRemotePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setEnvironmentVariables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 9, 11 -> new IllegalStateException(string);
        };
    }

    private static class DockerTargetVolume
    implements TargetEnvironmentRequest.Volume {
        private final DockerRemoteRequest myMainRequest;
        private final String myRemoteRoot;
        private final String myVolumeId;
        private final boolean myIsTemporary;
        private final Map<String, UploadToTargetValue> myUploads;

        DockerTargetVolume(@NotNull DockerRemoteRequest request2, @NotNull String remoteRoot, boolean temporary) {
            if (request2 == null) {
                DockerTargetVolume.$$$reportNull$$$0(0);
            }
            if (remoteRoot == null) {
                DockerTargetVolume.$$$reportNull$$$0(1);
            }
            this.myUploads = new LinkedHashMap<String, UploadToTargetValue>();
            this.myMainRequest = request2;
            this.myRemoteRoot = remoteRoot;
            this.myVolumeId = remoteRoot + "@" + Integer.toHexString(System.identityHashCode(this));
            this.myIsTemporary = temporary;
        }

        boolean isTemporary() {
            return this.myIsTemporary;
        }

        @NotNull
        public String getVolumeId() {
            String string = this.myVolumeId;
            if (string == null) {
                DockerTargetVolume.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Platform getPlatform() {
            Platform platform2 = this.myMainRequest.getTargetPlatform().getPlatform();
            if (platform2 == null) {
                DockerTargetVolume.$$$reportNull$$$0(3);
            }
            return platform2;
        }

        @NotNull
        public TargetValue<String> createUpload(@NotNull String localPath) {
            if (localPath == null) {
                DockerTargetVolume.$$$reportNull$$$0(4);
            }
            TargetValue targetValue = (TargetValue)this.myUploads.computeIfAbsent(localPath, p -> UploadToTargetValue.forLocalPath(this, p));
            if (targetValue == null) {
                DockerTargetVolume.$$$reportNull$$$0(5);
            }
            return targetValue;
        }

        public List<DockerVolumeBinding> setupVolumes(TargetProgressIndicator indicator) {
            ArrayList<DockerVolumeBinding> result2 = new ArrayList<DockerVolumeBinding>();
            Map<File, List<UploadToTargetValue>> groupedByContainerPoint = this.myUploads.values().stream().collect(Collectors.groupingBy(UploadToTargetValue::getContainerFolder));
            int idx = 0;
            for (Map.Entry<File, List<UploadToTargetValue>> nextEntry : groupedByContainerPoint.entrySet()) {
                String nextContainerPath;
                if (groupedByContainerPoint.size() == 1) {
                    nextContainerPath = this.myRemoteRoot;
                } else {
                    String groupRoot = DockerRemoteRequest.resolveRemotePath(this, this.myRemoteRoot, String.valueOf(idx));
                    nextContainerPath = DockerRemoteRequest.resolveRemotePath(this, groupRoot, nextEntry.getKey().getName());
                }
                DockerVolumeBinding agentVolume = DockerRemoteRequest.safeVolumeBinding(nextContainerPath, nextEntry.getKey().getPath());
                indicator.addSystemLine(DockerBundle.message((String)"progress.text.docker.upload.volume.progress.message", (Object[])new Object[]{agentVolume.getHostPath(), agentVolume.getContainerPath()}));
                result2.add(agentVolume);
                for (UploadToTargetValue nextUpload : nextEntry.getValue()) {
                    nextUpload.agentVolumeAttached(agentVolume);
                }
                ++idx;
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteRoot";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$DockerTargetVolume";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$DockerTargetVolume";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVolumeId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlatform";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createUpload";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createUpload";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5 -> new IllegalStateException(string);
            };
        }
    }

    static class LocalPortTargetValue
    implements TargetValue<HostPort> {
        private final AsyncPromise<HostPort> myPromise = new AsyncPromise();
        private final int myLocalPort;

        LocalPortTargetValue(int localPort) {
            this.myLocalPort = localPort;
        }

        int getLocalPort() {
            return this.myLocalPort;
        }

        public Promise<HostPort> getLocalValue() {
            return this.myPromise;
        }

        public Promise<HostPort> getTargetValue() {
            return this.myPromise;
        }

        void resolve(@NotNull String host) {
            if (host == null) {
                LocalPortTargetValue.$$$reportNull$$$0(0);
            }
            this.myPromise.setResult((Object)new HostPort(host, this.myLocalPort));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/docker/remote/run/target/DockerRemoteRequest$LocalPortTargetValue", "resolve"));
        }
    }

    static class BoundPortValue
    extends DeferredLocalTargetValue<Integer> {
        private static final int NOT_BOUND = -1;

        BoundPortValue(int containerPort) {
            super((Object)containerPort);
        }

        int getContainerPort() {
            try {
                Integer port = (Integer)this.getTargetValue().blockingGet(0);
                return port != null ? port : -1;
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IllegalStateException("Port has not been resolved yet", e);
            }
        }

        void localPortBound(@Nullable DockerPortBinding portBinding) {
            Integer resolvedValue;
            Integer n = resolvedValue = portBinding == null ? null : portBinding.getHostPort();
            if (resolvedValue != null) {
                super.resolve((Object)resolvedValue);
                return;
            }
            try {
                int remotePort = this.getContainerPort();
                DockerRemoteRequest.getLogger().error("Requested port " + remotePort + " is not bound by container: " + String.valueOf(portBinding));
            }
            catch (RuntimeException e) {
                DockerRemoteRequest.getLogger().error("Remote port was not set, port binding can't be found", (Throwable)e);
            }
        }

        DockerPortBindingImpl asDockerPortBinding() {
            DockerPortBindingImpl result2 = new DockerPortBindingImpl();
            result2.setContainerPort(this.getContainerPort());
            return result2;
        }
    }

    private static final class UploadToTargetValue
    extends DeferredTargetValue<String> {
        private final TargetEnvironmentRequest.Volume myVolume;
        private final File myLocalFile;

        static UploadToTargetValue forLocalPath(@NotNull TargetEnvironmentRequest.Volume volume2, @NotNull String localPath) {
            if (volume2 == null) {
                UploadToTargetValue.$$$reportNull$$$0(0);
            }
            if (localPath == null) {
                UploadToTargetValue.$$$reportNull$$$0(1);
            }
            try {
                File canonicalFile = new File(FileUtil.toSystemDependentName((String)localPath)).getCanonicalFile();
                return new UploadToTargetValue(volume2, canonicalFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Can't resolve path: " + localPath, e);
            }
        }

        private UploadToTargetValue(@NotNull TargetEnvironmentRequest.Volume volume2, @NotNull File localFile) {
            if (volume2 == null) {
                UploadToTargetValue.$$$reportNull$$$0(2);
            }
            if (localFile == null) {
                UploadToTargetValue.$$$reportNull$$$0(3);
            }
            super((Object)localFile.getAbsolutePath());
            this.myVolume = volume2;
            this.myLocalFile = localFile;
        }

        void agentVolumeAttached(@NotNull DockerVolumeBinding agentVolume) {
            if (agentVolume == null) {
                UploadToTargetValue.$$$reportNull$$$0(4);
            }
            String pathInVolume = this.myLocalFile.isDirectory() ? "" : this.myLocalFile.getName();
            String remotePath = DockerRemoteRequest.resolveRemotePath(this.myVolume, agentVolume.getContainerPath(), pathInVolume);
            super.resolve((Object)remotePath);
        }

        @NotNull
        File getContainerFolder() {
            File file = this.myLocalFile.isDirectory() ? this.myLocalFile : this.myLocalFile.getParentFile();
            if (file == null) {
                UploadToTargetValue.$$$reportNull$$$0(5);
            }
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "volume";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentVolume";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$UploadToTargetValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$UploadToTargetValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainerFolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forLocalPath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "agentVolumeAttached";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

