/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexExecNode;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.literal.LiteralRegexExecNodeGen;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.result.RegexResult;
import com.oracle.truffle.regex.tregex.nodes.input.InputEndsWithNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputEqualsNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputStartsWithNode;
import com.oracle.truffle.regex.tregex.parser.ast.InnerLiteral;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.PreCalcResultVisitor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public abstract class LiteralRegexExecNode
extends RegexExecNode
implements JsonConvertible {
    @Node.Child
    LiteralRegexExecImplNode implNode;

    public LiteralRegexExecNode(RegexLanguage language, RegexAST ast, LiteralRegexExecImplNode implNode) {
        super(language, ast.getSource(), ast.getFlags().isEitherUnicode());
        this.implNode = this.insert(implNode);
    }

    @Override
    protected final String getEngineLabel() {
        return "literal:" + this.implNode.getImplName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("method", this.implNode.getImplName()), Json.prop("literal", DebugUtil.escapeString(this.implNode.getLiteral())), Json.prop("factory", this.implNode.resultFactory));
    }

    @Override
    public abstract RegexResult execute(VirtualFrame var1, TruffleString var2, int var3);

    @Specialization
    RegexResult doTString(TruffleString input, int fromIndex, @Cached TruffleString.MaterializeNode materializeNode) {
        materializeNode.execute(input, this.getEncoding().getTStringEncoding());
        return this.implNode.execute(input, fromIndex, this.getEncoding());
    }

    public static LiteralRegexExecNode create(RegexLanguage language, RegexAST ast, LiteralRegexExecImplNode implNode) {
        return LiteralRegexExecNodeGen.create(language, ast, implNode);
    }

    static abstract class LiteralRegexExecImplNode
    extends Node {
        private final PreCalculatedResultFactory resultFactory;

        protected LiteralRegexExecImplNode(PreCalcResultVisitor preCalcResultVisitor) {
            this.resultFactory = preCalcResultVisitor.isBooleanMatch() ? null : preCalcResultVisitor.getResultFactory();
        }

        abstract String getImplName();

        String getLiteral() {
            return "";
        }

        final int inputLength(TruffleString input) {
            return ((RegexExecNode)this.getParent()).inputLength(input);
        }

        final RegexResult createFromStart(int start) {
            return this.resultFactory == null ? RegexResult.getBooleanMatchInstance() : this.resultFactory.createFromStart(start);
        }

        final RegexResult createFromEnd(int end) {
            return this.resultFactory == null ? RegexResult.getBooleanMatchInstance() : this.resultFactory.createFromEnd(end);
        }

        abstract RegexResult execute(TruffleString var1, int var2, Encodings.Encoding var3);
    }

    public static abstract class RegionMatches
    extends NonEmptyLiteralRegexExecNode {
        public RegionMatches(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "regionMatches";
        }

        @Specialization
        protected RegexResult run(TruffleString input, int fromIndex, Encodings.Encoding encoding, @Cached(inline=true) InputRegionMatchesNode regionMatchesNode) {
            if (regionMatchesNode.execute(this, input, fromIndex, this.literal.getLiteralContent(), 0, this.literalLength, this.literal.getMaskContent(), encoding)) {
                return this.createFromStart(fromIndex);
            }
            return RegexResult.getNoMatchInstance();
        }
    }

    public static abstract class Equals
    extends NonEmptyLiteralRegexExecNode {
        public Equals(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "equals";
        }

        @Specialization
        protected RegexResult run(TruffleString input, int fromIndex, Encodings.Encoding encoding, @Cached(inline=true) InputEqualsNode equalsNode) {
            if (fromIndex == 0 && equalsNode.execute(this, input, this.literal.getLiteralContent(), this.literal.getMaskContent(), encoding)) {
                return this.createFromStart(0);
            }
            return RegexResult.getNoMatchInstance();
        }
    }

    public static abstract class EndsWith
    extends NonEmptyLiteralRegexExecNode {
        private final boolean sticky;

        public EndsWith(PreCalcResultVisitor preCalcResultVisitor, boolean sticky) {
            super(preCalcResultVisitor);
            this.sticky = sticky;
        }

        @Override
        protected String getImplName() {
            return "endsWith";
        }

        @Specialization
        protected RegexResult run(TruffleString input, int fromIndex, Encodings.Encoding encoding, @Cached(inline=true) InputEndsWithNode endsWithNode) {
            int matchStart = this.inputLength(input) - this.literalLength;
            if ((this.sticky ? fromIndex == matchStart : fromIndex <= matchStart) && endsWithNode.execute(this, input, this.literal.getLiteralContent(), this.literal.getMaskContent(), encoding)) {
                return this.createFromEnd(this.inputLength(input));
            }
            return RegexResult.getNoMatchInstance();
        }
    }

    public static abstract class StartsWith
    extends NonEmptyLiteralRegexExecNode {
        public StartsWith(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "startsWith";
        }

        @Specialization
        protected RegexResult run(TruffleString input, int fromIndex, Encodings.Encoding encoding, @Cached(inline=true) InputStartsWithNode startsWithNode) {
            if (fromIndex == 0 && startsWithNode.execute(this, input, this.literal.getLiteralContent(), this.literal.getMaskContent(), encoding)) {
                return this.createFromStart(0);
            }
            return RegexResult.getNoMatchInstance();
        }
    }

    public static abstract class IndexOfString
    extends NonEmptyLiteralRegexExecNode {
        public IndexOfString(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "indexOfString";
        }

        @Specialization
        protected RegexResult run(TruffleString input, int fromIndex, Encodings.Encoding encoding, @Cached(inline=true) InputIndexOfStringNode indexOfStringNode) {
            int start = indexOfStringNode.execute(this, input, fromIndex, this.inputLength(input), this.literal.getLiteralContent(), this.literal.getMaskContent(), encoding);
            if (start < 0) {
                return RegexResult.getNoMatchInstance();
            }
            return this.createFromStart(start);
        }
    }

    static abstract class NonEmptyLiteralRegexExecNode
    extends LiteralRegexExecImplNode {
        protected final int literalLength;
        protected final InnerLiteral literal;

        NonEmptyLiteralRegexExecNode(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
            this.literalLength = preCalcResultVisitor.getLiteral().encodedLength();
            this.literal = new InnerLiteral(preCalcResultVisitor.getLiteral(), preCalcResultVisitor.getMask(), 0);
        }

        @Override
        protected String getLiteral() {
            return this.literal.getLiteral().toString();
        }
    }

    public static final class EmptyEquals
    extends EmptyLiteralRegexExecNode {
        public EmptyEquals(PreCalcResultVisitor preCalcResultVisitor, boolean mustAdvance) {
            super(preCalcResultVisitor, mustAdvance);
        }

        @Override
        protected String getImplName() {
            return "emptyEquals";
        }

        @Override
        protected RegexResult execute(TruffleString input, int fromIndex, Encodings.Encoding encoding) {
            assert (fromIndex <= this.inputLength(input));
            return this.inputLength(input) == 0 && !this.mustAdvance ? this.createFromStart(0) : RegexResult.getNoMatchInstance();
        }
    }

    public static final class EmptyEndsWith
    extends EmptyLiteralRegexExecNode {
        private final boolean sticky;

        public EmptyEndsWith(PreCalcResultVisitor preCalcResultVisitor, boolean sticky, boolean mustAdvance) {
            super(preCalcResultVisitor, mustAdvance);
            this.sticky = sticky;
        }

        @Override
        protected String getImplName() {
            return "emptyEndsWith";
        }

        @Override
        protected RegexResult execute(TruffleString input, int fromIndex, Encodings.Encoding encoding) {
            assert (fromIndex <= this.inputLength(input));
            if (this.sticky && fromIndex < this.inputLength(input) || this.mustAdvance && fromIndex == this.inputLength(input)) {
                return RegexResult.getNoMatchInstance();
            }
            return this.createFromEnd(this.inputLength(input));
        }
    }

    public static final class EmptyStartsWith
    extends EmptyLiteralRegexExecNode {
        public EmptyStartsWith(PreCalcResultVisitor preCalcResultVisitor, boolean mustAdvance) {
            super(preCalcResultVisitor, mustAdvance);
        }

        @Override
        protected String getImplName() {
            return "emptyStartsWith";
        }

        @Override
        protected RegexResult execute(TruffleString input, int fromIndex, Encodings.Encoding encoding) {
            return fromIndex == 0 && !this.mustAdvance ? this.createFromStart(0) : RegexResult.getNoMatchInstance();
        }
    }

    public static final class EmptyIndexOf
    extends EmptyLiteralRegexExecNode {
        public EmptyIndexOf(PreCalcResultVisitor preCalcResultVisitor, boolean mustAdvance) {
            super(preCalcResultVisitor, mustAdvance);
        }

        @Override
        protected String getImplName() {
            return "emptyIndexOf";
        }

        @Override
        protected RegexResult execute(TruffleString input, int fromIndex, Encodings.Encoding encoding) {
            if (this.mustAdvance) {
                if (fromIndex < this.inputLength(input)) {
                    return this.createFromStart(fromIndex + 1);
                }
                return RegexResult.getNoMatchInstance();
            }
            return this.createFromStart(fromIndex);
        }
    }

    static abstract class EmptyLiteralRegexExecNode
    extends LiteralRegexExecImplNode {
        protected final boolean mustAdvance;

        EmptyLiteralRegexExecNode(PreCalcResultVisitor preCalcResultVisitor, boolean mustAdvance) {
            super(preCalcResultVisitor);
            this.mustAdvance = mustAdvance;
        }
    }
}

