// Copyright 2000-2020 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

/**
 * Extension point to filter out candidates in case of multiple declarations.
 * For example, a point may be a reference and candidates are reference targets.
 * Or, a point may be a {@code PhpClass} and candidates are all {@code PhpClasses} with the same FQN.
 */
public interface PhpMultipleDeclarationFilter {

  ExtensionPointName<PhpMultipleDeclarationFilter> EP_NAME = ExtensionPointName.create("com.jetbrains.php.referenceResolver2");

  /**
   * Called in case there are multiple candidates for the point.
   *
   * @param point    place, from which declarations search is called
   * @param candidates all declarations resolved by PhpStorm
   * @return filtered declarations applicable in context based on point, or original candidates if no filtering should be performed
   */
  <E extends PhpNamedElement> Collection<E> filter(@NotNull PsiElement point, Collection<E> candidates);
}
